#include <stdio.h>
#include <conio.h>

/***************************************************
* proxy1.c: a very simple program to extract proxy *
* addresses and port numbers from a list           *
*                                                  *
* written by lordavatar,2004                       *
***************************************************/

FILE *original_file,*result_file;
unsigned char c,flag=0;

main(int argc,char *argv[])
{
	if (argc!=2)
	{
		printf("Program usage: proxy1 <original file> <result file>\n");
		return;
	}
	original_file=fopen(argv[1],"rb");
	if (original_file==NULL)
	{
		printf("%s not found.\n",argv[1]);
		return;
	}
	result_file=fopen(argv[2],"rb");
	if (result_file!=NULL)
	{
		printf("%s already exists. Overwrite? (y/n)\n",argv[1]);
		if (getch()!='y')
		{
			fclose(original_file);
			return;
		}
	}
	result_file=fopen(argv[2],"wb");
	if (result_file==NULL)
	{
		fclose(original_file);
		printf("%s can not be created.\n",argv[1]);
		return;
	}	
	while (!feof(original_file))
	{
		c=fgetc(original_file);
		switch (flag)
		{
			case 0:
			{
				if (c==' ') //if we find a space,then port number is coming
				{
					flag++;
					fputc(':',result_file);
					break;
				}
			}
			case 1:
			{
				if (c==' ') //if we find a space again, then unneccessary data...
				{
					flag++;
					fputc(0x0d,result_file);
					fputc(0x0a,result_file);
					break;
				}
				fputc(c,result_file);
			}
			case 2:
			{
				if (c==0x0d) //...until the beginning of the next line
				{
					flag=0;
					fgetc(original_file);
				}
			}
		}
	}
	fclose(original_file);
	fclose(result_file);
}
