unit find;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ActnList;

type
  TFindForm = class(TForm)
    FindEdit: TEdit;
    FindLabel: TLabel;
    FindButton: TButton;
    CloseButton: TButton;    
    OriginalBox: TCheckBox;
    TranslatedBox: TCheckBox;
    RegistryBox: TCheckBox;
    MaskOrdBox: TCheckBox;
    ActionList: TActionList;
    FindNextAction: TAction;
    procedure FindNextActionUpdate(Sender: TObject);
    procedure FindNextActionExecute(Sender: TObject);
    procedure CloseButtonClick(Sender: TObject);
  end;

var
  FindForm: TFindForm;

implementation

{$R *.DFM}

procedure TFindForm.FindNextActionUpdate(Sender: TObject);
begin
  FindNextAction.Enabled := Length(Trim(FindEdit.Text)) > 0
end;

procedure TFindForm.FindNextActionExecute(Sender: TObject);
begin
  ModalResult := mrOk
end;

procedure TFindForm.CloseButtonClick(Sender: TObject);
begin
  ModalResult := mrCancel
end;

end.
