unit about;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls;

type
  TAboutForm = class(TForm)
    Image: TImage;
    OKButton: TButton;
    MailLabel: TLabel;
    HttpLabel: TLabel;
    VersionLabel: TLabel;
    procedure MailLabelClick(Sender: TObject);
    procedure MailLabelMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure FormCreate(Sender: TObject);
  end;

var
  AboutForm: TAboutForm;

implementation
{ ========================================================================= }
uses
  ShellApi;
{$R *.dfm}

procedure TAboutForm.MailLabelClick(Sender: TObject);
begin
  if not (Sender is TLabel) then Exit;
  ShellExecute(0, nil, PChar((Sender as TLabel).Caption), nil, nil, 0)
end;

procedure TAboutForm.MailLabelMouseMove(Sender: TObject;
  Shift: TShiftState; X, Y: Integer);
begin
  if not (Sender is TLabel) then Exit;
  if (X < 0) or (Y < 0) or
     (X >= TControl(Sender).Width) or (Y >= TControl(Sender).Height) then begin
    SetCaptureControl(nil);
    TLabel(Sender).Font.Style := TLabel(Sender).Font.Style - [fsUnderline];
    Exit;
  end;
  SetCaptureControl(TControl(Sender));
  TLabel(Sender).Font.Style := TLabel(Sender).Font.Style + [fsUnderline];
end;

procedure TAboutForm.FormCreate(Sender: TObject);
var
  H: THandle;
  P: Pointer;
  W, L: Cardinal;
  C: array of Char;
  R: VS_FIXEDFILEINFO;
begin
  W := GetFileVersionInfoSize(PChar(Application.ExeName), H); SetLength(C, W);
  GetFileVersionInfo(PChar(Application.ExeName), 0, W, C);
  VerQueryValue(C, '\', P, L); R := VS_FIXEDFILEINFO(P^);
  VersionLabel.Caption := Format(VersionLabel.Caption, [
      HiWord(R.dwFileVersionMS),
      LoWord(R.dwFileVersionMS),
      HiWord(R.dwFileVersionLS),
      LoWord(R.dwFileVersionLS)])
end;
{ ========================================================================= }
end.

