var treeview;

function getCurrState() 
{
  var label = "currState="
  var labelLen = label.length
  var cLen = this.window.document.cookie.length
  var i = 0
  while (i < cLen) 
  {
    var j = i + labelLen
    if (this.window.document.cookie.substring(i,j) == label) 
    {
      var cEnd = this.window.document.cookie.indexOf(";",j)
      if (cEnd == -1) { cEnd = this.window.document.cookie.length }
      return unescape(this.window.document.cookie.substring(j,cEnd))
    }
    i++
  }
  return ""
}

// Add an entry to the database
function dbAdd(mother,display,URL,indent,top,newitem,greyitem) 
{
  this.db[this.total] = new Object;
  this.db[this.total].mother = mother
  this.db[this.total].display = display
  this.db[this.total].URL = URL
  this.db[this.total].indent = indent
  this.db[this.total].top = top
  this.db[this.total].newitem = newitem
  this.db[this.total].greyitem = greyitem
  this.total++
}

// Record current settings in cookie
function setCurrState(setting) 
{
  var expire = new Date();
  expire.setTime(expire.getTime() + ( 7*24*60*60*1000 ) ); // expire in 1 week
  this.window.document.cookie = "currState=" + escape(setting) + "; expires=" + expire.toGMTString();
}

// toggles an outline mother entry, storing new value in the cookie
function toggle(n) 
{
  if (n != 0) 
  {
    var newString = ""
    var expanded = this.current.substring(n-1,n) // of clicked item
    newString += this.current.substring(0,n-1)
    newString += expanded ^ 1 // Bitwise XOR clicked item
    newString += this.current.substring(n,this.current.length)
    this.setCurrState(newString) // write new state back to cookie

  }
}

// returns padded spaces (in mulTIPles of 2) for indenting
function pad(n) 
{
  var result = ""
  for (var i = 1; i <= n; i++) { result += "&nbsp;&nbsp;&nbsp;&nbsp;" }
  return result
}

// Expand everything
function explode() 
{
  this.current = "";
  initState="";
  for (var i = 1; i < this.db.length; i++) 
  { 
    initState += "1"
    this.current += "1"
  }
  this.setCurrState(initState);
  history.go(0);
}

// Collapse everything
function contract() 
{
  this.current = "";
  initState="";
  for (var i = 1; i < this.db.length; i++) 
  { 
    initState += "0"
    this.current += "0"
  }
  this.setCurrState(initState);
  history.go(0);
}

function tree_close() 
{
  window.parent.location = window.parent.content.location;
}




function draw_tree_view()
{


// Set the initial state if no current state or length changed
if (this.current == "" || this.current.length != (this.db.length-1)) {
  this.current = ""
  initState = ""
  for (i = 1; i < this.db.length; i++) { 
    initState += "0"
    this.current += "0"
    }
  this.setCurrState(initState)
  }
var prevIndentDisplayed = 0
var showMyDaughter = 0
// end --> <!--
var Outline=""
// cycle through each entry in the outline array
for (var i = 1; i < this.db.length; i++) {
  var currIndent = this.db[i].indent           // get the indent level
  var expanded = this.current.substring(i-1,i) // current state
  var top = this.db[i].top
  if (top == "") { top="content" }
  // display entry only if it meets one of three criteria
  if ((currIndent == 0 || currIndent <= prevIndentDisplayed || (showMyDaughter == 1 && (currIndent - prevIndentDisplayed == 1)))) {
  Outline += pad(currIndent)

  // Insert the appropriate GIF and HREF
  newitem = "";
  if (this.db[i].newitem) { newitem="_new"; }
  if (!(this.db[i].mother)) {
    Outline += "<IMG SRC=\"blank.gif\" WIDTH=16 HEIGHT=16 BORDER=0><IMG SRC=\"document" + newitem + ".gif\" WIDTH=16 HEIGHT=16 BORDER=0>"
    } 
  else { 
      if (this.current.substring(i-1,i) == 1) {
        Outline += "<A HREF=\"javascript:history.go(0)\" onMouseOver=\"window.parent.status=\'Click to collapse\';return true;\" onClick=\"treeview.toggle(" + i + ")\">"
        Outline += "<IMG SRC=\"minus.gif\" WIDTH=16 HEIGHT=16 BORDER=0><IMG SRC=\"open" + newitem + ".gif\" WIDTH=16 HEIGHT=16 BORDER=0>"
        Outline += "</A>"
       }
      else {
	    Outline += "<A HREF=\"javascript:history.go(0)\" onMouseOver=\"window.parent.status=\'Click to expand\';return true;\" onClick=\"treeview.toggle(" + i + ")\">"
        Outline += "<IMG SRC=\"plus.gif\" WIDTH=16 HEIGHT=16 BORDER=0><IMG SRC=\"closed" + newitem + ".gif\" WIDTH=16 HEIGHT=16 BORDER=0>"
        Outline += "</A>"
        }
      }
    Outline += "&nbsp;";
     
	if (this.db[i].URL == "" || this.db[i].URL == null) 
	{
		if (this.db[i].greyitem)
		{	
	   		Outline += "<font COLOR=#C0C0C0> " + this.db[i].display + "</font>"     // no link, just a listed item  
		}
		else
		{
       	Outline += " " + this.db[i].display      // no link, just a listed item  
		}
   }
   else 
   {
      Outline += " <A HREF=\"" + this.db[i].URL + "\" TARGET=\"" + top + "\">" + this.db[i].display + "</A>"
   }
	// Bold if at level 0
    if (currIndent == 0) { 
      Outline = "<B>" + Outline + "</B>"
      }
    Outline += "<BR>"
    prevIndentDisplayed = currIndent
    showMyDaughter = expanded
    // if (i == 1) { Outline = ""}
    if (this.db.length > 25) {
      this.window.document.write(Outline)
      Outline = ""
      }
    }
  }
this.window.document.write(Outline)
}


function TreeView(win)
{
  // Properties of treeview
  this.window = win;
  this.total = 1;
  this.db = new Array();

  // Get current cookie setting
  this.current = getCurrState();

 
  // Method of TreeView
  this.draw = draw_tree_view;
  this.explode = explode;
  this.contract = contract;
  this.tree_close  = tree_close;
  this.pad = pad;
  this.toggle = toggle;
  this.dbAdd = dbAdd;
  this.getCurrState = getCurrState;
  this.setCurrState = setCurrState;

  
}


