/*
 * Decompiled with CFR 0.152.
 */
package smp;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import smp.GetFile;
import smp.ListOfPages;
import smp.PageRecord;
import smp.SMPApplet;
import smp.SearchFile;

public class SiteSearch
extends Thread {
    private SMPApplet parent;
    private ListOfPages pages;
    private SearchFile searchFile;
    private GetFile getFile = new GetFile();

    private void scanFileForLinks(String currentFile, String fileText) {
        Vector links = this.searchFile.getVectorOfLinks(currentFile, fileText);
        int n = 0;
        while (n < links.size()) {
            String path = (String)links.elementAt(n);
            PageRecord pr = new PageRecord(path);
            this.pages.addPage(pr);
            this.parent.logger.addToLog("SiteSearch", "scanFileForLinks", "Added file to pages list: " + pr.path);
            ++n;
        }
    }

    public SiteSearch(SMPApplet par) {
        super("doSearch");
        this.parent = par;
    }

    private void scanFileForData(PageRecord pr, String fileContent) {
        pr.descriptionText = this.searchFile.getDescription(fileContent);
        pr.titleText = this.searchFile.getTitle(fileContent);
    }

    private int searchForKeywordsAndRecordNumberOfHits(Vector keywords, StringBuffer fileContent) {
        int numberOfHits = 0;
        if (this.parent.appletData.orSearch) {
            int n = 0;
            while (n != keywords.size()) {
                String keyword = (String)keywords.elementAt(n);
                numberOfHits += this.searchFile.containsKeyword(keyword, fileContent.toString());
                ++n;
            }
        } else {
            int n = 0;
            while (n < keywords.size()) {
                String keyword = (String)keywords.elementAt(n);
                int hits = this.searchFile.containsKeyword(keyword, fileContent.toString());
                if (hits > 0) {
                    numberOfHits += hits;
                } else {
                    numberOfHits = 0;
                    n = keywords.size();
                }
                ++n;
            }
        }
        return numberOfHits;
    }

    private void initialiseListOfPages() {
        String initialFiles = new String(this.parent.appletData.pagesToSearch);
        Vector<String> ifileNames = new Vector<String>();
        if (initialFiles.compareTo("") == 0) {
            ifileNames.addElement(this.parent.getDocumentBase().toString());
        } else if (initialFiles.indexOf(";") == 0) {
            ifileNames.addElement(initialFiles.toString());
        } else {
            char nextChar = ' ';
            StringBuffer filename = new StringBuffer(30);
            int n = 0;
            while (n != initialFiles.length()) {
                nextChar = initialFiles.charAt(n);
                if (nextChar == ';') {
                    ifileNames.addElement(filename.toString());
                    filename = new StringBuffer(30);
                } else {
                    filename.append(nextChar);
                }
                ++n;
            }
            if (!filename.toString().equals("")) {
                ifileNames.addElement(filename.toString());
            }
        }
        String ifile = new String();
        try {
            ifile = (String)ifileNames.elementAt(0);
            URL urlInitialFile = new URL(this.parent.getDocumentBase(), ifile);
            PageRecord pr = new PageRecord(urlInitialFile.toString());
            this.pages = new ListOfPages(this.parent, pr, this.parent.appletData.spider);
        }
        catch (MalformedURLException e) {
            this.parent.sendWarningMessage("Error in the format of the file: " + ifile + " it should be of the form http://my.site.co.uk/myfile.htm");
            this.parent.logger.addToLog("SiteSearch", "initialiseListOfPages", "MalformedURLException: " + ifile);
        }
        int n = 1;
        while (n != ifileNames.size()) {
            try {
                ifile = (String)ifileNames.elementAt(n);
                URL urlInitialFile = new URL(this.parent.getDocumentBase(), ifile);
                PageRecord pr = new PageRecord(urlInitialFile.toString());
                this.pages.addInitalPage(pr);
            }
            catch (MalformedURLException e) {
                this.parent.sendWarningMessage("Error in the format of the file: " + ifile + " it should be of the form http://my.site.co.uk/myfile.htm");
                this.parent.logger.addToLog("SiteSearch", "initialiseListOfPages", "MalformedURLException: " + ifile);
            }
            ++n;
        }
    }

    private Vector getVectorOfKeywords() {
        Vector<String> keywords = new Vector<String>();
        StringBuffer keyword = new StringBuffer(30);
        String keywordList = new String(this.parent.appletData.keywords);
        if (keywordList.compareTo("") == 0) {
            keywords.addElement(" ");
        } else if (keywordList.indexOf(" ") == 0) {
            keywords.addElement(keywordList.toString());
        } else {
            char nextChar = ' ';
            StringBuffer filename = new StringBuffer(30);
            int n = 0;
            while (n != keywordList.length()) {
                nextChar = keywordList.charAt(n);
                if (nextChar == ' ') {
                    keywords.addElement(keyword.toString());
                    keyword = new StringBuffer(30);
                } else {
                    keyword.append(nextChar);
                }
                ++n;
            }
            if (!keyword.toString().equals("")) {
                keywords.addElement(keyword.toString());
            }
        }
        return keywords;
    }

    public void run() {
        this.parent.logger.addToLog("SiteSearch", "run", "Start of Search");
        this.setPriority(1);
        this.searchFile = new SearchFile(this.parent);
        this.initialiseListOfPages();
        this.getVectorOfKeywords();
        int n = 1;
        while (n < this.pages.pageCounter + 1) {
            this.parent.showProgress(n * 100 / this.pages.pageCounter);
            PageRecord pr = this.pages.getItem(n);
            StringBuffer fileContent = this.getFile.getFileContent(this.parent, pr.path);
            Vector keys = this.getVectorOfKeywords();
            pr.numberOfKeywordHits = this.searchForKeywordsAndRecordNumberOfHits(keys, fileContent);
            if (pr.numberOfKeywordHits > 0) {
                this.scanFileForData(pr, fileContent.toString());
            }
            this.scanFileForLinks(pr.path, fileContent.toString());
            this.parent.logger.addToLog("SiteSearch", "run", "Stop search:" + this.parent.appletData.stopSearch);
            if (this.parent.appletData.stopSearch) {
                n = this.pages.pageCounter + 1;
                this.parent.appletData.stopSearch = false;
            }
            this.parent.logger.addToLog("SiteSearch", "run", "Processed file: " + pr.path);
            ++n;
        }
        this.parent.searchReport.display(this.pages);
        this.parent.reset();
        this.parent.logger.addToLog("SiteSearch", "run", "End of Search");
        this.parent.logger.printLog();
    }
}

