/*
 * Decompiled with CFR 0.152.
 */
package smp;

public class FileCache {
    private fileDetails[] cache;

    FileCache(int cacheSize) {
        this.cache = new fileDetails[cacheSize];
        int n = 0;
        while (n < this.cache.length) {
            this.cache[n] = new fileDetails();
            ++n;
        }
    }

    public void addFile(String fileName, String fileText) {
        int newFileLength = fileText.length();
        int indexOfSmallestFile = 0;
        int n = 0;
        while (n < this.cache.length) {
            if (this.cache[n].size < this.cache[indexOfSmallestFile].size) {
                indexOfSmallestFile = n;
            }
            ++n;
        }
        if (this.cache[indexOfSmallestFile].size < newFileLength) {
            this.cache[indexOfSmallestFile].path = fileName.toString();
            this.cache[indexOfSmallestFile].size = fileText.length();
            this.cache[indexOfSmallestFile].text = fileText.toString();
        }
    }

    public String getFile(String fpath) {
        String contents = new String("");
        int n = 0;
        while (n < this.cache.length) {
            if (this.cache[n].path.compareTo(fpath) == 0) {
                contents = this.cache[n].text;
            }
            ++n;
        }
        return contents;
    }

    public void dumpCacheToConsole() {
        int n = 0;
        while (n < this.cache.length) {
            System.out.println("\n\nCache Entry : " + n);
            System.out.println("path : " + this.cache[n].path);
            System.out.println("length : " + this.cache[n].size);
            System.out.println("text : " + this.cache[n].text);
            ++n;
        }
    }

    private class fileDetails {
        public String path;
        public String text;
        public int size;

        fileDetails() {
            FileCache.this.getClass();
            this.path = new String("");
            this.text = new String("");
        }
    }
}

