/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Button;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Label;
import java.awt.MediaTracker;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import javax.swing.Box;

public class Brick
extends Frame
implements ActionListener,
FocusListener,
ResultProcessor,
Bricktalk {
    private static final int FIELDSIZE = 23;
    private int screenwidth = 640;
    private int screenheight = 480;
    private int canvaswidth = 422;
    private int canvasheight = 480;
    private String subPicpath = "";
    private String masterPicname;
    private String masterPicpath;
    private String TIFname;
    private String TIFpath;
    private String Libname = "";
    private String Libpath = "";
    private int mwidth = 800;
    private int mheight = 800;
    private float minchwidth = 2.0f;
    private float minchheight = 2.0f;
    private int divx = 2;
    private int divy = 2;
    private int res = 100;
    private int maxsubpicuses = 200;
    private float pixelscaling = 1.0f;
    private static boolean inprogress = false;
    private static boolean firsterrfindpic;
    private Button Btest;
    private Button BloadmasterPic;
    private Button BloadsubPic;
    private Button BsaveTIFas;
    private Button BloadLibas;
    private TextField TFloadmasterPic;
    private TextField TFsaveTIFas;
    private TextField TFloadLibas;
    private posIntTextField ITFresolution;
    private posIntTextField ITFceiling;
    private posIntTextField ITFdivx;
    private posIntTextField ITFdivy;
    private posFloatTextField FTFinchw;
    private posFloatTextField FTFinchh;
    private Button BgoComposite;
    private BrickCanvas bc;
    private Masterpic mp;
    private Pic[] pics;
    private boolean masterfinished = false;
    private progressDialog pd;
    private waitDialog wd;

    public Brick() {
        super("Brick Mosaic Builder");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                Brick.this.dispose();
                System.exit(0);
            }
        });
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension dimension = toolkit.getScreenSize();
        this.screenwidth = dimension.width;
        this.screenheight = dimension.height;
        ((Component)this).setSize(this.screenwidth, this.screenheight);
        ((Component)this).setLocation(0, 0);
        this.canvaswidth = this.screenwidth * 2 / 3;
        this.canvasheight = this.screenheight;
        MenuBar menuBar = new MenuBar();
        Menu menu = new Menu("File");
        MenuItem menuItem = new MenuItem("Exit and save library changes");
        MenuItem menuItem2 = new MenuItem("Exit");
        menu.add(menuItem);
        menu.addSeparator();
        menu.add(menuItem2);
        Menu menu2 = new Menu("Library");
        MenuItem menuItem3 = new MenuItem("Build library");
        MenuItem menuItem4 = new MenuItem("Edit library");
        menu2.add(menuItem4);
        menu2.addSeparator();
        menu2.add(menuItem3);
        Menu menu3 = new Menu("Help");
        MenuItem menuItem5 = new MenuItem("Instructions");
        MenuItem menuItem6 = new MenuItem("About");
        menu3.add(menuItem5);
        menu3.add(menuItem6);
        menuBar.add(menu);
        menuBar.add(menu2);
        menuBar.add(menu3);
        this.setMenuBar(menuBar);
        menuItem.addActionListener(this);
        menuItem2.addActionListener(this);
        menuItem3.addActionListener(this);
        menuItem4.addActionListener(this);
        menuItem5.addActionListener(this);
        menuItem6.addActionListener(this);
        Panel panel = new Panel(new FlowLayout(0));
        this.BloadmasterPic = new Button("Master picture");
        panel.add(this.BloadmasterPic);
        this.BloadmasterPic.addActionListener(this);
        Panel panel2 = new Panel(new FlowLayout(0));
        this.TFloadmasterPic = new TextField("", 23);
        this.TFloadmasterPic.setEditable(false);
        panel2.add(this.TFloadmasterPic);
        Panel panel3 = new Panel(new FlowLayout(0));
        this.BloadLibas = new Button("Library name");
        panel3.add(this.BloadLibas);
        this.BloadLibas.addActionListener(this);
        Panel panel4 = new Panel(new FlowLayout(0));
        this.TFloadLibas = new TextField("", 23);
        this.TFloadLibas.setEditable(false);
        panel4.add(this.TFloadLibas);
        Panel panel5 = new Panel(new FlowLayout(0));
        this.BsaveTIFas = new Button("TIF name");
        panel5.add(this.BsaveTIFas);
        this.BsaveTIFas.addActionListener(this);
        Panel panel6 = new Panel(new FlowLayout(0));
        this.TFsaveTIFas = new TextField("", 23);
        this.TFsaveTIFas.setEditable(false);
        panel6.add(this.TFsaveTIFas);
        Panel panel7 = new Panel(new FlowLayout(0));
        panel7.add(new Label("Resolution:"));
        this.ITFresolution = new posIntTextField(this.res, 4);
        this.ITFresolution.addFocusListener(this);
        panel7.add(this.ITFresolution);
        panel7.add(new Label("dpi"));
        Panel panel8 = new Panel(new FlowLayout(0));
        panel8.add(new Label("Ceiling:"));
        this.ITFceiling = new posIntTextField(this.maxsubpicuses, 5);
        panel8.add(this.ITFceiling);
        panel8.add(new Label("uses/picture"));
        Panel panel9 = new Panel(new FlowLayout(0));
        panel9.add(new Label("Width:"));
        this.FTFinchw = new posFloatTextField(this.minchwidth, 3);
        this.FTFinchw.addFocusListener(this);
        panel9.add(this.FTFinchw);
        panel9.add(new Label("inches"));
        Panel panel10 = new Panel(new FlowLayout(0));
        panel10.add(new Label("Height:"));
        this.FTFinchh = new posFloatTextField(this.minchheight, 3);
        this.FTFinchh.addFocusListener(this);
        panel10.add(this.FTFinchh);
        panel10.add(new Label("inches"));
        Panel panel11 = new Panel(new FlowLayout(0));
        panel11.add(new Label("x:"));
        this.ITFdivx = new posIntTextField(this.divx, 3);
        panel11.add(this.ITFdivx);
        panel11.add(new Label("y:"));
        this.ITFdivy = new posIntTextField(this.divy, 3);
        panel11.add(this.ITFdivy);
        panel11.add(new Label("subpics"));
        Panel panel12 = new Panel(new FlowLayout(0));
        this.BgoComposite = new Button("Build composite");
        panel12.add(this.BgoComposite);
        this.BgoComposite.addActionListener(this);
        Box box = new Box(1);
        Box.createVerticalBox();
        box.add(panel);
        box.add(panel2);
        box.add(panel3);
        box.add(panel4);
        box.add(panel5);
        box.add(panel6);
        box.add(panel7);
        box.add(panel9);
        box.add(panel10);
        box.add(panel8);
        box.add(panel11);
        box.add(panel12);
        this.add((Component)box, "West");
        this.bc = new BrickCanvas(this, this.canvaswidth, this.canvasheight);
        this.add((Component)this.bc, "Center");
        MediaTracker mediaTracker = new MediaTracker(this);
        Image image = Toolkit.getDefaultToolkit().getImage("brick.jpg");
        mediaTracker.addImage(image, 1);
        try {
            mediaTracker.waitForID(1);
        }
        catch (InterruptedException interruptedException) {
            System.out.println("Brick: Died on wait for logo image.");
        }
        this.bc.ready(image);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        this.dobuttons(string);
        if (actionEvent.getSource() instanceof MenuItem) {
            this.domenu(actionEvent);
        }
    }

    private void calcmheight() {
        this.minchheight = (float)this.mheight * this.minchwidth / (float)this.mwidth;
        this.pixelscaling = this.minchwidth * (float)this.res / (float)this.mwidth;
        System.out.println("inch w/h: " + this.minchwidth + "," + this.minchheight + " pixel w/h: " + this.mwidth + "," + this.mheight + " pixscaling: " + this.pixelscaling);
    }

    private void calcmwidth() {
        this.minchwidth = (float)this.mwidth * this.minchheight / (float)this.mheight;
        this.pixelscaling = this.minchwidth * (float)this.res / (float)this.mwidth;
        System.out.println("inch w/h: " + this.minchwidth + "," + this.minchheight + " pixel w/h: " + this.mwidth + "," + this.mheight + " pixscaling: " + this.pixelscaling);
    }

    private void dobuttons(String string) {
        String string2;
        String string3;
        FileDialog fileDialog;
        Serializable serializable;
        Object object;
        if (string.equals("Build composite") && this.Libname != "" && this.masterPicname != null && this.TIFname != null && !inprogress) {
            boolean bl;
            inprogress = true;
            if (this.masterfinished && !(bl = LibFile.write(this, this.pics, String.valueOf(this.Libpath) + this.Libname))) {
                object = new errorDialog(this, this.screenwidth, this.screenheight, 0);
                ((Dialog)object).show();
            }
            this.masterfinished = false;
            firsterrfindpic = true;
            this.divx = this.ITFdivx.getValue();
            this.divy = this.ITFdivy.getValue();
            this.maxsubpicuses = this.ITFceiling.getValue();
            serializable = new Brickworker(this, this.bc, String.valueOf(this.masterPicpath) + this.masterPicname, this.subPicpath, this.divx, this.divy, this.pixelscaling, String.valueOf(this.TIFpath) + this.TIFname, this.res, String.valueOf(this.Libpath) + this.Libname, false, true, this.maxsubpicuses);
        } else if (string.equals("Build composite")) {
            Toolkit.getDefaultToolkit().beep();
        }
        if (string.equals("Master picture")) {
            fileDialog = new FileDialog((Frame)this, "Choose master image filename (JPG format)", 0);
            if (this.masterPicname != null) {
                string3 = this.masterPicname;
                fileDialog.setDirectory(this.masterPicpath);
                fileDialog.setFile(string3);
            }
            fileDialog.show();
            string3 = fileDialog.getFile();
            string2 = fileDialog.getDirectory();
            if (string3 != null && string2 != null) {
                if (this.masterfinished) {
                    boolean bl = LibFile.write(this, this.pics, String.valueOf(this.Libpath) + this.Libname);
                    if (!bl) {
                        object = new errorDialog(this, this.screenwidth, this.screenheight, 0);
                        ((Dialog)object).show();
                    }
                    this.masterfinished = false;
                }
                this.masterPicname = string3;
                this.masterPicpath = string2;
                this.TFloadmasterPic.setText(String.valueOf(this.masterPicpath) + this.masterPicname);
                serializable = new MediaTracker(this);
                object = Toolkit.getDefaultToolkit().getImage(String.valueOf(this.masterPicpath) + this.masterPicname);
                ((MediaTracker)serializable).addImage((Image)object, 1);
                try {
                    ((MediaTracker)serializable).waitForID(1);
                }
                catch (InterruptedException interruptedException) {
                    System.out.println("GUI: Unable to open master image for size check!");
                    return;
                }
                this.mwidth = ((Image)object).getWidth(null);
                this.mheight = ((Image)object).getHeight(null);
                if (this.mwidth == -1) {
                    this.errmasterreading();
                    this.masterPicname = null;
                    return;
                }
                this.calcmheight();
                this.calcmwidth();
                this.FTFinchh.setText(Float.toString(this.minchheight));
                this.FTFinchw.setText(Float.toString(this.minchwidth));
                object = ((Image)object).getScaledInstance(this.canvaswidth, -1, 1);
                ((MediaTracker)serializable).addImage((Image)object, 1);
                try {
                    ((MediaTracker)serializable).waitForID(1);
                }
                catch (InterruptedException interruptedException) {
                    System.out.println("GUI: Unable to scale master image for screen display!");
                    return;
                }
                this.bc.clear();
                this.bc.ready((Image)object);
            }
        }
        if (string.equals("TIF name")) {
            fileDialog = new FileDialog((Frame)this, "Choose composite TIF filename", 1);
            if (this.TIFname == null) {
                string3 = "comp.tif";
            } else {
                string3 = this.TIFname;
                fileDialog.setDirectory(this.TIFpath);
            }
            fileDialog.setFile(string3);
            fileDialog.show();
            string3 = fileDialog.getFile();
            string2 = fileDialog.getDirectory();
            if (string3 != null && string2 != null) {
                this.TIFname = string3;
                this.TIFpath = string2;
                this.TFsaveTIFas.setText(String.valueOf(this.TIFpath) + this.TIFname);
            }
        }
        if (string.equals("Library name")) {
            fileDialog = new FileDialog((Frame)this, "Choose subpicture Library filename", 0);
            if (this.Libname == null) {
                string3 = "subpic.lib";
            } else {
                string3 = this.Libname;
                fileDialog.setDirectory(this.Libpath);
            }
            fileDialog.setFile(string3);
            fileDialog.show();
            string3 = fileDialog.getFile();
            string2 = fileDialog.getDirectory();
            if (string3 != null && string2 != null) {
                if (this.masterfinished) {
                    boolean bl = LibFile.write(this, this.pics, String.valueOf(this.Libpath) + this.Libname);
                    if (!bl) {
                        object = new errorDialog(this, this.screenwidth, this.screenheight, 0);
                        ((Dialog)object).show();
                    }
                    this.masterfinished = false;
                }
                this.Libname = string3;
                this.Libpath = string2;
                this.TFloadLibas.setText(String.valueOf(this.Libpath) + this.Libname);
            }
        }
    }

    private void domenu(ActionEvent actionEvent) {
        Dialog dialog;
        boolean bl;
        MenuItem menuItem = (MenuItem)actionEvent.getSource();
        String string = menuItem.getLabel();
        if (string.equals("Exit and save library changes") && !inprogress) {
            if (this.masterfinished && !(bl = LibFile.write(this, this.pics, String.valueOf(this.Libpath) + this.Libname))) {
                dialog = new errorDialog(this, this.screenwidth, this.screenheight, 0);
                dialog.show();
            }
            this.dispose();
            System.exit(0);
        } else if (string.equals("Exit and save library changes")) {
            Toolkit.getDefaultToolkit().beep();
        }
        if (string.equals("Exit") && !inprogress) {
            this.dispose();
            System.exit(0);
        } else if (string.equals("Exit")) {
            Toolkit.getDefaultToolkit().beep();
        }
        if (string.equals("Build library") && !inprogress) {
            if (this.masterfinished) {
                bl = LibFile.write(this, this.pics, String.valueOf(this.Libpath) + this.Libname);
                if (!bl) {
                    dialog = new errorDialog(this, this.screenwidth, this.screenheight, 0);
                    dialog.show();
                }
                this.masterfinished = false;
            }
            Libinfo libinfo = new Libinfo(this.Libname, this.Libpath, this.subPicpath, inprogress);
            dialog = new LibDialog(this, libinfo);
            dialog.show();
        } else if (string.equals("Build library")) {
            Toolkit.getDefaultToolkit().beep();
        }
        if (string.equals("Edit library") && !inprogress) {
            if (this.masterfinished) {
                boolean bl2 = LibFile.write(this, this.pics, String.valueOf(this.Libpath) + this.Libname);
                if (!bl2) {
                    dialog = new errorDialog(this, this.screenwidth, this.screenheight, 0);
                    dialog.show();
                }
                this.masterfinished = false;
            }
            EditLibinfo editLibinfo = new EditLibinfo(this.Libname, this.Libpath, inprogress);
            dialog = new EditLibDialog(this, editLibinfo);
            dialog.show();
        } else if (string.equals("Edit library")) {
            Toolkit.getDefaultToolkit().beep();
        }
        if (string.equals("Instructions")) {
            helpDialog helpDialog2 = new helpDialog(this, false);
            helpDialog2.show();
        }
        if (string.equals("About")) {
            helpDialog helpDialog3 = new helpDialog(this, true);
            helpDialog3.show();
        }
    }

    public void endprogressDialog() {
        this.pd.endprogressDialog();
    }

    public void endwaitDialog() {
        this.wd.endwaitDialog();
    }

    public void errfindpic() {
        if (firsterrfindpic) {
            errorDialog errorDialog2 = new errorDialog(this, this.screenwidth, this.screenheight, 3);
            errorDialog2.show();
            firsterrfindpic = false;
        }
    }

    public void errlibreading() {
        errorDialog errorDialog2 = new errorDialog(this, this.screenwidth, this.screenheight, 1);
        this.endwaitDialog();
        if (this.pd != null) {
            this.pd.endprogressDialog();
        }
        errorDialog2.show();
    }

    public void errlibwriting() {
        errorDialog errorDialog2 = new errorDialog(this, this.screenwidth, this.screenheight, 0);
        this.pd.endprogressDialog();
        errorDialog2.show();
    }

    public void errmasterreading() {
        errorDialog errorDialog2 = new errorDialog(this, this.screenwidth, this.screenheight, 2);
        errorDialog2.show();
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        if (focusEvent.getComponent() == this.FTFinchw) {
            this.minchwidth = this.FTFinchw.getValue();
            this.calcmheight();
        }
        if (focusEvent.getComponent() == this.FTFinchh) {
            this.minchheight = this.FTFinchh.getValue();
            this.calcmwidth();
        }
        if (focusEvent.getComponent() == this.ITFresolution) {
            this.res = this.ITFresolution.getValue();
            this.calcmheight();
            this.calcmwidth();
        }
        this.FTFinchh.setText(Float.toString(this.minchheight));
        this.FTFinchw.setText(Float.toString(this.minchwidth));
    }

    public BufferedImage getbufimg(int n, int n2) {
        return (BufferedImage)this.createImage(n, n2);
    }

    public static void inprogress() {
        inprogress = true;
    }

    public static void main(String[] stringArray) {
        Brick brick = new Brick();
        brick.show();
        System.out.println("Main: main ending");
    }

    public static void notinprogress() {
        inprogress = false;
    }

    public void processResult(Dialog dialog, Object object) {
        Object object2;
        if (dialog instanceof LibDialog) {
            object2 = (Libinfo)object;
            this.subPicpath = ((Libinfo)object2).subPicpath;
            this.Libname = ((Libinfo)object2).Libname;
            this.Libpath = ((Libinfo)object2).Libpath;
            this.TFloadLibas.setText(String.valueOf(this.Libpath) + this.Libname);
        }
        if (dialog instanceof EditLibDialog) {
            object2 = (EditLibinfo)object;
            this.Libname = ((EditLibinfo)object2).Libname;
            this.Libpath = ((EditLibinfo)object2).Libpath;
            this.TFloadLibas.setText(String.valueOf(this.Libpath) + this.Libname);
        }
        if (dialog instanceof XsubpicDialog) {
            object2 = (Xsubpicinfo)object;
            this.pics = ((Xsubpicinfo)object2).pics;
        }
    }

    public void setmasterpic(Masterpic masterpic) {
        this.pics = LibFile.read(this, String.valueOf(this.Libpath) + this.Libname);
        this.mp = masterpic;
        if (this.pics != null) {
            this.masterfinished = true;
        } else {
            errorDialog errorDialog2 = new errorDialog(this, this.screenwidth, this.screenheight, 1);
            errorDialog2.show();
        }
    }

    public void setprogressDialog(int n) {
        this.pd.setprogressDialog(n);
    }

    public void setxy(int n, int n2, int n3, int n4) {
        if (!inprogress && this.masterfinished && n <= n3 && n2 <= n4) {
            int n5;
            int n6 = (int)((float)n3 / (float)this.divx);
            int n7 = (int)((float)n4 / (float)this.divy);
            int n8 = n / n6;
            int n9 = n2 / n7;
            System.out.println("setxy: mx,my " + n8 + ", " + n9);
            if (n8 >= this.divx) {
                n8 = this.divx - 1;
            }
            if (n9 >= this.divy) {
                n9 = this.divy - 1;
            }
            if ((n5 = this.mp.picnumber[n8][n9]) >= 0) {
                Xsubpicinfo xsubpicinfo = new Xsubpicinfo(this.pics, n5, this.Libname, this.Libpath);
                XsubpicDialog xsubpicDialog = new XsubpicDialog(this, xsubpicinfo);
                xsubpicDialog.show();
            }
        }
    }

    public void startprogressDialog(Brickworker brickworker) {
        this.pd = new progressDialog(this, brickworker, this.screenwidth, this.screenheight);
        this.pd.setprogressDialog(0);
        this.pd.show();
    }

    public void startwaitDialog() {
        if (this.wd == null) {
            this.wd = new waitDialog(this, this.screenwidth, this.screenheight);
        }
        this.wd.show();
    }
}

