<?php
# vim: set expandtab tabstop=4 shiftwidth=4 nowrap: 
# ---------------------------------------------------------------------------
# ConPresso 3.x - Content Management
# ---------------------------------------------------------------------------
#       Datei/File:  /_content/preference.php
#    Beschr./Desc.:  System-settings
#    Firma/Company:  Bartels Schoene GmbH & Co. KG
#                    Corrensstr. 80, 48149 Muenster, Germany
#              URL:  www.conpresso.de | www.bartels-schoene.de 
#     Autor/Author:  Tobias Musholt - musholt@bartels-schoene.de
#        Co-Author:  Thomas 'Balu' Walter - walter@bartels-schoene.de 
#                    Stefan Heitmann - heitmann@bartels-schoene.de
#                    Steffen Schoene - schoene@bartels-schoene.de
#                    Ralf Margott - margott@bartels-schoene.de (grafic)
#   Lizenz/Licence:  LICENCE.txt
#  Erstellt/Create:  21-02-2002 - Tobias Musholt
# Aenderung/Change:  25-02-2002 - Tobias Musholt: insert this programhead
#
# ---------------------------------------------------------------------------
# Copyright (c) 2001 - Bartels Schoene GmbH & Co. KG - All rights reserved.
# ---------------------------------------------------------------------------

    $zugang = 0;

    if (file_exists("../_cfg/const.php")) {
        require("../_cfg/const.php");
    } else { 
        require("../_cfg/const.php.dist");
    }

    require("../_include/check.php");
    require("../_include/header.php");

    echo "<div class=\"text\">";
    echo "<table width=\"".$WIDTH."\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\">\n";
    echo "<tr>\n";
    echo "<td class=\"header\">\n";
    echo "<b>".$LP_SystemPreference."</b>\n";
    echo "</td>\n";
    echo "</tr>\n";
    echo "<tr>\n";
    echo "<td class=\"text\"><br>\n";
    echo $LP_SystemPreferenceText."<br><br>\n";
    echo "</td>\n";
    echo "</tr>\n";
    echo "</table>\n";

    $lkey64 = base64_decode($lkey);
    $a = explode("##",$lkey64);
    
    $name  = $a[1];
    $name2 = base64_decode($System_lkey);

    if ( $name2 == '' ) {
        $name2 = 'no_user';
    }

    if ( isset($go) ) 
    {

        if ( $name == '' ) { 
            $name = 'no_name';
        }

        $c_datum = date ("Y-m-d H:m:i" ,time());
        $t_datum = date ("YmdHmi" ,time());

        $base_target = ereg_replace ( ",", " ",  $base_target);
        $base_target = ereg_replace ( ";", " ",  $base_target);
        $base_target = ereg_replace ( "\.", " ", $base_target);

        while ( eregi("  ", $base_target) ):
            echo "_".$base_target."_";
            $base_target = ereg_replace ( "  ", " ", $base_target);
        endwhile;


        if ( substr($base_url, -1) != '/' ) {
            $base_url .= '/';
        }

        if ( $name == $owner && substr($version_nr, 0, 1) == substr($a[0], 0, 1) ) {
            $licence_text = "<b>".$LP_LBusinessLicence." ".$owner."</b>";
            $business_licence = 1;
        } else {
            $licence_text = "<font color=\"".$color_orange."\"><b>".$LP_LFreeLicence."</b></font>";
            $business_licence = 0;
            $owner = "";
            $lkey = "";
        }

        $query = "replace into cpo_option ( id, project, release, release_email, system_email, admin_email, timeout, max_image, max_file, article_width, language, base_url, lkey, owner, send_pw, help, startnews, target, timestamp, c_time, changer ) values (\"1\", \"".$project."\", \"".$release."\", \"".$release_email."\", \"".$system_email."\", \"".$admin_email."\", \"".$timeout."\", \"".$max_image."\", \"".$max_file."\", \"".$article_width."\", \"".$language."\", \"".$base_url."\", \"".$lkey."\", \"".$owner."\", \"".$send_pw."\", \"".$help."\", \"".$startnews."\", \"".$base_target."\", \"".$timestamp."\", \"".$c_datum."\", \"".$SID_login."\")";
        DEBUG(1, $query, __FILE__, __LINE__);   
        $db = new DB;
        $db->query($query); 

        fkt_log($SID_login, $LOG_System, "");

        if ( $lizence != '' ) {
            $message = $LP_LicenceDataUpdate;
            require("../_include/message.php");
        } else {
            $message = $LP_SystemDataUpdate;
            require("../_include/message.php");
        }

    } else {

        $query = "SELECT * FROM cpo_option WHERE id != ''";
        DEBUG(2, $query, __FILE__, __LINE__);   
        $db = new DB;
        $db->query($query);

        if ($db->num_rows()>0)
        { 
            while($db->next_record()):
            
                $project        = $db->v("project");
                $release        = $db->v("release");
                $release_email  = $db->v("release_email");
                $system_email   = $db->v("system_email");
                $admin_email    = $db->v("admin_email");
                $timeout        = $db->v("timeout");
                $max_image      = $db->v("max_image");
                $max_file       = $db->v("max_file");
                $article_width  = $db->v("article_width");
                $language       = $db->v("language");
                $base_url       = $db->v("base_url");
                $lkey           = $db->v("lkey");
                $owner          = $db->v("owner");
                $send_pw        = $db->v("send_pw");
                $help           = $db->v("help");
                $startnews      = $db->v("startnews");
                $startnews      = $db->v("startnews");
                $base_target    = $db->v("target");
                
            endwhile;

            $lkey64 = base64_decode($lkey);
            $a = explode("##",$lkey64);
    
            $name  = $a[1];
            $name2 = base64_decode($System_lkey);

            if ( $name == '' ) {
                $name = 'no_user';
            }

            $name2        = $name;
            $System_owner = $owner;

        } else {

            $projekt        = 'ConPresso';
            $release        = 0;
            $release_email  = 0;
            $system_email   = 'MAILER@example.com';
            $admin_email    = 'ADMIN@example.com';
            $timeout        = '1440';
            $max_image      = '153600';
            $max_file       = '2048000';
            $article_width  = '100%';
            $language       = 'deutsch';
            $base_url       = 'http://www.example.com/conpresso/';
            $lkey           = 'My4yIyNGcmVlIFB1YmxpYyBMaWNlbmNl';
            $owner          = 'Free Public Licence';
            $send_pw        = 0;
            $help           = 0;
            $startnews      = 1;
            $base_target    = 1;
        }

        if ( $name2 == $System_owner ) {
            $licence_text = "<b>".$LP_LBusinessLicence." ".$name2."</b>";
            $business_licence = 1;
        } else {
            $licence_text = "<font color=\"".$color_orange."\"><b>".$LP_LFreeLicence."</b></font>";
            $business_licence = 0;
        }

    }

?>
        
<br>
<FORM METHOD="POST" ACTION="preference.php" name="newsentry">
    <input type="Hidden" name="go" value="1">
    <input type="Hidden" name="timestamp" value="<?php echo $timestamp; ?>">
    <table width="<?php echo $WIDTH ?>" border="0" cellpadding="3" cellspacing="2">
        <tr>
            <td colspan="2" bgcolor="<?php echo $color_tbg_dunkel; ?>" align="left" valign="middle" class="text">
                <b><?php echo $LP_Licence ?></b>
            </td>
        </tr>
        <tr>
            <td bgcolor="<?PHP echo $color_tbg_hell ?>" height="25" align="left" valign="middle" class="text">
                &nbsp;
            </td>
            <td bgcolor="<?PHP echo $color_data_hell ?>" align="left" valign="middle" class="text">
                <table border="0" cellpadding="0" cellspacing="0"><tr><td align="left" valign="middle" class="text">
                    <?PHP echo $licence_text ?> &nbsp;
                </td><td align="left" valign="middle" class="text" class="text"><?PHP help("SE100"); ?></td>
                <?PHP if ( $business_licence == 0 ) { ?>
                    </td><td align="left" valign="middle" class="text" class="text">
                <?PHP 
                    switch ($SID_language) {
                        case 'deutsch':
                            echo "&nbsp; <a href=\"http://www.conpresso.de/conpresso/de_buy-it/index.php\" target=\"_blank\">".$LP_BuyIt."!</a>";
                            break;
                        case 'english':
                            echo "&nbsp; <a href=\"http://www.conpresso.de/conpresso/en_buy-it/index.php\" target=\"_blank\">".$LP_BuyIt."!</a>";
                            break;
                        default:
                            echo "&nbsp; <a href=\"http://www.conpresso.de/conpresso/en_buy-it/index.php\" target=\"_blank\">".$LP_BuyIt."!</a>";
                    }
                 ?>
                    </td>
                <?PHP } ?>
                </tr></table>
            </td>
        </tr>
        <tr>
            <td bgcolor="<?PHP echo $color_tbg_hell ?>" height="25" align="left" valign="middle" class="text">
                <?php echo $LP_PKeyOwner ?>:
            </td>
            <td bgcolor="<?PHP echo $color_data_hell ?>" align="left" valign="middle" class="text">
                <table border="0" cellpadding="0" cellspacing="0"><tr><td align="left" valign="middle" class="text">
                    <input type="text" name="owner" value="<?php echo $owner ?>" size="35" maxlength="255" class="i36">
                </td><td align="left" valign="middle" class="text" class="text"><?PHP help("SE101"); ?></td></tr></table>
            </td>
        </tr>
        <tr>
            <td bgcolor="<?PHP echo $color_tbg_hell ?>" height="25" align="left" valign="middle" class="text">
                <?php echo $LP_PKey ?>:
            </td>
            <td bgcolor="<?PHP echo $color_data_hell ?>" align="left" valign="middle" class="text">
                <table border="0" cellpadding="0" cellspacing="0"><tr><td align="left" valign="middle" class="text">
                    <input type="text" name="lkey" value="<?php echo $lkey ?>" size="35" maxlength="255" class="i36">
                </td><td align="left" valign="middle" class="text" class="text"><?PHP help("SE102"); ?></td></tr></table>
            </td>
        </tr>
        <tr>
            <td bgcolor="<?PHP echo $color_tbg_hell ?>" height="25" align="left" valign="middle" class="text">
                <?php echo $LP_PProdVersion ?>:
            </td>
            <td bgcolor="<?PHP echo $color_data_hell ?>" align="left" valign="middle" class="text">
                <?php echo "<b>".$version_nr."</b>" ?> - 
                <?php 
                    switch ($SID_language) {
                        case 'deutsch':
                            echo "<b><a target=\"_blank\" href=\"http://www.conpresso.de/conpresso/de_conpresso_version_".$version_nr."/index.php\">".$LP_PProdVersionCheck." &raquo;</a></b>";
                            break;
                        case 'english':
                            echo "<b><a target=\"_blank\" href=\"http://www.conpresso.de/conpresso/en_conpresso_version_".$version_nr."/index.php\">".$LP_PProdVersionCheck." &raquo;</a></b>";
                            break;
                        default:
                            echo "<b><a target=\"_blank\" href=\"http://www.conpresso.de/conpresso/en_conpresso_version_".$version_nr."/index.php\">".$LP_PProdVersionCheck." &raquo;</a></b>";
                    }
                ?> 
                   
                <?PHP help("SE104"); ?>
            </td>
        </tr>
        <tr>
            <td height="25" align="left" valign="middle" class="text">
                &nbsp;
            </td>
            <td align="left" valign="middle" class="text">
                <INPUT class="i" TYPE="SUBMIT" name="lizence" VALUE="<?php echo $LP_LSave ?>">
                <br>
                <br>
                <br>
            </td>
        </tr>
        <tr>
            <td colspan="2" bgcolor="<?php echo $color_tbg_dunkel; ?>" align="left" valign="middle" class="text">
                <b><?php echo $LP_Project ?></b>
            </td>
        </tr>
        <tr>
            <td bgcolor="<?PHP echo $color_tbg_hell ?>" height="25" align="left" valign="middle" class="text">
                <?php echo $LP_PProject ?>:
            </td>
            <td bgcolor="<?PHP echo $color_data_hell ?>" align="left" valign="middle" class="text">
                <table border="0" cellpadding="0" cellspacing="0"><tr><td align="left" valign="middle" class="text">
                    <input type="text" name="project" value="<?php echo $project ?>" size="35" maxlength="255" class="i36">
                </td><td align="left" valign="middle" class="text" class="text"><?PHP help("SE001"); ?></td></tr></table>
            </td>
        </tr>
        <tr>
            <td bgcolor="<?PHP echo $color_tbg_hell ?>" height="25" align="left" valign="middle" class="text">
                <?php echo $LP_PRelease ?>:
            </td>
            <td bgcolor="<?PHP echo $color_data_hell ?>" align="left" valign="middle" class="text">
                <select name="release" size="1" class="i0">
				<option value="1" <?php if ( $release == 1 ) { echo "selected"; } ?>><?php echo $LP_PRelease1 ?></option>
				<option value="0" <?php if ( $release == 0 ) { echo "selected"; } ?>><?php echo $LP_PRelease0 ?></option>
                </select><?PHP help("SE002"); ?>
            </td>
        </tr>
        <tr>
            <td bgcolor="<?PHP echo $color_tbg_hell ?>" height="25" align="left" valign="middle" class="text">
                <?php echo $LP_PReleaseEmail ?>:
            </td>
            <td bgcolor="<?PHP echo $color_data_hell ?>" align="left" valign="middle" class="text">
                <select name="release_email" size="1" class="i0">
				<option value="1" <?php if ( $release_email == 1 ) { echo "selected"; } ?>><?php echo $LP_PReleaseEmail1 ?></option>
				<option value="0" <?php if ( $release_email == 0 ) { echo "selected"; } ?>><?php echo $LP_PReleaseEmail0 ?></option>
                </select><?PHP help("SE003"); ?>
            </td>
        </tr>
        <tr>
            <td bgcolor="<?PHP echo $color_tbg_hell ?>" height="25" align="left" valign="middle" class="text">
                <?php echo $LP_PSystemEmail ?>:
            </td>
            <td bgcolor="<?PHP echo $color_data_hell ?>" align="left" valign="middle" class="text">
                <table border="0" cellpadding="0" cellspacing="0"><tr><td align="left" valign="middle" class="text">
                <input type="text" name="system_email" value="<?php echo $system_email ?>" size="35" maxlength="255" class="i36">  
                </td><td align="left" valign="middle" class="text"><?PHP help("SE004"); ?></td></tr></table>
            </td>
        </tr>
        <tr>
            <td bgcolor="<?PHP echo $color_tbg_hell ?>" height="25" align="left" valign="middle" class="text">
                <?php echo $LP_PAdminEmail ?>:
            </td>
            <td bgcolor="<?PHP echo $color_data_hell ?>" align="left" valign="middle" class="text">
                <table border="0" cellpadding="0" cellspacing="0"><tr><td align="left" valign="middle" class="text">
                <input type="text" name="admin_email" value="<?php echo $admin_email ?>" size="35" maxlength="255" class="i36">  
                </td><td align="left" valign="middle" class="text"><?PHP help("SE005"); ?></td></tr></table>
            </td>
        </tr>
        <tr>
            <td bgcolor="<?PHP echo $color_tbg_hell ?>" height="25" align="left" valign="middle" class="text">
                <?php echo $LP_Timeout ?>:
            </td>
            <td bgcolor="<?PHP echo $color_data_hell ?>" align="left" valign="middle" class="text">
                <table border="0" cellpadding="0" cellspacing="0"><tr><td align="left" valign="middle" class="text">
                <input type="text" name="timeout" value="<?php echo $timeout ?>" size="20" maxlength="5" class="i10">  
                </td><td align="left" valign="middle" class="text"><?PHP help("SE006"); ?></td></tr></table>
            </td>
        </tr>
        <tr>
            <td bgcolor="<?PHP echo $color_tbg_hell ?>" height="25" align="left" valign="middle" class="text">
                <?php echo $LP_MaxImage ?>:
            </td>
            <td bgcolor="<?PHP echo $color_data_hell ?>" align="left" valign="middle" class="text">
                <table border="0" cellpadding="0" cellspacing="0"><tr><td align="left" valign="middle" class="text">
                <input type="text" name="max_image" value="<?php echo $max_image ?>" size="20" maxlength="7" class="i10">  
                </td><td align="left" valign="middle" class="text"><?PHP help("SE006a"); ?>  (<?php echo $LP_ServerMax ?>: <?php echo get_cfg_var("upload_max_filesize"); ?><?php echo $LP_Byte ?>)</td></tr></table>
            </td>
        </tr>
        <tr>
            <td bgcolor="<?PHP echo $color_tbg_hell ?>" height="25" align="left" valign="middle" class="text">
                <?php echo $LP_MaxFile ?>:
            </td>
            <td bgcolor="<?PHP echo $color_data_hell ?>" align="left" valign="middle" class="text">
                <table border="0" cellpadding="0" cellspacing="0"><tr><td align="left" valign="middle" class="text">
                <input type="text" name="max_file" value="<?php echo $max_file ?>" size="20" maxlength="7" class="i10">  
                </td><td align="left" valign="middle" class="text"><?PHP help("SE006b"); ?> (<?php echo $LP_ServerMax ?>: <?php echo get_cfg_var("upload_max_filesize"); ?><?php echo $LP_Byte ?>)</td></tr></table>
            </td>
        </tr>
        <tr>
            <td bgcolor="<?PHP echo $color_tbg_hell ?>" height="25" align="left" valign="middle" class="text">
                <?php echo $LP_WidthArticle ?>:
            </td>
            <td bgcolor="<?PHP echo $color_data_hell ?>" align="left" valign="middle" class="text">
                <table border="0" cellpadding="0" cellspacing="0"><tr><td align="left" valign="middle" class="text">
                <input type="text" name="article_width" value="<?php echo $article_width ?>" size="20" maxlength="5" class="i10">  
                </td><td align="left" valign="middle" class="text"><?PHP help("SE007"); ?></td></tr></table>
            </td>
        </tr>
        <tr>
            <td bgcolor="<?PHP echo $color_tbg_hell ?>" height="25" align="left" valign="middle" class="text">
                <?php echo $LP_Language ?>:
            </td>
            <td bgcolor="<?PHP echo $color_data_hell ?>" align="left" valign="middle" class="text">
                <select class="i0" name="language" size="1">
                    <?php
                        $d = dir("../_include/lang");
                        while($file=$d->read()) {
                            $rest = substr ($file, -4);
                            if ( $rest == '.php')
                            {
                                $language_file  = ereg_replace ( ".php", "", $file);
                                $language_name = ucfirst($language_file);

                                if ( $language_file != 'index' ) {
                                    echo "<option value=\"".$language_file."\"";
                                    if ( $language == $language_file ) 
                                    {
                                        echo " selected";
                                    }
                                    echo ">".$language_name."</option>\n";
                                }
                            }
                        }
                        $d->close();
                    ?>
                </select><?PHP help("SE008"); ?>
            </td>
        </tr>
        <tr>
            <td bgcolor="<?PHP echo $color_tbg_hell ?>" height="25" align="left" valign="middle" class="text">
                <?php echo $LP_PBase_URL ?>:
            </td>
            <td bgcolor="<?PHP echo $color_data_hell ?>" align="left" valign="middle" class="text">
                <table border="0" cellpadding="0" cellspacing="0"><tr><td align="left" valign="middle" class="text">
                <input type="text" name="base_url" value="<?php echo $base_url ?>" size="35" maxlength="255" class="i36">  
                </td><td align="left" valign="middle" class="text"><?PHP help("SE009"); ?></td></tr></table>
            </td>
        </tr>
        <tr>
            <td bgcolor="<?PHP echo $color_tbg_hell ?>" height="25" align="left" valign="middle" class="text">
                <?php echo $LP_PSend_PW ?>:
            </td>
            <td bgcolor="<?PHP echo $color_data_hell ?>" align="left" valign="middle" class="text">
                <input class="b" type="checkbox" id="send_pw" name="send_pw" value="1" <?php if ( $send_pw == '1') { echo "checked"; }  ?>> <?php echo $LP_Activate ?>
                <?PHP help("SE010"); ?>
            </td>
        </tr>
        <tr>
            <td bgcolor="<?PHP echo $color_tbg_hell ?>" height="25" align="left" valign="middle" class="text">
                <?php echo $LP_PHelp ?>:
            </td>
            <td bgcolor="<?PHP echo $color_data_hell ?>" align="left" valign="middle" class="text">
                <input class="b" type="checkbox" id="help" name="help" value="1" <?php if ( $help == '1') { echo "checked"; }  ?>> <?php echo $LP_Activate ?>
                <?PHP help("SE011"); ?>
            </td>
        </tr>
        <tr>
            <td bgcolor="<?PHP echo $color_tbg_hell ?>" height="25" align="left" valign="middle" class="text">
                <?php echo $LP_PStartNews ?>:
            </td>
            <td bgcolor="<?PHP echo $color_data_hell ?>" align="left" valign="middle" class="text">
                <input class="b" type="checkbox" id="startnews" name="startnews" value="1" <?php if ( $startnews == '1') { echo "checked"; }  ?>> <?php echo $LP_Activate ?>
                <?PHP help("SE012"); ?>
            </td>
        </tr>
        <tr>
            <td bgcolor="<?PHP echo $color_tbg_hell ?>" height="25" align="left" valign="middle" class="text">
                <?php echo $LP_PBase_Target ?>:
            </td>
            <td bgcolor="<?PHP echo $color_data_hell ?>" align="left" valign="middle" class="text">
                <table border="0" cellpadding="0" cellspacing="0"><tr><td align="left" valign="middle" class="text">
                <input type="text" name="base_target" value="<?php echo $base_target ?>" size="35" maxlength="255" class="i36">  
                </td><td align="left" valign="middle" class="text"><?PHP help("SE013"); ?></td></tr></table>
            </td>
        </tr>
        <tr>
            <td height="25" align="left" valign="middle" class="text">
                &nbsp;
            </td>
            <td align="left" valign="middle" class="text">
                <INPUT class="i" TYPE="SUBMIT" VALUE="<?php echo $LP_SSave ?>">
                <br>
                <br>
                <br>
            </td>
        </tr>
        <tr>
            <td colspan="2" bgcolor="<?php echo $color_tbg_dunkel; ?>" align="left" valign="middle" class="text">
                <b><?php echo $LP_Navigation ?></b>&nbsp;
            </td>
        </tr>
        <tr>
            <td bgcolor="<?PHP echo $color_tbg_hell ?>" height="25" align="left" valign="middle" class="text">
                <?php echo $LP_StructurTree ?>:
            </td>
            <td bgcolor="<?PHP echo $color_data_hell ?>" align="left" valign="middle" class="text">
                <a href="tree.php"><?php echo $LP_ST_change ?> &raquo;</a>
                <?PHP help("SE201"); ?>
            </td>
        </tr>
        <tr>
            <td height="25" align="left" valign="middle" class="text">
                &nbsp;
            </td>
            <td align="left" valign="middle" class="text">
                <br>
            </td>
        </tr>
        <tr>
            <td colspan="2" bgcolor="<?php echo $color_tbg_dunkel; ?>" align="left" valign="middle" class="text">
                <b><?php echo $LP_DB ?></b>&nbsp;
            </td>
        </tr>
        <tr>
            <td bgcolor="<?PHP echo $color_tbg_hell ?>" height="25" align="left" valign="middle" class="text">
                <?php echo $LP_DB ?>:
            </td>
            <td bgcolor="<?PHP echo $color_data_hell ?>" align="left" valign="middle" class="text">
                <a href="clean.php"><?php echo $LP_Goto ?> &raquo;</a>
                <?PHP help("SE202"); ?>
            </td>
        </tr>
    </table>
</FORM>


<?php
    require("../_include/footer.php");
?>
        

