/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.jdbc1;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Vector;
import org.postgresql.Driver;
import org.postgresql.Field;
import org.postgresql.PGConnection;
import org.postgresql.core.Encoding;
import org.postgresql.jdbc1.AbstractJdbc1Connection;
import org.postgresql.largeobject.LargeObject;
import org.postgresql.largeobject.LargeObjectManager;
import org.postgresql.util.PGbytea;
import org.postgresql.util.PGtokenizer;
import org.postgresql.util.PSQLException;

public abstract class AbstractJdbc1ResultSet {
    protected Vector rows;
    protected Statement statement;
    protected Field[] fields;
    protected String status;
    protected boolean binaryCursor = false;
    protected int updateCount;
    protected long insertOID;
    protected int current_row;
    protected byte[][] this_row;
    protected PGConnection connection;
    protected SQLWarning warnings = null;
    protected boolean wasNullFlag = false;
    protected ResultSet next = null;
    protected StringBuffer sbuf = null;
    public byte[][] rowBuffer = null;

    public AbstractJdbc1ResultSet(PGConnection conn, Statement statement, Field[] fields, Vector tuples, String status, int updateCount, long insertOID, boolean binaryCursor) {
        this.connection = conn;
        this.statement = statement;
        this.fields = fields;
        this.rows = tuples;
        this.status = status;
        this.updateCount = updateCount;
        this.insertOID = insertOID;
        this.this_row = null;
        this.current_row = -1;
        this.binaryCursor = binaryCursor;
    }

    public void addWarnings(SQLWarning warnings) {
        if (this.warnings != null) {
            this.warnings.setNextWarning(warnings);
        } else {
            this.warnings = warnings;
        }
    }

    public void append(AbstractJdbc1ResultSet r) {
        if (this.next == null) {
            this.next = (ResultSet)((Object)r);
        } else {
            ((AbstractJdbc1ResultSet)((Object)this.next)).append(r);
        }
    }

    protected void checkResultSet(int column) throws SQLException {
        if (this.this_row == null) {
            throw new PSQLException("postgresql.res.nextrequired");
        }
        if (column < 1 || column > this.fields.length) {
            throw new PSQLException("postgresql.res.colrange");
        }
    }

    public void clearWarnings() throws SQLException {
        this.warnings = null;
    }

    public void close() throws SQLException {
        if (this.rows != null) {
            this.rows = null;
        }
    }

    public int findColumn(String columnName) throws SQLException {
        int flen = this.fields.length;
        int i = 0;
        while (i < flen) {
            if (this.fields[i].getName().equalsIgnoreCase(columnName)) {
                return i + 1;
            }
            ++i;
        }
        throw new PSQLException("postgresql.res.colname", (Object)columnName);
    }

    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        this.checkResultSet(columnIndex);
        boolean bl = this.wasNullFlag = this.this_row[columnIndex - 1] == null;
        if (this.wasNullFlag) {
            return null;
        }
        if (((AbstractJdbc1Connection)this.connection).haveMinimumCompatibleVersion("7.2")) {
            try {
                return new ByteArrayInputStream(this.getString(columnIndex).getBytes("ASCII"));
            }
            catch (UnsupportedEncodingException l_uee) {
                throw new PSQLException("postgresql.unusual", l_uee);
            }
        }
        return this.getBinaryStream(columnIndex);
    }

    public InputStream getAsciiStream(String columnName) throws SQLException {
        return this.getAsciiStream(this.findColumn(columnName));
    }

    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        return AbstractJdbc1ResultSet.toBigDecimal(this.getFixedString(columnIndex), scale);
    }

    public BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnName), scale);
    }

    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        this.checkResultSet(columnIndex);
        boolean bl = this.wasNullFlag = this.this_row[columnIndex - 1] == null;
        if (this.wasNullFlag) {
            return null;
        }
        if (((AbstractJdbc1Connection)this.connection).haveMinimumCompatibleVersion("7.2")) {
            byte[] b = this.getBytes(columnIndex);
            if (b != null) {
                return new ByteArrayInputStream(b);
            }
        } else if (this.fields[columnIndex - 1].getOID() == 26) {
            LargeObjectManager lom = this.connection.getLargeObjectAPI();
            LargeObject lob = lom.open(this.getInt(columnIndex));
            return lob.getInputStream();
        }
        return null;
    }

    public InputStream getBinaryStream(String columnName) throws SQLException {
        return this.getBinaryStream(this.findColumn(columnName));
    }

    public boolean getBoolean(int columnIndex) throws SQLException {
        return AbstractJdbc1ResultSet.toBoolean(this.getString(columnIndex));
    }

    public boolean getBoolean(String columnName) throws SQLException {
        return this.getBoolean(this.findColumn(columnName));
    }

    public byte getByte(int columnIndex) throws SQLException {
        String s = this.getString(columnIndex);
        if (s != null) {
            try {
                return Byte.parseByte(s);
            }
            catch (NumberFormatException numberFormatException) {
                throw new PSQLException("postgresql.res.badbyte", (Object)s);
            }
        }
        return 0;
    }

    public byte getByte(String columnName) throws SQLException {
        return this.getByte(this.findColumn(columnName));
    }

    public byte[] getBytes(int columnIndex) throws SQLException {
        this.checkResultSet(columnIndex);
        boolean bl = this.wasNullFlag = this.this_row[columnIndex - 1] == null;
        if (!this.wasNullFlag) {
            if (this.binaryCursor) {
                return this.this_row[columnIndex - 1];
            }
            if (((AbstractJdbc1Connection)this.connection).haveMinimumCompatibleVersion("7.2")) {
                if (this.fields[columnIndex - 1].getPGType().equals("bytea")) {
                    return PGbytea.toBytes(this.this_row[columnIndex - 1]);
                }
                return this.this_row[columnIndex - 1];
            }
            if (this.fields[columnIndex - 1].getOID() == 26) {
                LargeObjectManager lom = this.connection.getLargeObjectAPI();
                LargeObject lob = lom.open(this.getInt(columnIndex));
                byte[] buf = lob.read(lob.size());
                lob.close();
                return buf;
            }
            return this.this_row[columnIndex - 1];
        }
        return null;
    }

    public byte[] getBytes(String columnName) throws SQLException {
        return this.getBytes(this.findColumn(columnName));
    }

    public int getColumnCount() {
        return this.fields.length;
    }

    public int getColumnOID(int field) {
        return this.fields[field - 1].getOID();
    }

    public String getCursorName() throws SQLException {
        return ((AbstractJdbc1Connection)this.connection).getCursorName();
    }

    public Date getDate(int columnIndex) throws SQLException {
        return AbstractJdbc1ResultSet.toDate(this.getString(columnIndex));
    }

    public Date getDate(String columnName) throws SQLException {
        return this.getDate(this.findColumn(columnName));
    }

    public double getDouble(int columnIndex) throws SQLException {
        return AbstractJdbc1ResultSet.toDouble(this.getFixedString(columnIndex));
    }

    public double getDouble(String columnName) throws SQLException {
        return this.getDouble(this.findColumn(columnName));
    }

    public String getFixedString(int col) throws SQLException {
        String s = this.getString(col);
        boolean bl = this.wasNullFlag = this.this_row[col - 1] == null;
        if (this.wasNullFlag) {
            return null;
        }
        if (s.length() < 2) {
            return s;
        }
        if (s.charAt(0) == '(') {
            s = "-" + PGtokenizer.removePara(s).substring(1);
        }
        if (s.charAt(0) == '$') {
            s = s.substring(1);
        } else if (s.charAt(0) == '-' && s.charAt(1) == '$') {
            s = "-" + s.substring(2);
        }
        return s;
    }

    public float getFloat(int columnIndex) throws SQLException {
        return AbstractJdbc1ResultSet.toFloat(this.getFixedString(columnIndex));
    }

    public float getFloat(String columnName) throws SQLException {
        return this.getFloat(this.findColumn(columnName));
    }

    public int getInsertedOID() {
        return (int)this.getLastOID();
    }

    public int getInt(int columnIndex) throws SQLException {
        return AbstractJdbc1ResultSet.toInt(this.getFixedString(columnIndex));
    }

    public int getInt(String columnName) throws SQLException {
        return this.getInt(this.findColumn(columnName));
    }

    public long getLastOID() {
        return this.insertOID;
    }

    public long getLong(int columnIndex) throws SQLException {
        return AbstractJdbc1ResultSet.toLong(this.getFixedString(columnIndex));
    }

    public long getLong(String columnName) throws SQLException {
        return this.getLong(this.findColumn(columnName));
    }

    public ResultSet getNext() {
        return this.next;
    }

    public Object getObject(int columnIndex) throws SQLException {
        if (columnIndex < 1 || columnIndex > this.fields.length) {
            throw new PSQLException("postgresql.res.colrange");
        }
        Field field = this.fields[columnIndex - 1];
        if (field == null) {
            this.wasNullFlag = true;
            return null;
        }
        switch (field.getSQLType()) {
            case -7: {
                return this.getBoolean(columnIndex) ? Boolean.TRUE : Boolean.FALSE;
            }
            case 5: {
                return new Short(this.getShort(columnIndex));
            }
            case 4: {
                return new Integer(this.getInt(columnIndex));
            }
            case -5: {
                return new Long(this.getLong(columnIndex));
            }
            case 2: {
                return this.getBigDecimal(columnIndex, field.getMod() == -1 ? -1 : field.getMod() - 4 & 0xFFFF);
            }
            case 7: {
                return new Float(this.getFloat(columnIndex));
            }
            case 8: {
                return new Double(this.getDouble(columnIndex));
            }
            case 1: 
            case 12: {
                return this.getString(columnIndex);
            }
            case 91: {
                return this.getDate(columnIndex);
            }
            case 92: {
                return this.getTime(columnIndex);
            }
            case 93: {
                return this.getTimestamp(columnIndex);
            }
            case -3: 
            case -2: {
                return this.getBytes(columnIndex);
            }
        }
        String type = field.getPGType();
        if (type.equals("unknown")) {
            return this.getString(columnIndex);
        }
        return this.connection.getObject(field.getPGType(), this.getString(columnIndex));
    }

    public Object getObject(String columnName) throws SQLException {
        return this.getObject(this.findColumn(columnName));
    }

    public int getResultCount() {
        return this.updateCount;
    }

    public short getShort(int columnIndex) throws SQLException {
        String s = this.getFixedString(columnIndex);
        if (s != null) {
            try {
                return Short.parseShort(s);
            }
            catch (NumberFormatException numberFormatException) {
                throw new PSQLException("postgresql.res.badshort", (Object)s);
            }
        }
        return 0;
    }

    public short getShort(String columnName) throws SQLException {
        return this.getShort(this.findColumn(columnName));
    }

    public String getStatusString() {
        return this.status;
    }

    public String getString(int columnIndex) throws SQLException {
        this.checkResultSet(columnIndex);
        boolean bl = this.wasNullFlag = this.this_row[columnIndex - 1] == null;
        if (this.wasNullFlag) {
            return null;
        }
        Encoding encoding = this.connection.getEncoding();
        return encoding.decode(this.this_row[columnIndex - 1]);
    }

    public String getString(String columnName) throws SQLException {
        return this.getString(this.findColumn(columnName));
    }

    public Time getTime(int columnIndex) throws SQLException {
        return AbstractJdbc1ResultSet.toTime(this.getString(columnIndex), (ResultSet)((Object)this), this.fields[columnIndex - 1].getPGType());
    }

    public Time getTime(String columnName) throws SQLException {
        return this.getTime(this.findColumn(columnName));
    }

    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        return AbstractJdbc1ResultSet.toTimestamp(this.getString(columnIndex), (ResultSet)((Object)this), this.fields[columnIndex - 1].getPGType());
    }

    public Timestamp getTimestamp(String columnName) throws SQLException {
        return this.getTimestamp(this.findColumn(columnName));
    }

    public int getTupleCount() {
        return this.rows.size();
    }

    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        this.checkResultSet(columnIndex);
        boolean bl = this.wasNullFlag = this.this_row[columnIndex - 1] == null;
        if (this.wasNullFlag) {
            return null;
        }
        if (((AbstractJdbc1Connection)this.connection).haveMinimumCompatibleVersion("7.2")) {
            try {
                return new ByteArrayInputStream(this.getString(columnIndex).getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException l_uee) {
                throw new PSQLException("postgresql.unusual", l_uee);
            }
        }
        return this.getBinaryStream(columnIndex);
    }

    public InputStream getUnicodeStream(String columnName) throws SQLException {
        return this.getUnicodeStream(this.findColumn(columnName));
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.warnings;
    }

    public boolean next() throws SQLException {
        if (this.rows == null) {
            throw new PSQLException("postgresql.con.closed");
        }
        if (++this.current_row >= this.rows.size()) {
            return false;
        }
        this.this_row = (byte[][])this.rows.elementAt(this.current_row);
        this.rowBuffer = new byte[this.this_row.length][];
        System.arraycopy(this.this_row, 0, this.rowBuffer, 0, this.this_row.length);
        return true;
    }

    public boolean reallyResultSet() {
        return this.fields != null;
    }

    public static BigDecimal toBigDecimal(String s, int scale) throws SQLException {
        if (s != null) {
            BigDecimal val;
            try {
                val = new BigDecimal(s);
            }
            catch (NumberFormatException numberFormatException) {
                throw new PSQLException("postgresql.res.badbigdec", (Object)s);
            }
            if (scale == -1) {
                return val;
            }
            try {
                return val.setScale(scale);
            }
            catch (ArithmeticException arithmeticException) {
                throw new PSQLException("postgresql.res.badbigdec", (Object)s);
            }
        }
        return null;
    }

    public static boolean toBoolean(String s) {
        if (s != null) {
            char c = s.charAt(0);
            return c == 't' || c == 'T' || c == '1';
        }
        return false;
    }

    public static Date toDate(String s) throws SQLException {
        if (s == null) {
            return null;
        }
        try {
            return Date.valueOf(s.length() == 10 ? s : s.substring(0, 10));
        }
        catch (NumberFormatException numberFormatException) {
            throw new PSQLException("postgresql.res.baddate", (Object)s);
        }
    }

    public static double toDouble(String s) throws SQLException {
        if (s != null) {
            try {
                return Double.valueOf(s);
            }
            catch (NumberFormatException numberFormatException) {
                throw new PSQLException("postgresql.res.baddouble", (Object)s);
            }
        }
        return 0.0;
    }

    public static float toFloat(String s) throws SQLException {
        if (s != null) {
            try {
                return Float.valueOf(s).floatValue();
            }
            catch (NumberFormatException numberFormatException) {
                throw new PSQLException("postgresql.res.badfloat", (Object)s);
            }
        }
        return 0.0f;
    }

    public static int toInt(String s) throws SQLException {
        if (s != null) {
            try {
                return Integer.parseInt(s);
            }
            catch (NumberFormatException numberFormatException) {
                throw new PSQLException("postgresql.res.badint", (Object)s);
            }
        }
        return 0;
    }

    public static long toLong(String s) throws SQLException {
        if (s != null) {
            try {
                return Long.parseLong(s);
            }
            catch (NumberFormatException numberFormatException) {
                throw new PSQLException("postgresql.res.badlong", (Object)s);
            }
        }
        return 0L;
    }

    public static Time toTime(String s, ResultSet resultSet, String pgDataType) throws SQLException {
        if (s == null) {
            return null;
        }
        try {
            if (s.length() == 8) {
                return Time.valueOf(s);
            }
            if (s.indexOf(".") == 8) {
                int l_millis;
                Time l_time = Time.valueOf(s.substring(0, 8));
                String l_strMillis = s.substring(9);
                if (l_strMillis.length() > 3) {
                    l_strMillis = l_strMillis.substring(0, 3);
                }
                if ((l_millis = Integer.parseInt(l_strMillis)) < 10) {
                    l_millis *= 100;
                } else if (l_millis < 100) {
                    l_millis *= 10;
                }
                return new Time(l_time.getTime() + (long)l_millis);
            }
            return new Time(((java.util.Date)AbstractJdbc1ResultSet.toTimestamp(s, resultSet, pgDataType)).getTime());
        }
        catch (NumberFormatException numberFormatException) {
            throw new PSQLException("postgresql.res.badtime", (Object)s);
        }
    }

    public static Timestamp toTimestamp(String s, ResultSet resultSet, String pgDataType) throws SQLException {
        AbstractJdbc1ResultSet rs = (AbstractJdbc1ResultSet)((Object)resultSet);
        if (s == null) {
            return null;
        }
        AbstractJdbc1ResultSet abstractJdbc1ResultSet = rs;
        synchronized (abstractJdbc1ResultSet) {
            SimpleDateFormat df = null;
            if (Driver.logDebug) {
                Driver.debug("the data from the DB is " + s);
            }
            if (rs.sbuf == null) {
                rs.sbuf = new StringBuffer(32);
            } else {
                rs.sbuf.setLength(0);
            }
            rs.sbuf.append(s);
            int slen = s.length();
            int nanos = 0;
            if (slen > 19) {
                int i = 19;
                rs.sbuf.setLength(i);
                char c = s.charAt(i++);
                if (c == '.') {
                    int start = i;
                    while (Character.isDigit(c = s.charAt(i++))) {
                        if (i != slen) continue;
                        ++i;
                        break;
                    }
                    int end = i - 1;
                    try {
                        nanos = Integer.parseInt(s.substring(start, end));
                    }
                    catch (NumberFormatException e) {
                        throw new PSQLException("postgresql.unusual", e);
                    }
                    int digitsToNano = 9 - (end - start);
                    while (digitsToNano > 0) {
                        nanos *= 10;
                        --digitsToNano;
                    }
                }
                if (i < slen) {
                    rs.sbuf.append(" GMT");
                    rs.sbuf.append(c);
                    rs.sbuf.append(s.substring(i, slen));
                    if (slen - i < 5) {
                        rs.sbuf.append(":00");
                    }
                    df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z");
                } else if (pgDataType.equals("timestamptz")) {
                    rs.sbuf.append(" GMT");
                    df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z");
                } else {
                    df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                }
            } else if (slen == 19) {
                if (pgDataType.equals("timestamptz")) {
                    rs.sbuf.append(" GMT");
                    df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z");
                } else {
                    df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                }
            } else {
                if (slen == 8 && s.equals("infinity")) {
                    s = "9999-01-01";
                }
                if (slen == 9 && s.equals("-infinity")) {
                    s = "0001-01-01";
                }
                df = new SimpleDateFormat("yyyy-MM-dd");
            }
            try {
                if (Driver.logDebug) {
                    Driver.debug("the data after parsing is " + rs.sbuf.toString() + " with " + nanos + " nanos");
                }
                Timestamp result = new Timestamp(df.parse(rs.sbuf.toString()).getTime());
                result.setNanos(nanos);
                Timestamp timestamp = result;
                Object var6_17 = null;
                return timestamp;
            }
            catch (ParseException e) {
                throw new PSQLException("postgresql.res.badtimestamp", new Integer(e.getErrorOffset()), s);
            }
        }
    }

    public boolean wasNull() throws SQLException {
        return this.wasNullFlag;
    }
}

