/*
 * Decompiled with CFR 0.152.
 */
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;

public class DatabaseContainer {
    private static final int cNotDefined = 0;
    private static final int cOracle = 1;
    private static final int cMySQL = 2;
    private static final int cPostgreSQL = 3;
    private static final int cMSSQL = 4;
    private static final int cOracle9i = 5;
    private static final String cstrNotDefined = "notdefined";
    private static final String cstrOracle = "oracle";
    private static final String cstrOracle9i = "oracle9i";
    private static final String cstrMySQL = "mysql";
    private static final String cstrPostgreSQL = "pgsql";
    private static final String cstrMSSQL = "mssql";
    private String m_strMessage = "";
    private int m_nDatabasetype = 0;

    public DatabaseContainer() {
    }

    public DatabaseContainer(String p_strDatabasetype) {
        this.setDatabasetype(p_strDatabasetype);
    }

    public void setDatabasetype(String p_strDatabasetype) {
        this.m_nDatabasetype = p_strDatabasetype.equalsIgnoreCase(cstrOracle) ? 1 : (p_strDatabasetype.equalsIgnoreCase(cstrOracle9i) ? 5 : (p_strDatabasetype.equalsIgnoreCase(cstrMySQL) ? 2 : (p_strDatabasetype.equalsIgnoreCase("postgresql") ? 3 : (p_strDatabasetype.equalsIgnoreCase(cstrMSSQL) ? 4 : 0))));
    }

    public String getDatabasetype() {
        String strDatabasetype = cstrNotDefined;
        switch (this.m_nDatabasetype) {
            case 1: {
                strDatabasetype = cstrOracle;
                break;
            }
            case 5: {
                strDatabasetype = cstrOracle9i;
                break;
            }
            case 2: {
                strDatabasetype = cstrMySQL;
                break;
            }
            case 3: {
                strDatabasetype = cstrPostgreSQL;
                break;
            }
            case 4: {
                strDatabasetype = cstrMSSQL;
                break;
            }
            default: {
                strDatabasetype = cstrNotDefined;
            }
        }
        return strDatabasetype;
    }

    public String getMessage() {
        return this.m_strMessage;
    }

    public Connection createConnection(String p_strHost, String p_strDatabase, String p_strUser, String p_strPassword) {
        String strHost = "";
        Connection con = null;
        try {
            switch (this.m_nDatabasetype) {
                case 1: {
                    Class.forName("oracle.jdbc.driver.OracleDriver");
                    strHost = p_strHost.indexOf(":") == -1 ? p_strHost + ":1521" : p_strHost;
                    con = DriverManager.getConnection("jdbc:oracle:thin:@" + strHost + ":" + p_strDatabase, p_strUser, p_strPassword);
                    break;
                }
                case 5: {
                    Class.forName("oracle.jdbc.OracleDriver");
                    strHost = p_strHost.indexOf(":") == -1 ? p_strHost + ":1521" : p_strHost;
                    con = DriverManager.getConnection("jdbc:oracle:thin:@" + strHost + ":" + p_strDatabase, p_strUser, p_strPassword);
                    break;
                }
                case 2: {
                    Class.forName("com.mysql.jdbc.Driver");
                    con = DriverManager.getConnection("jdbc:mysql://" + p_strHost + "/" + p_strDatabase + "?user=" + p_strUser + "&password=" + p_strPassword);
                    break;
                }
                case 3: {
                    Class.forName("org.postgresql.Driver");
                    con = DriverManager.getConnection("jdbc:postgresql://" + p_strHost + "/" + p_strDatabase, p_strUser, p_strPassword);
                    break;
                }
                case 4: {
                    strHost = p_strHost.indexOf(":") == -1 ? p_strHost + ":1433" : p_strHost;
                    Class.forName("com.microsoft.jdbc.sqlserver.SQLServerDriver");
                    con = DriverManager.getConnection("jdbc:microsoft:sqlserver://" + strHost + ";Databasename=" + p_strDatabase, p_strUser, p_strPassword);
                    break;
                }
                default: {
                    this.m_strMessage = "Can't create Connection.";
                    break;
                }
            }
        }
        catch (Exception ex) {
            this.m_strMessage = ex.getMessage();
            con = null;
        }
        return con;
    }

    public String getVersion(Connection p_con) {
        String strVersion = "";
        try {
            Statement stm = null;
            ResultSet rset1 = null;
            switch (this.m_nDatabasetype) {
                case 1: 
                case 5: {
                    stm = p_con.createStatement(1004, 1007);
                    stm.execute("Select * from v$version");
                    rset1 = stm.getResultSet();
                    rset1.first();
                    strVersion = rset1.getString(1);
                    break;
                }
                case 2: {
                    stm = p_con.createStatement(1004, 1007);
                    stm.execute("Select version()");
                    rset1 = stm.getResultSet();
                    rset1.first();
                    strVersion = "MySQL Version " + rset1.getString(1);
                    break;
                }
                case 3: {
                    stm = p_con.createStatement(1004, 1007);
                    stm.execute("Select version()");
                    rset1 = stm.getResultSet();
                    rset1.first();
                    strVersion = rset1.getString(1);
                    break;
                }
                case 4: {
                    stm = p_con.createStatement(1004, 1007);
                    stm.execute("Select @@version");
                    rset1 = stm.getResultSet();
                    rset1.first();
                    strVersion = rset1.getString(1);
                    break;
                }
                default: {
                    strVersion = "No Version Information available.";
                    break;
                }
            }
        }
        catch (Exception ex) {
            strVersion = "No Version Information available.";
        }
        return strVersion;
    }
}

