/*
 * Decompiled with CFR 0.152.
 */
package se.bysoft.sureshot.products.webeffects.effect;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import javax.swing.JComponent;
import se.bysoft.sureshot.debug.Assertion;
import se.bysoft.sureshot.products.webeffects.effect.Effect;

public class FadeEffect
implements Effect {
    private final int _frames;
    private int _currentFrame = 0;
    private boolean _finished = false;
    private final JComponent _imageCreator;
    final int[] _source;
    final double[] _alphaCoef;
    final double[] _redCoef;
    final double[] _greenCoef;
    final double[] _blueCoef;
    private final Image _image1;
    private final Image _image2;
    private final int[] _offscreenImage;
    private final int _x;
    private final int _y;
    private final int _totalPixels;

    public FadeEffect(int n, JComponent jComponent, Image image, Image image2) {
        this._frames = n;
        this._imageCreator = jComponent;
        this._image1 = image;
        this._image2 = image2;
        this._x = image.getWidth(null);
        this._y = image.getHeight(null);
        this._totalPixels = this._x * this._y;
        this._alphaCoef = new double[this._totalPixels];
        this._redCoef = new double[this._totalPixels];
        this._greenCoef = new double[this._totalPixels];
        this._blueCoef = new double[this._totalPixels];
        this._offscreenImage = new int[this._totalPixels];
        this._source = new int[this._totalPixels];
        int[] nArray = new int[this._totalPixels];
        try {
            PixelGrabber pixelGrabber = new PixelGrabber(this._image1, 0, 0, this._x, this._y, this._source, 0, this._x);
            PixelGrabber pixelGrabber2 = new PixelGrabber(this._image2, 0, 0, this._x, this._y, nArray, 0, this._x);
            pixelGrabber.grabPixels();
            pixelGrabber2.grabPixels();
            if ((pixelGrabber.getStatus() & 0x80) != 0) {
                System.err.println("image fetch aborted or errored");
                Assertion.assertion(false);
            }
            if ((pixelGrabber2.getStatus() & 0x80) != 0) {
                System.err.println("image fetch aborted or errored");
                Assertion.assertion(false);
            }
        }
        catch (InterruptedException interruptedException) {
            Assertion.assertion(false);
        }
        int n2 = 0;
        while (n2 < this._totalPixels) {
            int n3 = this._source[n2] >> 24 & 0xFF;
            int n4 = nArray[n2] >> 24 & 0xFF;
            this._alphaCoef[n2] = ((double)n4 - (double)n3) / (double)this._frames;
            n3 = this._source[n2] >> 16 & 0xFF;
            n4 = nArray[n2] >> 16 & 0xFF;
            this._redCoef[n2] = ((double)n4 - (double)n3) / (double)this._frames;
            n3 = this._source[n2] >> 8 & 0xFF;
            n4 = nArray[n2] >> 8 & 0xFF;
            this._greenCoef[n2] = ((double)n4 - (double)n3) / (double)this._frames;
            n3 = this._source[n2] >> 0 & 0xFF;
            n4 = nArray[n2] >> 0 & 0xFF;
            this._blueCoef[n2] = ((double)n4 - (double)n3) / (double)this._frames;
            ++n2;
        }
    }

    public void restart() {
        this._currentFrame = 0;
        this._finished = false;
    }

    public boolean runEffect(Graphics graphics) {
        if (this._currentFrame == this._frames) {
            graphics.drawImage(this._image2, 0, 0, null);
            this._finished = true;
            return true;
        }
        int n = 0;
        while (n < this._totalPixels) {
            int n2 = (int)(this._alphaCoef[n] * (double)this._currentFrame);
            int n3 = (int)(this._redCoef[n] * (double)this._currentFrame);
            int n4 = (int)(this._greenCoef[n] * (double)this._currentFrame);
            int n5 = (int)(this._blueCoef[n] * (double)this._currentFrame);
            this._offscreenImage[n] = (this._source[n] & 0xFFFFFFFF) + (n2 << 24) + (n3 << 16) + (n4 << 8) + (n5 << 0);
            ++n;
        }
        MemoryImageSource memoryImageSource = new MemoryImageSource(this._x, this._y, this._offscreenImage, 0, this._x);
        graphics.drawImage(this._imageCreator.createImage(memoryImageSource), 0, 0, null);
        ++this._currentFrame;
        return false;
    }

    public boolean isFinished() {
        return this._finished;
    }
}

