/*
 * Decompiled with CFR 0.152.
 */
package se.bysoft.sureshot.products.webeffects.effect;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.Timer;
import se.bysoft.sureshot.debug.Assertion;
import se.bysoft.sureshot.products.webeffects.effect.Effect;
import se.bysoft.sureshot.products.webeffects.effect.FadeEffect;

public class FadeComponent
extends JComponent
implements ActionListener {
    private final Timer _timer;
    private final int _delay;
    private final int _imageShowTime;
    private final Effect[] _effects;
    private final Dimension _preferredSize;
    private int _currentEffect = 0;
    private int _currentImageShowTime = 0;

    public FadeComponent(int n, int n2, int n3, Image[] imageArray) {
        this._delay = n;
        this._effects = new Effect[imageArray.length];
        this._imageShowTime = n3;
        int n4 = imageArray[0].getWidth(null);
        int n5 = imageArray[0].getHeight(null);
        int n6 = 0;
        while (n6 < imageArray.length) {
            this._effects[n6] = new FadeEffect(n2, this, imageArray[n6], n6 + 1 == imageArray.length ? imageArray[0] : imageArray[n6 + 1]);
            Assertion.assertion(imageArray[n6].getWidth(null) == n4);
            Assertion.assertion(imageArray[n6].getHeight(null) == n5);
            ++n6;
        }
        this._preferredSize = new Dimension(imageArray[0].getWidth(null), imageArray[0].getHeight(null));
        this._timer = new Timer(n, this);
    }

    public void startEffect() {
        this._timer.start();
    }

    public void stopEffect() {
        this._timer.stop();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this._effects[this._currentEffect].isFinished()) {
            this._currentImageShowTime += this._delay;
        }
        if (this._effects[this._currentEffect].isFinished() && this._imageShowTime < this._currentImageShowTime) {
            this._currentImageShowTime = 0;
            this._effects[this._currentEffect].restart();
            if (++this._currentEffect == this._effects.length) {
                this._currentEffect = 0;
            }
        }
        if (!this._effects[this._currentEffect].isFinished()) {
            this.repaint();
        }
    }

    public Dimension getPreferredSize() {
        return this._preferredSize;
    }

    protected void paintComponent(Graphics graphics) {
        Effect effect = this._effects[this._currentEffect];
        effect.runEffect(graphics);
    }
}

