/*
 * Decompiled with CFR 0.152.
 */
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;

class PictureReader
extends Thread {
    static final int rHeight = 640;
    Vignette[] target;
    String[] prefix;
    String[] image;
    JProgressBar progress;
    JLabel count;

    PictureReader(Vignette[] vignetteArray, String[] stringArray, String[] stringArray2, JProgressBar jProgressBar, JLabel jLabel) {
        this.target = vignetteArray;
        this.prefix = stringArray;
        this.image = stringArray2;
        this.progress = jProgressBar;
        this.count = jLabel;
    }

    public void run() {
        try {
            for (int i = 0; i < this.target.length; ++i) {
                SwingUtilities.invokeLater(new ShowCnt(Integer.toString(this.target.length - i)));
                this.target[i].setPicture(null, null);
                BufferedImage bufferedImage = Selector.read(this.prefix[i] + this.image[i]);
                if (bufferedImage.getHeight() > 640) {
                    double d = 640.0 / (double)bufferedImage.getHeight();
                    BufferedImage bufferedImage2 = new BufferedImage((int)((double)bufferedImage.getWidth() * d), 640, bufferedImage.getType());
                    AffineTransform affineTransform = new AffineTransform(d, 0.0, 0.0, d, 0.0, 0.0);
                    AffineTransformOp affineTransformOp = new AffineTransformOp(affineTransform, 2);
                    affineTransformOp.filter(bufferedImage, bufferedImage2);
                    this.target[i].setPicture(bufferedImage2, this.image[i]);
                    bufferedImage = null;
                    affineTransformOp = null;
                    continue;
                }
                this.target[i].setPicture(bufferedImage, this.image[i]);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        SwingUtilities.invokeLater(new StopAnim());
        SwingUtilities.invokeLater(new ShowCnt(null));
    }

    class ShowCnt
    implements Runnable {
        String cnt;

        ShowCnt(String string) {
            this.cnt = string;
        }

        public void run() {
            PictureReader.this.count.setText(this.cnt);
        }
    }

    class StopAnim
    implements Runnable {
        StopAnim() {
        }

        public void run() {
            PictureReader.this.progress.setStringPainted(false);
            PictureReader.this.progress.setIndeterminate(false);
        }
    }
}

