/*
 * Decompiled with CFR 0.152.
 */
package patpack.stack;

import patpack.card.Card;
import patpack.stack.CardStack;

public class CardDrag {
    public static final int DRAG_COLOR_NONE = 0;
    public static final int DRAG_COLOR_ALT = 1;
    public static final int DRAG_COLOR_SAME = 2;
    public static final int DRAG_COLOR_ANY = 3;
    public static final int DRAG_COLOR_SUIT = 4;
    public static final int DRAG_VALUE_NONE = 0;
    public static final int DRAG_VALUE_ASCEND = 1;
    public static final int DRAG_VALUE_ASC_MOD13 = 2;
    public static final int DRAG_VALUE_DESCEND = 3;
    public static final int DRAG_VALUE_DESC_MOD13 = 4;
    public static final int DRAG_VALUE_ANY = 5;
    public static final int DRAG_VALUE_LOWER = 6;
    public static final int DRAG_VALUE_CALC = 7;
    public static final int DRAG_VALUE_SEQ = 8;
    public static final int DRAG_VALUE_SEQ_MOD13 = 9;
    public static final int DRAG_VALUE_SAME = 10;
    public static final int DRAG_VALUE_DIMENSION = 11;
    public static final int DROP_EMPTY_NONE = 0;
    public static final int DROP_EMPTY_ACE = 1;
    public static final int DROP_EMPTY_KING = 2;
    public static final int DROP_EMPTY_ANY = 3;
    public static final int DROP_EMPTY_DNUM = 4;
    public static final int DROP_EMPTY_DNUM_KC = 5;
    public static final int DROP_EMPTY_ACEKING = 6;
    public static final int DROP_PREV_ANY = 0;
    public static final int DROP_PREV_START = 1;
    public static final int DROP_PREV_LINEUP = 2;
    public static final int DROP_PREV_OSMOSIS = 3;
    public static final int DROP_PREV_EMPTY = 4;
    public static final int DROP_PREV_LSPIDER = 5;
    public static final int DROP_PREV_HELENA = 6;
    public static final int DROP_PREV_INTERREG = 7;
    private CardStack src = null;
    private int srcIdx = 0;
    private CardStack dest = null;
    private int destIdx = 0;
    private CardStack drag = null;
    private boolean canUndo = true;

    public CardDrag(CardStack src, int srcIdx, CardStack drag) {
        this.src = src;
        this.srcIdx = srcIdx;
        this.drag = drag;
    }

    public CardStack getSrc() {
        return this.src;
    }

    public int getSrcIdx() {
        return this.srcIdx;
    }

    public CardStack getDrag() {
        return this.drag;
    }

    public void setDest(CardStack dest, int destIdx) {
        this.dest = dest;
        this.destIdx = destIdx;
    }

    public CardStack getDest() {
        return this.dest;
    }

    public int getDestIdx() {
        return this.destIdx;
    }

    public void setCanUndo(boolean canUndo) {
        this.canUndo = canUndo;
    }

    public boolean canUndo() {
        return this.canUndo;
    }

    public static boolean dragMatch(CardStack stack, Card c1, Card c2) {
        switch (stack.getDragColorCheck()) {
            case 1: {
                if (c2.getColor() != c1.getColor()) break;
                return false;
            }
            case 2: {
                if (c2.getColor() == c1.getColor()) break;
                return false;
            }
            case 3: {
                break;
            }
            case 4: {
                if (c2.getSuit() == c1.getSuit()) break;
                return false;
            }
            default: {
                return false;
            }
        }
        int val1 = c1.getValue();
        int val2 = c2.getValue();
        switch (stack.getDragValueCheck()) {
            case 1: {
                if (val2 == val1 + 1) break;
                return false;
            }
            case 2: {
                if (val2 == val1 % 13 + 1) break;
                return false;
            }
            case 3: {
                if (val2 == val1 - 1) break;
                return false;
            }
            case 4: {
                if (val2 % 13 + 1 == val1) break;
                return false;
            }
            case 6: {
                if (val2 < val1) break;
                return false;
            }
            case 5: {
                break;
            }
            case 7: {
                if (val2 % 13 == (val1 + stack.dropNum()) % 13) break;
                return false;
            }
            case 8: {
                if (val2 == val1 + 1 || val1 == val2 + 1) break;
                return false;
            }
            case 9: {
                if (val2 == val1 % 13 + 1 || val1 == val2 % 13 + 1) break;
                return false;
            }
            case 10: {
                if (val2 == val1) break;
                return false;
            }
            case 11: {
                if (val2 == val1 || c2.getSuit() == c1.getSuit()) break;
                return false;
            }
            default: {
                return false;
            }
        }
        return CardDrag.dropPrevMatch(stack, c2);
    }

    public static boolean dropEmptyMatch(CardStack stack, Card c) {
        int val = c.getValue();
        switch (stack.getDropEmptyCheck()) {
            case 1: {
                if (val == 1) break;
                return false;
            }
            case 2: {
                if (val == 13) break;
                return false;
            }
            case 3: {
                break;
            }
            case 4: {
                if (val == stack.dropNum) break;
                return false;
            }
            case 5: {
                if (val <= 10 || val == stack.dropNum) break;
                return false;
            }
            case 6: {
                if (val == 1 || val == 13) break;
                return false;
            }
            default: {
                return false;
            }
        }
        return CardDrag.dropPrevMatch(stack, c);
    }

    public static boolean dropPrevMatch(CardStack stack, Card c) {
        CardStack prev = stack.getPrevStack();
        int check = stack.getDropPrevCheck();
        block0 : switch (check) {
            case 0: {
                break;
            }
            case 1: {
                if (stack.getSize() > 0 || prev == null) break;
                if (prev.getSize() <= 0) {
                    return false;
                }
                if (c.getValue() == prev.getCard(0).getValue()) break;
                return false;
            }
            case 2: {
                if (prev == null && c.getValue() == 1) break;
                if (prev == null) {
                    return false;
                }
                if (prev.getSize() <= 0) {
                    return false;
                }
                if (c.getSuit() != prev.getCard(0).getSuit()) {
                    return false;
                }
                if (c.getValue() == prev.getCard(0).getValue() + 1) break;
                return false;
            }
            case 3: {
                if (prev == null) break;
                if (prev.getSize() <= 0) {
                    return false;
                }
                if (stack.getSize() <= 0) {
                    return c.getValue() == prev.getCard(0).getValue();
                }
                int i = prev.getSize() - 1;
                while (i >= 0) {
                    if (c.getValue() == prev.getCard(i).getValue()) {
                        return true;
                    }
                    --i;
                }
                return false;
            }
            case 4: {
                if (prev != null && prev.getSize() <= 0) break;
                return false;
            }
            case 5: {
                if (stack.getSize() > 0) break;
                int i = 0;
                while (i < 4) {
                    if (prev == null) break block0;
                    if (prev.getSize() > 0) {
                        boolean valueMatch;
                        Card pc = prev.getCard(0);
                        boolean colorMatch = c.getColor() == pc.getColor();
                        boolean bl = valueMatch = c.getValue() == pc.getValue();
                        if (colorMatch != valueMatch) {
                            return false;
                        }
                    }
                    prev = prev.getPrevStack();
                    ++i;
                }
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                if (stack.getSize() > 0) break;
                if (prev == null) {
                    return false;
                }
                if (prev.getSize() <= 0) {
                    return false;
                }
                if (c.getValue() == prev.getCard(0).getValue() % 13 + 1) break;
                return false;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    public void undo() {
        int num = this.drag.getSize();
        int remIdx = this.destIdx;
        if (remIdx >= 0) {
            ++remIdx;
        }
        if (remIdx == -2) {
            remIdx = 0;
        }
        int i = 0;
        while (i < num) {
            Card c = this.dest.removeCard(remIdx);
            ++i;
        }
        this.src.add(this.srcIdx, this.drag);
    }
}

