/*
 * Decompiled with CFR 0.152.
 */
package patpack.stack;

import java.awt.Graphics;
import java.util.ArrayList;
import java.util.Collections;
import patpack.card.Card;
import patpack.card.CardBase;
import patpack.stack.CardDrag;
import patpack.stack.CardPile;
import patpack.stack.CardStack;

public class CardDeck
extends CardStack {
    public static final int DECK_NONE = 0;
    public static final int DECK_NORMAL = 1;
    public static final int DECK_DOUBLE = 2;
    public static final int DECK_HANOY = 3;
    public static final int DECK_FAMILIES = 4;
    public static final int DECK_LINEUP = 5;
    public static final int DECK_ACES_FIRST = 6;
    public static final int DECK_CALCULATION = 7;
    public static final int DECK_SULTAN = 8;
    public static final int DECK_ODDS_EVENS = 9;
    public static final int DECK_HELENA = 10;
    public static final int DECK_POHTZEE = 11;
    private int deckType = 1;
    public static final int DEAL_NONE = 0;
    public static final int DEAL_SINGLE = 1;
    public static final int DEAL_THREE = 2;
    public static final int DEAL_ONE_ONLY = 3;
    public static final int DEAL_FREE_STACK = 4;
    public static final int DEAL_FREE_STACKS = 5;
    public static final int DEAL_ALL_STACKS = 6;
    public static final int DEAL_CLOCK = 7;
    public static final int DEAL_BARONESS = 8;
    public static final int DEAL_MONTE_CARLO = 9;
    public static final int DEAL_MAIRE = 10;
    public static final int DEAL_FIVES = 11;
    public static final int DEAL_MEAN = 12;
    private int dealType = 0;
    private int maxReDeal = 0;
    private CardBase deckBase = null;
    private int discardX = 0;
    private int discardY = 0;
    private boolean reDeal = false;

    public void initDeck(int deckType, int dealType, int maxReDeal) {
        this.deckType = deckType;
        this.dealType = dealType;
        this.maxReDeal = maxReDeal;
        this.setIsDeck(true);
        switch (deckType) {
            case 1: {
                this.addShuffle(1, 13);
                this.setFaceDown(52);
                break;
            }
            case 2: {
                this.addShuffle(1, 13);
                this.addShuffle(1, 13);
                Collections.shuffle(this.stack, this.game.getRandom());
                this.setFaceDown(104);
                break;
            }
            case 3: {
                this.addSuitShuffle(Card.SUITS[this.game.getRandom(4)], 2, 10);
                break;
            }
            case 4: {
                this.addShuffle(11, 13);
                this.addShuffle(11, 13);
                int i = 0;
                while (i < 6) {
                    this.stack.add(new Card(this.game, 'j', 1));
                    ++i;
                }
                int i2 = 0;
                while (i2 < 2) {
                    this.stack.add(new Card(this.game, 'j', 2));
                    ++i2;
                }
                Collections.shuffle(this.stack, this.game.getRandom());
                break;
            }
            case 5: {
                this.addShuffle(1, 6);
                break;
            }
            case 6: {
                this.addShuffle(1, 1);
                this.addShuffle(2, 13);
                this.setFaceDown(52);
                break;
            }
            case 7: {
                int i = 0;
                while (i < 4) {
                    if (i > 0) {
                        this.addSuitShuffle(Card.SUITS[i], 1, i);
                    }
                    this.addSuitShuffle(Card.SUITS[i], i + 2, 13);
                    ++i;
                }
                Collections.shuffle(this.stack, this.game.getRandom());
                int i3 = 0;
                while (i3 < 4) {
                    this.addSuitShuffle(Card.SUITS[i3], i3 + 1, i3 + 1);
                    ++i3;
                }
                int i4 = 0;
                while (i4 < 48) {
                    this.stack.add(this.stack.remove(0));
                    ++i4;
                }
                this.setFaceDown(52);
                break;
            }
            case 8: {
                int i = 0;
                while (i < 4) {
                    char suit;
                    this.addSuitShuffle(suit, (suit = Card.SUITS[i]) == 'h' ? 2 : 1, 12);
                    ++i;
                }
                this.addShuffle(1, 12);
                Collections.shuffle(this.stack, this.game.getRandom());
                this.add(new Card(this.game, 'c', 13));
                this.add(new Card(this.game, 'h', 1));
                this.add(new Card(this.game, 'c', 13));
                this.add(new Card(this.game, 'd', 13));
                this.add(new Card(this.game, 'h', 13));
                this.add(new Card(this.game, 'd', 13));
                this.add(new Card(this.game, 's', 13));
                this.add(new Card(this.game, 'h', 13));
                this.add(new Card(this.game, 's', 13));
                int i5 = 0;
                while (i5 < 95) {
                    this.stack.add(this.stack.remove(0));
                    ++i5;
                }
                this.setFaceDown(104);
                break;
            }
            case 9: {
                this.addShuffle(3, 13);
                this.addShuffle(3, 13);
                Collections.shuffle(this.stack, this.game.getRandom());
                this.addShuffle(1, 1);
                this.addShuffle(1, 1);
                this.addShuffle(2, 2);
                this.addShuffle(2, 2);
                int i = 0;
                while (i < 88) {
                    this.stack.add(this.stack.remove(0));
                    ++i;
                }
                this.setFaceDown(104);
                break;
            }
            case 10: {
                this.addShuffle(13, 13);
                this.addShuffle(1, 1);
                this.addShuffle(2, 12);
                this.addShuffle(1, 13);
                this.setFaceDown(104);
                break;
            }
            case 11: {
                this.addShuffle(9, 13);
                this.addShuffle(1, 1);
                Collections.shuffle(this.stack, this.game.getRandom());
                this.setFaceDown(24);
            }
        }
        switch (dealType) {
            case 1: 
            case 2: 
            case 3: 
            case 7: {
                this.discardX = 95;
                this.discardY = 0;
            }
        }
        this.deckBase = maxReDeal == 0 ? new CardBase(this.game, 'x') : new CardBase(this.game, 'o');
    }

    public void addShuffle(int minVal, int maxVal) {
        ArrayList<Card> cards = new ArrayList<Card>();
        int i = minVal;
        while (i <= maxVal) {
            cards.add(new Card(this.game, 'c', i));
            cards.add(new Card(this.game, 'd', i));
            cards.add(new Card(this.game, 'h', i));
            cards.add(new Card(this.game, 's', i));
            ++i;
        }
        Collections.shuffle(cards, this.game.getRandom());
        while (cards.size() > 0) {
            this.stack.add(cards.remove(0));
        }
    }

    public void addSuitShuffle(char suit, int minVal, int maxVal) {
        ArrayList<Card> cards = new ArrayList<Card>();
        int i = minVal;
        while (i <= maxVal) {
            cards.add(new Card(this.game, suit, i));
            ++i;
        }
        Collections.shuffle(cards, this.game.getRandom());
        while (cards.size() > 0) {
            this.stack.add(cards.remove(0));
        }
    }

    public void setReDeal(boolean reDeal) {
        this.reDeal = reDeal;
    }

    public int select(int sx, int sy) {
        int num = this.numFaceDown;
        int offset = (num - 1) / 4 * 2;
        if (offset < 0) {
            offset = 0;
        }
        if (offset > 6) {
            offset = 6;
        }
        int dx = sx - this.x;
        int dy = sy - this.y;
        if (dx >= offset && dx < offset + 71 && dy >= offset && dy < offset + 96) {
            return -3;
        }
        num = this.stack.size() - this.numFaceDown;
        offset = (num - 1) / 4 * 2;
        if (offset > 6) {
            offset = 6;
        }
        dx = sx - (this.x + this.discardX);
        dy = sy - (this.y + this.discardY);
        if (num <= 0) {
            return -1;
        }
        if (dx < offset || dx >= offset + 71) {
            return -1;
        }
        if (dy < offset || dy >= offset + 96) {
            return -1;
        }
        return num - 1;
    }

    public CardStack take(int cardPos) {
        if (cardPos < 0) {
            return null;
        }
        if (!this.takeOkay(cardPos)) {
            return null;
        }
        CardPile newStack = new CardPile();
        int num = this.stack.size() - this.numFaceDown;
        int offset = (num - 1) / 4 * 2;
        if (offset > 6) {
            offset = 6;
        }
        int newX = this.x + this.discardX + offset;
        int newY = this.y + this.discardY + offset;
        newStack.init(this.game, newX, newY, ' ');
        newStack.add(this.getCard(cardPos));
        this.stack.remove(cardPos);
        return newStack;
    }

    public boolean turn(int cardPos) {
        if (cardPos == -3) {
            this.deckClick();
            return true;
        }
        return false;
    }

    public boolean drop(int cardPos, CardDrag drag, boolean cheat) {
        return false;
    }

    protected boolean takeOkay(int cardPos) {
        int size = this.stack.size();
        if (cardPos < 0 || cardPos >= size) {
            return false;
        }
        int num = size - this.numFaceDown;
        return cardPos == num - 1;
    }

    public void deckClick() {
        if (this.numFaceDown <= 0) {
            this.deckReset();
            if (!this.reDeal) {
                return;
            }
        }
        switch (this.dealType) {
            case 1: {
                --this.numFaceDown;
                break;
            }
            case 2: {
                this.numFaceDown -= 3;
                if (this.numFaceDown >= 0) break;
                this.numFaceDown = 0;
                break;
            }
            case 3: {
                if (this.numFaceDown != this.getSize()) break;
                --this.numFaceDown;
                break;
            }
            case 7: {
                int num = this.getSize() - this.numFaceDown;
                if (num > 0 && this.getCard(num - 1).getValue() != 13) break;
                --this.numFaceDown;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                this.multiDeal();
            }
        }
    }

    private void multiDeal() {
        ArrayList cardStacks = this.game.getCardStacks();
        int numStacks = cardStacks.size();
        int i = 0;
        while (i < numStacks) {
            if (this.stack.size() <= 0) break;
            CardStack s = (CardStack)cardStacks.get(i);
            if (s.autoDeal()) {
                Card c;
                s.setMark(' ');
                int deal = 0;
                switch (this.dealType) {
                    case 4: 
                    case 5: {
                        if (s.getSize() > 0) break;
                        deal = 1;
                        break;
                    }
                    case 6: {
                        deal = 1;
                        break;
                    }
                    case 8: {
                        if (s.dropNum() == 2 && this.stack.size() > 2) break;
                        deal = 1;
                        break;
                    }
                    case 9: {
                        int j = i + 1;
                        while (j < numStacks) {
                            if (s.getSize() > 0) break;
                            CardStack sj = (CardStack)cardStacks.get(j);
                            if (sj.autoDeal() && sj.getSize() > 0) {
                                c = sj.removeCard(0);
                                s.add(c);
                                break;
                            }
                            ++j;
                        }
                        if (s.getSize() > 0) break;
                        deal = 1;
                        break;
                    }
                    case 10: {
                        if (this.stack.size() % 2 != s.dropNum()) break;
                        deal = 1;
                        break;
                    }
                    case 11: {
                        if (s.getSize() <= 0) break;
                        deal = 1;
                        break;
                    }
                    case 12: {
                        deal = 4;
                    }
                }
                if (deal > 0) {
                    int num = 0;
                    while (num < deal) {
                        if (this.stack.size() <= 0) break;
                        c = (Card)this.stack.remove(0);
                        s.add(c);
                        ++num;
                    }
                    if (this.dealType == 4 || this.dealType == 10) break;
                }
            }
            ++i;
        }
        if (this.numFaceDown > this.stack.size()) {
            this.numFaceDown = this.stack.size();
        }
    }

    public void deckReset() {
        if (this.maxReDeal == 0) {
            return;
        }
        if (this.maxReDeal > 0) {
            --this.maxReDeal;
        }
        if (this.maxReDeal == 0) {
            this.deckBase = new CardBase(this.game, 'x');
        }
        this.numFaceDown = this.stack.size();
        if (!this.reDeal) {
            return;
        }
        ArrayList cardStacks = this.game.getCardStacks();
        int numStacks = cardStacks.size();
        int i = 0;
        while (i < numStacks) {
            CardStack s = (CardStack)cardStacks.get(i);
            if (s.autoDeal()) {
                s.setMark(' ');
                while (s.getSize() > 0) {
                    Card c = s.removeCard(0);
                    this.add(c);
                }
            }
            ++i;
        }
        this.numFaceDown = this.stack.size();
    }

    public void deal(int num, CardStack s) {
        int i = 0;
        while (i < num) {
            if (this.stack.size() <= 0) break;
            Card c = (Card)this.stack.remove(0);
            s.add(c);
            ++i;
        }
        if (this.numFaceDown > this.stack.size()) {
            this.numFaceDown = this.stack.size();
        }
    }

    public void draw(Graphics g) {
        int size;
        if (this.discardX != 0 || this.discardY != 0) {
            this.drawDiscard(g, this.x + this.discardX, this.y + this.discardY);
        }
        if (this.numFaceDown < (size = this.stack.size())) {
            size = this.numFaceDown;
        }
        if (size <= 0) {
            this.deckBase.draw(g, this.x, this.y);
            return;
        }
        int x = this.x;
        int y = this.y;
        int i = 0;
        while (i < size && i <= 12) {
            this.getCard(0).draw(g, x, y, true);
            x += 2;
            y += 2;
            i += 4;
        }
    }

    private void drawDiscard(Graphics g, int x, int y) {
        int num = this.stack.size() - this.numFaceDown;
        if (num <= 0) {
            this.cardBase.draw(g, x, y);
            return;
        }
        int i = 3;
        while (i < num - 1 && i <= 11) {
            this.getCard(i).draw(g, x, y, false);
            x += 2;
            y += 2;
            i += 4;
        }
        this.getCard(num - 1).draw(g, x, y, false);
    }
}

