/*
 * Decompiled with CFR 0.152.
 */
package patpack.game;

import patpack.dice.Dice;
import patpack.game.DiceGame;
import patpack.scores.YahtzeeScores;

public class Yahtzee
extends DiceGame {
    private YahtzeeScores scores = null;
    private int numDeals = 0;

    protected void initScores() {
        this.scores = new YahtzeeScores();
        this.patpack.getScores().init(this.scores);
    }

    public void start() {
        super.start();
        Dice roll = new Dice(this, 240, 48, false);
        roll.setStyle('r');
        this.diceArray.add(roll);
        int i = 0;
        while (i < 5) {
            int x = 100 + 88 * i;
            int y = 200;
            Dice dice = new Dice(this, x, y, true);
            this.diceArray.add(dice);
            ++i;
        }
        this.initDiceRoll();
        this.scores.resetScores();
    }

    public boolean diceMark(int numDice) {
        if (numDice == 0) {
            this.diceRoll();
            return true;
        }
        Dice dice = (Dice)this.diceArray.get(numDice);
        if (dice.getValue() <= 0 || dice.getColor() != 'r') {
            dice.setColor('r');
        } else {
            dice.setColor('b');
        }
        return true;
    }

    public void initDiceRoll() {
        Dice roll = (Dice)this.diceArray.get(0);
        roll.setValue(1);
        this.numDeals = 0;
        int i = 1;
        while (i <= 5) {
            Dice dice = (Dice)this.diceArray.get(i);
            dice.setColor('r');
            dice.setValue(0);
            ++i;
        }
    }

    public void diceRoll() {
        boolean hasDealt = false;
        int i = 1;
        while (i <= 5) {
            Dice dice = (Dice)this.diceArray.get(i);
            if (dice.getColor() == 'r') {
                dice.setValue(this.getRandom(6) + 1);
                hasDealt = true;
            }
            ++i;
        }
        this.scores.calc(this.diceArray);
        if (hasDealt) {
            ++this.numDeals;
        }
        if (this.numDeals >= 3) {
            Dice roll = (Dice)this.diceArray.get(0);
            roll.setValue(0);
        }
    }

    public void selectScore(int row) {
        if (!this.scores.selectScore(row)) {
            return;
        }
        this.initDiceRoll();
        this.table.repaint();
        this.updateStatus();
    }

    public void updateStatus() {
        if (this.isFinished() || this.isFailed()) {
            return;
        }
        if (this.scores.allDone()) {
            int total = this.scores.getTotal();
            if (total >= 300) {
                this.setFinished();
            } else {
                this.setFailed("You failed to get 300 or more points");
            }
        }
    }
}

