/*
 * Decompiled with CFR 0.152.
 */
package patpack.game;

import patpack.dice.Dice;
import patpack.game.DiceGame;
import patpack.scores.PigsScores;

public class Pigs
extends DiceGame {
    private PigsScores scores = null;

    protected void initScores() {
        this.scores = new PigsScores();
        this.patpack.getScores().init(this.scores);
    }

    public void start() {
        super.start();
        Dice roll = new Dice(this, 48, 48, false);
        roll.setStyle('r');
        roll.setValue(1);
        this.diceArray.add(roll);
        int i = 0;
        while (i < 2) {
            Dice dice = new Dice(this, 0, 0, false);
            this.diceArray.add(dice);
            ++i;
        }
        this.scores.resetScores();
    }

    public boolean diceMark(int numDice) {
        if (numDice == 0) {
            this.diceRoll();
            return true;
        }
        return true;
    }

    public void diceRoll() {
        int cx = 40 + this.getRandom(200);
        int cy = 160 + this.getRandom(200);
        int i = 1;
        while (i <= 2) {
            Dice dice = (Dice)this.diceArray.get(i);
            int x = cx + 120 * (i - 1) + this.getRandom(50);
            int y = cy + this.getRandom(100);
            dice.move(x, y);
            dice.setValue(this.getRandom(6) + 1);
            ++i;
        }
        this.scores.calc(this.diceArray);
        this.updateStatus();
    }

    public void selectScore(int row) {
        if (!this.scores.selectScore(row)) {
            return;
        }
        this.table.repaint();
        this.updateStatus();
    }

    public void updateStatus() {
        if (this.isFinished() || this.isFailed()) {
            return;
        }
        if (this.scores.allDone()) {
            int total = this.scores.getTotal();
            if (total >= 250) {
                this.setFinished();
            } else {
                this.setFailed("You failed to get 250 or more points");
            }
        }
    }
}

