/*
 * Decompiled with CFR 0.152.
 */
package patpack.game;

import patpack.dice.Dice;
import patpack.game.DiceGame;

public class NeuralNet
extends DiceGame {
    public void start() {
        super.start();
        int i = 0;
        while (i < 4) {
            int j = 0;
            while (j < 5) {
                int x = 64 + 88 * j;
                int y = 48 + 88 * i;
                Dice dice = new Dice(this, x, y, true);
                dice.setValue(this.getRandom(6) + 1);
                this.diceArray.add(dice);
                ++j;
            }
            ++i;
        }
    }

    public boolean diceMark(int numDice) {
        Dice dice = (Dice)this.diceArray.get(numDice);
        int val = dice.getValue();
        int row = numDice / 5;
        int col = numDice % 5;
        this.diceRoll(row, col - 1, val);
        this.diceRoll(row, col + 1, val);
        this.diceRoll(row - 1, col, val);
        this.diceRoll(row + 1, col, val);
        this.updateStatus();
        return true;
    }

    public void diceRoll(int row, int col, int val) {
        if (row < 0 || row >= 4) {
            return;
        }
        if (col < 0 || col >= 5) {
            return;
        }
        Dice dice = (Dice)this.diceArray.get(row * 5 + col);
        int newVal = dice.getValue() + val;
        if (newVal > 6) {
            newVal -= 6;
        }
        dice.setValue(newVal);
    }

    public void updateStatus() {
        if (this.isFinished() || this.isFailed()) {
            return;
        }
        boolean done = true;
        int i = 0;
        while (i < 20) {
            Dice dice = (Dice)this.diceArray.get(i);
            if (dice.getValue() != 1) {
                done = false;
            }
            ++i;
        }
        if (done) {
            this.setFinished();
        }
    }
}

