/*
 * Decompiled with CFR 0.152.
 */
package patpack.game;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import patpack.game.CardGame;
import patpack.stack.CardDeck;
import patpack.stack.CardPile;
import patpack.stack.CardStack;

public class HigherLower
extends CardGame
implements ActionListener {
    private JButton highBtn = null;
    private JButton lowBtn = null;
    private int btnWidth = 0;
    private int btnHeight = 0;

    public void start() {
        super.start();
        CardDeck deck = new CardDeck();
        deck.init(this, 24, 8, ' ');
        deck.initDeck(1, 0, 0);
        int i = 0;
        while (i < 6) {
            CardPile pile = new CardPile();
            int x = 40 + 87 * i;
            pile.init(this, x, 120, 'g');
            pile.setAutoDrop(true);
            deck.deal(1, pile);
            if (i > 0) {
                pile.setFaceDown(1);
            }
            this.cardStacks.add(pile);
            ++i;
        }
        this.createBtns();
        this.placeBtns(1);
    }

    private void createBtns() {
        if (this.highBtn != null && this.lowBtn != null) {
            return;
        }
        this.highBtn = new JButton("Higher");
        this.highBtn.setActionCommand("higher");
        Dimension highPref = this.highBtn.getPreferredSize();
        this.highBtn.addActionListener(this);
        this.table.add(this.highBtn);
        this.lowBtn = new JButton("Lower");
        this.lowBtn.setActionCommand("lower");
        Dimension lowPref = this.lowBtn.getPreferredSize();
        this.lowBtn.addActionListener(this);
        this.table.add(this.lowBtn);
        this.btnWidth = (int)Math.max(highPref.getWidth(), lowPref.getWidth());
        this.btnHeight = (int)Math.max(highPref.getHeight(), lowPref.getHeight());
        this.btnWidth = Math.max(this.btnWidth, 71);
    }

    private void placeBtns(int num) {
        int w = this.btnWidth;
        int h = this.btnHeight;
        int x = 40 + 87 * num;
        this.highBtn.setBounds(x += (71 - w) / 2, 112 - h, w, h);
        this.lowBtn.setBounds(x, 224, w, h);
    }

    public boolean stackMark(CardStack stack) {
        return true;
    }

    public void actionPerformed(ActionEvent e) {
        if (this.isFinished() || this.isFailed()) {
            return;
        }
        CardStack s = null;
        int num = -1;
        int val1 = 0;
        int val2 = 0;
        int i = 0;
        while (num < 0 && i < this.cardStacks.size()) {
            s = (CardStack)this.cardStacks.get(i);
            val1 = val2;
            val2 = s.getCard(0).getValue();
            if (s.numFaceDown() > 0) {
                num = i;
            }
            ++i;
        }
        if (num < 1) {
            return;
        }
        s.setFaceDown(0);
        this.table.repaint();
        boolean okay = false;
        String action = e.getActionCommand();
        if (action.equals("higher") && val2 > val1) {
            okay = true;
        }
        if (action.equals("lower") && val2 < val1) {
            okay = true;
        }
        if (!okay) {
            s.setMark('x');
            this.setFailed("The next card was not " + action);
            return;
        }
        if (num == 5) {
            this.setFinished();
            return;
        }
        this.placeBtns(++num);
    }
}

