/*
 * Decompiled with CFR 0.152.
 */
package patpack.applet;

import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import patpack.applet.PatPack;
import patpack.game.GameFactory;

public class ChoosePane
extends JPanel
implements ActionListener {
    private PatPack patpack = null;
    private static final int numCols = 5;

    public ChoosePane(PatPack patpack) {
        this.patpack = patpack;
        this.setLayout(new GridLayout(0, 5));
        this.addLabels();
    }

    private void addLabels() {
        HashMap labelMap = GameFactory.getLabelMap();
        ArrayList labels = new ArrayList(labelMap.keySet());
        Collections.sort(labels);
        ImageIcon cardIcon = this.patpack.loadIcon("icons/patpack.gif");
        ImageIcon diceIcon = this.patpack.loadIcon("icons/dice.gif");
        Iterator iterator = ((AbstractList)labels).iterator();
        while (iterator.hasNext()) {
            String lbl = (String)iterator.next();
            String name = (String)labelMap.get(lbl);
            String type = GameFactory.getType(name);
            ImageIcon icon = cardIcon;
            if (type.equals("dice")) {
                icon = diceIcon;
            }
            JButton btn = new JButton(lbl, icon);
            btn.setActionCommand(name);
            btn.setVerticalTextPosition(3);
            btn.setHorizontalTextPosition(0);
            btn.addActionListener(this);
            this.add(btn);
        }
    }

    public void actionPerformed(ActionEvent e) {
        this.patpack.newGame(e.getActionCommand());
    }
}

