/*
 * Decompiled with CFR 0.152.
 */
package impChess;

import impChess.Actogram;
import impChess.Offset;
import impChess.empire;
import impChess.gameBoard;
import impChess.gameSquare;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.net.URL;

public class character {
    public static final int EMPEROR = 1;
    public static final int EMPRESS = 2;
    public static final int PRINCE = 3;
    public static final int PRINCESS = 4;
    public static final int WATERS = 5;
    public static final int DRUM = 6;
    public static final int MINISTER = 7;
    public static final int CAPTAIN = 8;
    public static final int GENIUS = 9;
    public static final int GENIA = 10;
    public static final int WARRIOR = 11;
    protected static final int[] CharacterValues = new int[]{0, 138, 10, 10, 9, 9, 7, 7, 5, 5, 5, 3};
    protected static final String[] CharacterNames = new String[]{"", "Emperor", "Empress", "Prince", "Princess", "Waters", "Drum", "Minister", "Captain", "Genius", "Genia", "Warrior"};
    protected int Rank;
    protected int Value;
    protected String Team;
    protected Actogram actogram;
    protected int positionRow;
    protected int positionCol;
    protected boolean Captured;
    protected URL iconURL;
    protected Image image;
    protected BufferedImage charImage;
    protected String ImageName;
    protected Toolkit impToolkit = Toolkit.getDefaultToolkit();
    protected empire Empire;
    protected MediaTracker mediaTracker;
    protected gameBoard Board;
    protected String name = "";
    protected int startRow;
    protected int startCol;
    protected int startRank;
    protected int startValue;
    protected Actogram startActogram;
    protected Image startImage;

    public character(int n, String string, int n2, int n3, empire empire2) {
        this.Empire = empire2;
        this.mediaTracker = empire2.getMediaTracker();
        this.Board = empire2.Board;
        this.Rank = n;
        this.Value = CharacterValues[n];
        this.Team = string;
        this.actogram = new Actogram(n, empire2.empireSerial());
        if (n != 11 || empire2.empireName() == "Purple") {
            // empty if block
        }
        this.positionRow = n2;
        this.positionCol = n3;
        this.Captured = false;
        this.nameCharacter(n);
        this.imageCharacter(n);
        this.startRow = this.positionRow;
        this.startCol = this.positionCol;
        this.startRank = this.Rank;
        this.startValue = this.Value;
        this.startActogram = this.actogram;
        this.startImage = this.image;
    }

    protected void imageCharacter(int n) {
        if (this.Empire.getGame().getProduction()) {
            this.iconURL = this.getClass().getResource("/chars/" + CharacterNames[n] + "_" + this.Team + ".gif");
            this.image = this.impToolkit.getImage(this.iconURL);
        } else {
            this.ImageName = "..\\chars\\" + CharacterNames[n] + "_" + this.Team + ".gif";
            this.image = this.impToolkit.getImage(this.ImageName);
        }
        this.mediaTracker.addImage(this.image, 0);
        try {
            this.mediaTracker.waitForID(0);
        }
        catch (InterruptedException interruptedException) {
            System.err.println(interruptedException);
            System.exit(1);
        }
    }

    protected void nameCharacter(int n) {
        switch (n) {
            case 1: {
                this.name = "Er";
                break;
            }
            case 2: {
                this.name = "Es";
                break;
            }
            case 3: {
                this.name = "Pr";
                break;
            }
            case 4: {
                this.name = "Ps";
                break;
            }
            case 5: {
                if (this.positionCol < 8) {
                    this.name = "Ww";
                    break;
                }
                this.name = "We";
                break;
            }
            case 6: {
                if (this.positionCol < 8) {
                    this.name = "Dw";
                    break;
                }
                this.name = "De";
                break;
            }
            case 7: {
                if (this.positionCol < 8) {
                    this.name = "Mw";
                    break;
                }
                this.name = "Me";
                break;
            }
            case 8: {
                if (this.positionCol < 8) {
                    this.name = "Cw";
                    break;
                }
                this.name = "Ce";
                break;
            }
            case 9: {
                this.name = "Ga";
                break;
            }
            case 10: {
                this.name = "Ga";
                break;
            }
            case 11: {
                this.name = "W" + this.zeroFill(this.positionCol, 2);
            }
        }
    }

    public int valueOf() {
        return this.Value;
    }

    public boolean isCaptured() {
        return this.Captured;
    }

    public void capture() {
        this.Captured = true;
        this.positionRow = 0;
        this.positionCol = 0;
    }

    public void release(int n, int n2) {
        this.Captured = false;
        this.positionRow = n;
        this.positionCol = n2;
    }

    public String empireIn() {
        return this.Empire.empireName();
    }

    public void setPosition(int n, int n2) {
        this.positionRow = n;
        this.positionCol = n2;
    }

    public String getName() {
        return this.name;
    }

    public int getRank() {
        return this.Rank;
    }

    public Image getImage() {
        return this.image;
    }

    protected String zeroFill(int n, int n2) {
        String string = "00000000000000000000000000000000";
        String string2 = string + n;
        if (n2 > string2.length()) {
            n2 = string2.length();
        }
        return string2.substring(string2.length() - n2);
    }

    public Actogram getActogram() {
        return this.actogram;
    }

    public gameSquare[] strikePoints() {
        gameSquare[] gameSquareArray = this.actogram.getStrikePoints(this.Board, this.positionRow, this.positionCol);
        return gameSquareArray;
    }

    public gameSquare[] movePoints() {
        gameSquare[] gameSquareArray = this.actogram.getMovePoints(this.Board, this.positionRow, this.positionCol);
        return gameSquareArray;
    }

    public Offset[] getMovePoints() {
        Offset[] offsetArray = new Offset[this.actogram.sizeOf()];
        return offsetArray;
    }

    public void warriorMoved() {
        if (this.Rank == 11 && this.startRow != this.positionRow) {
            this.actogram.warriorMoved();
        }
    }

    public boolean promote(int n) {
        boolean bl = false;
        if (!this.Captured && this.Rank == 3) {
            this.Rank = 1;
            this.Value = CharacterValues[1];
            this.actogram = new Actogram(1, this.Empire.empireSerial());
            this.name = "Er";
            this.imageCharacter(n);
            bl = true;
        }
        return bl;
    }

    public void paint(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Dimension dimension = this.Board.getLocation(this.positionRow, this.positionCol, this.Board.getOrientation());
        int n = this.Board.getSquareSize() - 5;
        if (!this.isCaptured()) {
            graphics2D.drawImage(this.image, dimension.width + 2, dimension.height + 2, n, n, null);
        }
    }
}

