/*
 * Decompiled with CFR 0.152.
 */
package impChess;

import impChess.Offset;
import impChess.gameBoard;
import impChess.gameSquare;

public class Actogram {
    private int rank;
    private int empire;
    private Offset[][] dominate = new Offset[][]{{null}, {null}, {null}, {null}, {null}, {null}, {null}, {null}};
    private boolean moveBlocked;
    private boolean captureBlocked;
    private static Offset[][] WARRIORG = new Offset[][]{{new Offset(1, -1, false, true), new Offset(2, -1, false, true)}, {new Offset(1, 0, true, false), new Offset(2, 0, true, false)}, {new Offset(1, 1, false, true), new Offset(2, 1, false, true)}, {null}, {null}, {null}, {null}, {null}};
    private static Offset[][] WARRIORP = new Offset[][]{{new Offset(-1, -1, false, true), new Offset(-2, -1, false, true)}, {new Offset(-1, 0, true, false), new Offset(-2, 0, true, false)}, {new Offset(-1, 1, false, true), new Offset(-2, 1, false, true)}, {null}, {null}, {null}, {null}, {null}};
    private static Offset[][] WARRIOR1G = new Offset[][]{{new Offset(1, -1, false, true), new Offset(2, -1, false, true)}, {new Offset(1, 0, true, false), new Offset(2, 0, true, false), new Offset(3, 0, true, false)}, {new Offset(1, 1, false, true), new Offset(2, 1, false, true)}, {null}, {null}, {null}, {null}, {null}};
    private static Offset[][] WARRIOR1P = new Offset[][]{{new Offset(-1, -1, false, true), new Offset(-2, -1, false, true)}, {new Offset(-1, 0, true, false), new Offset(-2, 0, true, false), new Offset(-3, 0, true, false)}, {new Offset(-1, 1, false, true), new Offset(-2, 1, false, true)}, {null}, {null}, {null}, {null}, {null}};
    private static Offset[][] GENI = new Offset[][]{{null}, {new Offset(3, -1, true, true), new Offset(4, 0, true, true), new Offset(3, 1, true, true)}, {null}, {new Offset(1, 3, true, true), new Offset(0, 4, true, true), new Offset(-1, 3, true, true)}, {null}, {new Offset(-3, 1, true, true), new Offset(-4, 0, true, true), new Offset(-3, -1, true, true)}, {null}, {new Offset(1, -3, true, true), new Offset(0, -4, true, true), new Offset(-1, -3, true, true)}};
    private static Offset[][] CAPTAIN = new Offset[][]{{null}, {new Offset(3, -2, true, true), new Offset(3, -1, true, true), new Offset(3, 1, true, true), new Offset(3, 2, true, true)}, {null}, {new Offset(2, 3, true, true), new Offset(1, 3, true, true), new Offset(-1, 3, true, true), new Offset(-2, 3, true, true)}, {null}, {new Offset(-3, -2, true, true), new Offset(-3, -1, true, true), new Offset(-3, 1, true, true), new Offset(-3, 2, true, true)}, {null}, {new Offset(2, -3, true, true), new Offset(1, -3, true, true), new Offset(-1, -3, true, true), new Offset(-2, -3, true, true)}};

    private void addDiagonal(int n, boolean bl, boolean bl2) {
        this.dominate[0] = new Offset[n];
        this.dominate[2] = new Offset[n];
        this.dominate[4] = new Offset[n];
        this.dominate[6] = new Offset[n];
        for (int i = 0; i < n; ++i) {
            this.dominate[0][i] = new Offset(i + 1, -(i + 1), bl, bl2);
            this.dominate[2][i] = new Offset(i + 1, i + 1, bl, bl2);
            this.dominate[4][i] = new Offset(-(i + 1), i + 1, bl, bl2);
            this.dominate[6][i] = new Offset(-(i + 1), -(i + 1), bl, bl2);
        }
    }

    private void addRankFile(int n, boolean bl, boolean bl2) {
        this.dominate[1] = new Offset[n];
        this.dominate[3] = new Offset[n];
        this.dominate[5] = new Offset[n];
        this.dominate[7] = new Offset[n];
        for (int i = 0; i < n; ++i) {
            this.dominate[1][i] = new Offset(i + 1, 0, bl, bl2);
            this.dominate[3][i] = new Offset(0, i + 1, bl, bl2);
            this.dominate[5][i] = new Offset(-(i + 1), 0, bl, bl2);
            this.dominate[7][i] = new Offset(0, -(i + 1), bl, bl2);
        }
    }

    public void warriorMoved() {
        if (this.rank == 11) {
            this.dominate = this.empire == 1 ? WARRIORG : WARRIORP;
        }
    }

    public Actogram(int n, int n2) {
        this.rank = n;
        this.empire = n2;
        switch (n) {
            case 1: {
                this.addDiagonal(2, true, true);
                this.addRankFile(2, true, true);
                this.moveBlocked = true;
                this.captureBlocked = true;
                break;
            }
            case 2: 
            case 5: {
                this.addDiagonal(13, true, true);
                this.addRankFile(13, true, true);
                this.moveBlocked = true;
                this.captureBlocked = true;
                break;
            }
            case 3: 
            case 4: {
                this.addDiagonal(13, true, true);
                this.addRankFile(1, true, true);
                this.moveBlocked = true;
                this.captureBlocked = true;
                break;
            }
            case 6: {
                this.addRankFile(13, true, true);
                this.moveBlocked = true;
                this.captureBlocked = true;
                break;
            }
            case 7: {
                this.addDiagonal(13, true, true);
                this.moveBlocked = true;
                this.captureBlocked = true;
                break;
            }
            case 8: {
                this.dominate = CAPTAIN;
                this.moveBlocked = false;
                this.captureBlocked = false;
                break;
            }
            case 9: 
            case 10: {
                this.dominate = GENI;
                this.moveBlocked = false;
                this.captureBlocked = false;
                break;
            }
            case 11: {
                this.dominate = this.empire == 1 ? WARRIOR1G : WARRIOR1P;
                this.moveBlocked = true;
                this.captureBlocked = false;
            }
        }
    }

    public int sizeOf() {
        int n = 0;
        for (int i = 0; i < 8; ++i) {
            n += this.dominate[i].length;
        }
        return n;
    }

    public gameSquare[] getMovePoints(gameBoard gameBoard2, int n, int n2) {
        gameSquare gameSquare2 = null;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        boolean bl = false;
        boolean bl2 = true;
        Object var11_10 = null;
        gameSquare[] gameSquareArray = new gameSquare[this.sizeOf()];
        for (int i = 0; i < 8; ++i) {
            bl2 = true;
            bl = false;
            for (int j = 0; j < this.dominate[i].length; ++j) {
                if (this.dominate[i][j] == null) continue;
                n4 = n + this.dominate[i][j].getRowOffset();
                n5 = n2 + this.dominate[i][j].getColOffset();
                if (this.moveBlocked) {
                    if (bl || !bl2) continue;
                    if (gameBoard2.isSquare(n4, n5)) {
                        if (!this.dominate[i][j].isMove()) continue;
                        gameSquare2 = gameBoard2.getSquare(n4, n5);
                        if (gameSquare2.isOccupied()) {
                            bl = true;
                            continue;
                        }
                        gameSquareArray[n3] = gameSquare2;
                        ++n3;
                        continue;
                    }
                    bl2 = false;
                    continue;
                }
                if (!gameBoard2.isSquare(n4, n5) || !this.dominate[i][j].isMove() || (gameSquare2 = gameBoard2.getSquare(n4, n5)).isOccupied()) continue;
                gameSquareArray[n3] = gameSquare2;
                ++n3;
            }
        }
        gameSquare[] gameSquareArray2 = new gameSquare[n3];
        for (int i = 0; i < n3; ++i) {
            gameSquareArray2[i] = gameSquareArray[i];
        }
        return gameSquareArray2;
    }

    public gameSquare[] getStrikePoints(gameBoard gameBoard2, int n, int n2) {
        gameSquare gameSquare2 = null;
        String string = gameBoard2.getOrientation();
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        boolean bl = false;
        boolean bl2 = true;
        Object var12_11 = null;
        gameSquare[] gameSquareArray = new gameSquare[this.sizeOf()];
        for (int i = 0; i < 8; ++i) {
            bl2 = true;
            bl = false;
            for (int j = 0; j < this.dominate[i].length; ++j) {
                if (this.dominate[i][j] == null) continue;
                n4 = n + this.dominate[i][j].getRowOffset();
                n5 = n2 + this.dominate[i][j].getColOffset();
                if (this.captureBlocked) {
                    if (bl || !bl2) continue;
                    if (gameBoard2.isSquare(n4, n5)) {
                        if (!this.dominate[i][j].isDominate() || !(gameSquare2 = gameBoard2.getSquare(n4, n5)).isOccupied()) continue;
                        if (gameSquare2.getCharacter().empireIn() != string) {
                            gameSquareArray[n3] = gameSquare2;
                            ++n3;
                        }
                        bl = true;
                        continue;
                    }
                    bl2 = false;
                    continue;
                }
                if (!gameBoard2.isSquare(n4, n5) || !this.dominate[i][j].isDominate() || !(gameSquare2 = gameBoard2.getSquare(n4, n5)).isOccupied() || gameSquare2.getCharacter().empireIn() == string) continue;
                gameSquareArray[n3] = gameSquare2;
                ++n3;
            }
        }
        gameSquare[] gameSquareArray2 = new gameSquare[n3];
        for (int i = 0; i < n3; ++i) {
            gameSquareArray2[i] = gameSquareArray[i];
        }
        return gameSquareArray2;
    }

    public void reverse() {
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < this.dominate[i].length; ++j) {
                if (this.dominate[i][j] == null) continue;
                this.dominate[i][j].reverse();
            }
        }
    }
}

