/*
 * Decompiled with CFR 0.152.
 */
package com.quizzam.engine.basic;

import com.quizzam.engine.Flashcard;
import java.util.Random;
import java.util.Vector;

public class ScoreStrategyCardQueue {
    private int range;
    private int spacing;
    private Random random = new Random();
    private boolean lowestScoresFirst = true;
    Vector orderedList = new Vector();
    Vector spacingList = new Vector();

    public ScoreStrategyCardQueue(int n, int n2, boolean bl) {
        this.range = n;
        this.spacing = n2;
        this.lowestScoresFirst = bl;
    }

    public int getRange() {
        return this.range;
    }

    public void setRange(int n) throws IllegalArgumentException {
        if (n < 1) {
            throw new IllegalArgumentException("The range must be greater than zero");
        }
        this.range = n;
    }

    public int getMinSpacing() {
        return this.spacing;
    }

    public void setMinSpacing(int n) throws IllegalArgumentException {
        if (n < 1) {
            throw new IllegalArgumentException("The minimum spacing must be greater than zero.");
        }
        this.spacing = n;
    }

    public void addCard(Flashcard flashcard, int n) {
        CardWithScore cardWithScore = new CardWithScore(flashcard, n);
        this.spacingList.add(cardWithScore);
        this.synchronizeSpacingAndOrderedLists();
    }

    public boolean removeCard(Flashcard flashcard) {
        boolean bl;
        int n = this.indexOf(flashcard, this.spacingList);
        if (n == -1) {
            n = this.indexOf(flashcard, this.orderedList);
            if (n == -1) {
                bl = false;
            } else {
                this.orderedList.remove(n);
                bl = true;
            }
        } else {
            this.spacingList.remove(n);
            bl = true;
        }
        this.synchronizeSpacingAndOrderedLists();
        return bl;
    }

    public void removeAllCards() {
        this.spacingList.clear();
        this.orderedList.clear();
    }

    public int getScore(Flashcard flashcard) throws IllegalArgumentException {
        int n = this.indexOf(flashcard, this.spacingList);
        if (n == -1) {
            n = this.indexOf(flashcard, this.orderedList);
            if (n == -1) {
                throw new IllegalArgumentException("The specified flashcard could not be found in this queue.");
            }
            return ((CardWithScore)this.orderedList.get(n)).getScore();
        }
        return ((CardWithScore)this.spacingList.get(n)).getScore();
    }

    public void setScore(Flashcard flashcard, int n) throws IllegalArgumentException {
        int n2 = this.indexOf(flashcard, this.spacingList);
        if (n2 == -1) {
            n2 = this.indexOf(flashcard, this.orderedList);
            if (n2 == -1) {
                throw new IllegalArgumentException("The specified flashcard could not be found in this queue.");
            }
            CardWithScore cardWithScore = (CardWithScore)this.orderedList.remove(n2);
            cardWithScore.setScore(n);
            this.insertIntoOrderedList(cardWithScore);
        } else {
            ((CardWithScore)this.spacingList.get(n2)).setScore(n);
        }
    }

    public Flashcard getNextCard() {
        if (this.range > this.orderedList.size()) {
            this.range = this.orderedList.size();
        }
        if (this.range == 0) {
            return ((CardWithScore)this.spacingList.get(0)).getCard();
        }
        int n = (int)(this.random.nextFloat() * (float)this.range);
        if (this.lowestScoresFirst) {
            return ((CardWithScore)this.orderedList.get(n)).getCard();
        }
        return ((CardWithScore)this.orderedList.get(this.orderedList.size() - 1 - n)).getCard();
    }

    public void cardWasShown(Flashcard flashcard) {
        this.cardWasShown(flashcard, 0);
    }

    public void cardWasShown(Flashcard flashcard, int n) {
        CardWithScore cardWithScore = null;
        int n2 = this.indexOf(flashcard, this.spacingList);
        if (n2 == -1) {
            n2 = this.indexOf(flashcard, this.orderedList);
            if (n2 != -1) {
                cardWithScore = (CardWithScore)this.orderedList.remove(n2);
            }
        } else {
            cardWithScore = (CardWithScore)this.spacingList.remove(n2);
        }
        if (cardWithScore != null) {
            this.adjustCardScore(cardWithScore, n);
            this.spacingList.add(cardWithScore);
            this.synchronizeSpacingAndOrderedLists();
        }
    }

    public int getLowestScore() {
        int n = this.orderedList.size() > 0 ? ((CardWithScore)this.orderedList.get(0)).getScore() : (this.spacingList.size() > 0 ? ((CardWithScore)this.spacingList.get(0)).getScore() : 0);
        int n2 = 0;
        while (n2 < this.spacingList.size()) {
            int n3 = ((CardWithScore)this.spacingList.get(n2)).getScore();
            if (n3 < n) {
                n = n3;
            }
            ++n2;
        }
        return n;
    }

    public int getHighestScore() {
        int n = this.orderedList.size() > 0 ? ((CardWithScore)this.orderedList.get(this.orderedList.size() - 1)).getScore() : (this.spacingList.size() > 0 ? ((CardWithScore)this.spacingList.get(0)).getScore() : 0);
        int n2 = 0;
        while (n2 < this.spacingList.size()) {
            int n3 = ((CardWithScore)this.spacingList.get(n2)).getScore();
            if (n3 > n) {
                n = n3;
            }
            ++n2;
        }
        return n;
    }

    public void adjustEveryScore(int n) {
        int n2 = 0;
        while (n2 < this.spacingList.size()) {
            CardWithScore cardWithScore = (CardWithScore)this.spacingList.get(n2);
            this.adjustCardScore(cardWithScore, n);
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.orderedList.size()) {
            CardWithScore cardWithScore = (CardWithScore)this.orderedList.get(n3);
            this.adjustCardScore(cardWithScore, n);
            ++n3;
        }
    }

    private void adjustCardScore(CardWithScore cardWithScore, int n) {
        int n2 = cardWithScore.getScore();
        if (n > 0 && n2 > Integer.MAX_VALUE - n) {
            cardWithScore.setScore(Integer.MAX_VALUE);
        } else if (n < 0 && n2 < Integer.MIN_VALUE - n) {
            cardWithScore.setScore(Integer.MIN_VALUE);
        } else {
            cardWithScore.setScore(n2 + n);
        }
    }

    private void synchronizeSpacingAndOrderedLists() {
        while (this.spacingList.size() > this.spacing) {
            CardWithScore cardWithScore = (CardWithScore)this.spacingList.remove(0);
            this.insertIntoOrderedList(cardWithScore);
        }
    }

    private void insertIntoOrderedList(CardWithScore cardWithScore) {
        boolean bl = false;
        int n = 0;
        while (!bl && n < this.orderedList.size()) {
            bl = ((CardWithScore)this.orderedList.get(n)).getScore() > cardWithScore.getScore();
            ++n;
        }
        if (bl) {
            --n;
        }
        this.orderedList.add(n, cardWithScore);
    }

    private int indexOf(Flashcard flashcard, Vector vector) {
        int n = 0;
        boolean bl = false;
        while (!bl && n < vector.size()) {
            bl = ((CardWithScore)vector.get(n)).getCard() == flashcard;
            ++n;
        }
        if (bl) {
            return n - 1;
        }
        return -1;
    }

    public Flashcard[] getOrder() {
        int n = this.orderedList.size() + this.spacingList.size();
        if (n == 0) {
            return null;
        }
        Flashcard[] flashcardArray = new Flashcard[this.orderedList.size() + this.spacingList.size()];
        int n2 = 0;
        while (n2 < this.orderedList.size()) {
            flashcardArray[n2] = ((CardWithScore)this.orderedList.get(n2)).getCard();
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.spacingList.size()) {
            flashcardArray[n3 + this.orderedList.size()] = ((CardWithScore)this.spacingList.get(n3)).getCard();
            ++n3;
        }
        return flashcardArray;
    }

    private class CardWithScore {
        Flashcard card;
        int score;

        public CardWithScore(Flashcard flashcard, int n) {
            this.card = flashcard;
            this.score = n;
        }

        public Flashcard getCard() {
            return this.card;
        }

        public int getScore() {
            return this.score;
        }

        public void setScore(int n) {
            this.score = n;
        }
    }
}

