/*
 * Decompiled with CFR 0.152.
 */
package com.quizzam.engine.basic;

import com.quizzam.engine.Flashcard;
import com.quizzam.engine.basic.BasicFlashcard;
import com.quizzam.engine.basic.BasicQuizStrategy;
import com.quizzam.engine.basic.ScoreStrategyCardQueue;

public class RelativeScoreStrategy
implements BasicQuizStrategy {
    private int tempCount = 0;
    private int tempCount2 = 0;
    private int range = 2;
    private int spacing = 5;
    private int maxDeviation = 5;
    public static final String RANGE_PARAM = "Range";
    public static final String SPACING_PARAM = "Spacing";
    public static final String DEVIATION_PARAM = "MaxDeviation";
    private ScoreStrategyCardQueue frontSideQueue = new ScoreStrategyCardQueue(this.range, this.spacing, true);
    private ScoreStrategyCardQueue backSideQueue = new ScoreStrategyCardQueue(this.range, this.spacing, true);
    public static final int MAX_ALLOWABLE_DEVIATION_SETTING = 100;
    protected static final String NAME = "Concentrate on the harder cards";

    public String getName() {
        return NAME;
    }

    public String getDescription() {
        return "This strategy uses a scoring system to determine which card gets shown next.  Every time a card is marked right, it gains one point relative to the other cards.  Every time a card is marked wrong, it loses one point relative to the other cards. The lowest scoring cards are shown before the higher scoring cards are shown.  When a new card is added, it starts out with the score of the lowest-scoring strategy.  To prevent a counterproductive disparity between card scores, a limit is placed on the maximum score differential between the lowest and highest scoring cards.";
    }

    public String[] getParameters() {
        String[] stringArray = new String[]{RANGE_PARAM, SPACING_PARAM, DEVIATION_PARAM};
        return stringArray;
    }

    public String getParameterDescription(String string) throws IllegalArgumentException {
        if (string.equals(RANGE_PARAM)) {
            return "The next card shown will be one of the X least recently shown cards.  The \"Range\" parameter defines the value of X.";
        }
        if (string.equals(SPACING_PARAM)) {
            return "The minimum number of distinct cards that must be shown before any specific card is repeated.";
        }
        if (string.equals(DEVIATION_PARAM)) {
            return "The maximum difference allowed between the scores of the highest and lowest scoring cards.";
        }
        throw new IllegalArgumentException("The \"" + string + "\" parameter does not exist.");
    }

    public void setParameter(String string, String string2) throws IllegalArgumentException {
        if (string.equals(RANGE_PARAM) || string.equals(SPACING_PARAM)) {
            try {
                int n = Integer.parseInt(string2);
                if (n < 1) {
                    throw new NumberFormatException();
                }
                if (string.equals(RANGE_PARAM)) {
                    this.range = n;
                    this.frontSideQueue.setRange(n);
                    this.backSideQueue.setRange(n);
                }
                this.spacing = n;
                this.frontSideQueue.setMinSpacing(n);
                this.backSideQueue.setMinSpacing(n);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException("The \"" + string + "\" parameter must be set to an integer greater than zero.");
            }
        } else if (string.equals(DEVIATION_PARAM)) {
            try {
                int n = Integer.parseInt(string2);
                if (n < 0 || n > 100) {
                    throw new NumberFormatException();
                }
                this.maxDeviation = n;
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException("The \"" + string + "\" parameter must be set to an integer between 0 and " + 100 + ".");
            }
        } else {
            throw new IllegalArgumentException("The \"" + string + "\" parameter does not exist.");
        }
    }

    public String getParameter(String string) throws IllegalArgumentException {
        if (string.equals(RANGE_PARAM)) {
            return String.valueOf(this.range);
        }
        if (string.equals(SPACING_PARAM)) {
            return String.valueOf(this.spacing);
        }
        if (string.equals(DEVIATION_PARAM)) {
            return String.valueOf(this.maxDeviation);
        }
        throw new IllegalArgumentException("The \"" + string + "\" parameter does not exist.");
    }

    private int prepareToScore(BasicFlashcard basicFlashcard, boolean bl, ScoreStrategyCardQueue scoreStrategyCardQueue) {
        int n = scoreStrategyCardQueue.getScore(basicFlashcard);
        int n2 = 0;
        if (bl) {
            int n3 = scoreStrategyCardQueue.getLowestScore();
            if (n == n3 && n + 1 + this.maxDeviation == Integer.MAX_VALUE) {
                int n4 = scoreStrategyCardQueue.getHighestScore();
                scoreStrategyCardQueue.adjustEveryScore(-((n3 + n4) / 2));
            }
            if (n < n3 + this.maxDeviation) {
                n2 = 1;
            }
        } else {
            int n5 = scoreStrategyCardQueue.getHighestScore();
            if (n == n5 && n - 1 - this.maxDeviation == Integer.MIN_VALUE) {
                int n6 = scoreStrategyCardQueue.getLowestScore();
                scoreStrategyCardQueue.adjustEveryScore(-((n6 + n5) / 2));
            }
            if (n > n5 - this.maxDeviation) {
                n2 = -1;
            }
        }
        return n2;
    }

    public void cardWasScored(BasicFlashcard basicFlashcard, boolean bl, boolean bl2) {
        try {
            int n = 0;
            if (bl2) {
                n = this.prepareToScore(basicFlashcard, bl, this.frontSideQueue);
                this.frontSideQueue.cardWasShown(basicFlashcard, n);
                this.backSideQueue.cardWasShown(basicFlashcard, 0);
            } else {
                n = this.prepareToScore(basicFlashcard, bl, this.backSideQueue);
                this.frontSideQueue.cardWasShown(basicFlashcard, 0);
                this.backSideQueue.cardWasShown(basicFlashcard, n);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public Flashcard getNextCard(boolean bl) {
        if (bl) {
            return this.frontSideQueue.getNextCard();
        }
        return this.backSideQueue.getNextCard();
    }

    public void addCard(Flashcard flashcard, int n, int n2) {
        this.frontSideQueue.addCard(flashcard, n);
        this.backSideQueue.addCard(flashcard, n2);
    }

    public void addCard(Flashcard flashcard) {
        int n = this.frontSideQueue.getLowestScore();
        this.frontSideQueue.addCard(flashcard, n);
        this.backSideQueue.addCard(flashcard, n);
    }

    public boolean removeCard(Flashcard flashcard) {
        boolean bl = this.frontSideQueue.removeCard(flashcard);
        boolean bl2 = this.backSideQueue.removeCard(flashcard);
        return bl | bl2;
    }

    public void removeAllCards() {
        this.frontSideQueue.removeAllCards();
        this.backSideQueue.removeAllCards();
    }

    public Flashcard[] getOrderFrontFirst() {
        return this.frontSideQueue.getOrder();
    }

    public Flashcard[] getOrderBackFirst() {
        return this.backSideQueue.getOrder();
    }

    public int getScoreOfFront(Flashcard flashcard) {
        return this.frontSideQueue.getScore(flashcard);
    }

    public int getScoreOfBack(Flashcard flashcard) {
        return this.backSideQueue.getScore(flashcard);
    }
}

