/*
 * Decompiled with CFR 0.152.
 */
package com.quizzam.engine.basic;

import com.quizzam.engine.Flashcard;
import com.quizzam.engine.basic.BasicFlashcard;
import com.quizzam.engine.basic.BasicQuizStrategy;
import java.util.Random;
import java.util.Vector;

public class LeastRecentNextStrategy
implements BasicQuizStrategy {
    private Random random = new Random();
    private int range = 2;
    private int spacing = 5;
    public static final String RANGE_PARAM = "Range";
    public static final String SPACING_PARAM = "Spacing";
    private Vector cards = new Vector();
    protected static final String NAME = "Show cards not seen recently";

    public String getName() {
        return NAME;
    }

    public String getDescription() {
        return "One of the cards least recently shown will be shown next.";
    }

    public String[] getParameters() {
        String[] stringArray = new String[]{RANGE_PARAM, SPACING_PARAM};
        return stringArray;
    }

    public String getParameterDescription(String string) throws IllegalArgumentException {
        if (string.equals(RANGE_PARAM)) {
            return "The next card shown will be one of the X least recently shown cards.  The \"Range\" parameter defines the value of X.";
        }
        if (string.equals(SPACING_PARAM)) {
            return "The minimum number of distinct cards that must be shown before any specific card is repeated.";
        }
        throw new IllegalArgumentException("The \"" + string + "\" parameter does not exist.");
    }

    public void setParameter(String string, String string2) throws IllegalArgumentException {
        if (string.equals(RANGE_PARAM) || string.equals(SPACING_PARAM)) {
            try {
                int n = Integer.parseInt(string2);
                if (n < 1) {
                    throw new NumberFormatException();
                }
                if (string.equals(RANGE_PARAM)) {
                    this.range = n;
                }
                this.spacing = n;
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException("The \"" + string + "\" parameter must be set to an integer greater than zero.");
            }
        } else {
            throw new IllegalArgumentException("The \"" + string + "\" parameter does not exist.");
        }
    }

    public String getParameter(String string) throws IllegalArgumentException {
        if (string.equals(RANGE_PARAM)) {
            return String.valueOf(this.range);
        }
        if (string.equals(SPACING_PARAM)) {
            return String.valueOf(this.spacing);
        }
        throw new IllegalArgumentException("The \"" + string + "\" parameter does not exist.");
    }

    public Flashcard getNextCard(boolean bl) {
        int n;
        int n2 = this.cards.size();
        if (n2 == 0) {
            return null;
        }
        if (this.range > n2 - this.spacing) {
            n = n2 - this.spacing;
            if (n < 1) {
                n = 1;
            }
        } else {
            n = this.range;
        }
        return (Flashcard)this.cards.get((int)(this.random.nextFloat() * (float)n));
    }

    public void addCard(Flashcard flashcard) {
        this.cards.add(flashcard);
    }

    public boolean removeCard(Flashcard flashcard) {
        return this.cards.remove(flashcard);
    }

    public void removeAllCards() {
        this.cards.clear();
    }

    public void cardWasScored(BasicFlashcard basicFlashcard, boolean bl, boolean bl2) {
        if (this.cards.remove(basicFlashcard)) {
            this.cards.add(basicFlashcard);
        }
    }

    public Flashcard[] getOrder() {
        Flashcard[] flashcardArray = new Flashcard[this.cards.size()];
        int n = 0;
        while (n < flashcardArray.length) {
            flashcardArray[n] = (Flashcard)this.cards.get(n);
            ++n;
        }
        return flashcardArray;
    }
}

