/*
 * Decompiled with CFR 0.152.
 */
package com.quizzam.engine.basic;

import com.quizzam.engine.Flashcard;
import com.quizzam.engine.QuizStrategy;
import com.quizzam.engine.basic.BasicAggregateStrategy;
import com.quizzam.engine.basic.BasicFlashcard;
import com.quizzam.engine.basic.BasicQuizStrategy;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Random;
import java.util.Vector;

public class CustomStrategy
implements BasicAggregateStrategy {
    Random random = new Random();
    Vector cards = new Vector();
    Vector strategiesVector = new Vector();
    Hashtable stratsAndWeights = new Hashtable();
    int numCards = 0;
    int sumOfWeights = 0;
    protected static final String NAME = "Custom Strategy";

    public String getName() {
        return NAME;
    }

    public String getDescription() {
        return "This strategy is an aggregation of sub-strategies.  Each sub-strategy is assigned a specific weight.  Every time this strategy needs to make a decision about which card to display next, it lets one of its substrategies decide.  The selection of a substrategy is random, but strategies with higher stratsAndWeights will get selected more often than strategies with lower stratsAndWeights.";
    }

    public String[] getParameters() {
        return new String[0];
    }

    public String getParameterDescription(String string) throws IllegalArgumentException {
        throw new IllegalArgumentException("This strategy has no configurable parameters.");
    }

    public void setParameter(String string, String string2) throws IllegalArgumentException {
        throw new IllegalArgumentException("This strategy has no configurable parameters.");
    }

    public String getParameter(String string) throws IllegalArgumentException {
        throw new IllegalArgumentException("This strategy has no configurable parameters.");
    }

    public Flashcard getNextCard(boolean bl) {
        if (this.sumOfWeights > 0) {
            int n = (int)((float)this.sumOfWeights * this.random.nextFloat()) + 1;
            Enumeration enumeration = this.stratsAndWeights.keys();
            BasicQuizStrategy basicQuizStrategy = null;
            while (n > 0) {
                basicQuizStrategy = (BasicQuizStrategy)enumeration.nextElement();
                n -= ((Integer)this.stratsAndWeights.get(basicQuizStrategy)).intValue();
            }
            return basicQuizStrategy.getNextCard(bl);
        }
        if (this.cards.size() > 0) {
            return (Flashcard)this.cards.get((int)(this.random.nextFloat() * (float)this.cards.size()));
        }
        return null;
    }

    public void addCardWithoutNotifyingStrategies(Flashcard flashcard) {
        this.cards.add(flashcard);
    }

    public void addCard(Flashcard flashcard) {
        this.cards.add(flashcard);
        Enumeration enumeration = this.stratsAndWeights.keys();
        while (enumeration.hasMoreElements()) {
            ((BasicQuizStrategy)enumeration.nextElement()).addCard(flashcard);
        }
    }

    public boolean removeCard(Flashcard flashcard) {
        boolean bl = false;
        Enumeration enumeration = this.stratsAndWeights.keys();
        while (enumeration.hasMoreElements()) {
            bl |= ((BasicQuizStrategy)enumeration.nextElement()).removeCard(flashcard);
        }
        bl = bl || this.cards.remove(flashcard);
        return bl;
    }

    public void removeAllCards() {
        Enumeration enumeration = this.stratsAndWeights.keys();
        while (enumeration.hasMoreElements()) {
            ((BasicQuizStrategy)enumeration.nextElement()).removeAllCards();
        }
        this.cards.clear();
    }

    public void cardWasScored(BasicFlashcard basicFlashcard, boolean bl, boolean bl2) {
        Enumeration enumeration = this.stratsAndWeights.keys();
        while (enumeration.hasMoreElements()) {
            ((BasicQuizStrategy)enumeration.nextElement()).cardWasScored(basicFlashcard, bl, bl2);
        }
    }

    public QuizStrategy[] getStrategies() {
        QuizStrategy[] quizStrategyArray = new QuizStrategy[this.strategiesVector.size()];
        int n = 0;
        while (n < this.strategiesVector.size()) {
            quizStrategyArray[n] = (QuizStrategy)this.strategiesVector.get(n);
            ++n;
        }
        return quizStrategyArray;
    }

    public int getNumStrategies() {
        return this.stratsAndWeights.size();
    }

    public void addStrategy(QuizStrategy quizStrategy, int n) throws IllegalArgumentException {
        if (quizStrategy == null) {
            throw new IllegalArgumentException("This method cannot accept NULL for a strategy.");
        }
        if (!(quizStrategy instanceof BasicQuizStrategy)) {
            throw new IllegalArgumentException("The strategy is not an instance of a compatible class.");
        }
        if (n < 1) {
            throw new IllegalArgumentException("The weight must be greater than zero.");
        }
        if (this.stratsAndWeights.containsKey(quizStrategy)) {
            throw new IllegalArgumentException("The specified strategy has previously been added, and thus cannot be added again.");
        }
        BasicQuizStrategy basicQuizStrategy = (BasicQuizStrategy)quizStrategy;
        basicQuizStrategy.removeAllCards();
        int n2 = 0;
        while (n2 < this.cards.size()) {
            basicQuizStrategy.addCard((Flashcard)this.cards.get(n2));
            ++n2;
        }
        this.stratsAndWeights.put(basicQuizStrategy, new Integer(n));
        this.sumOfWeights += n;
        this.strategiesVector.add(basicQuizStrategy);
    }

    public boolean removeStrategy(QuizStrategy quizStrategy) {
        if (!this.stratsAndWeights.containsKey(quizStrategy)) {
            return false;
        }
        Integer n = (Integer)this.stratsAndWeights.remove(quizStrategy);
        this.sumOfWeights -= n.intValue();
        ((BasicQuizStrategy)quizStrategy).removeAllCards();
        this.strategiesVector.remove(quizStrategy);
        return true;
    }

    public int getWeight(QuizStrategy quizStrategy) {
        Object v = this.stratsAndWeights.get(quizStrategy);
        if (v == null) {
            return -1;
        }
        return (Integer)v;
    }

    public void setWeight(QuizStrategy quizStrategy, int n) throws IllegalArgumentException {
        if (n < 1) {
            throw new IllegalArgumentException("The weight must be greater than zero.");
        }
        if (quizStrategy == null) {
            throw new IllegalArgumentException("This method cannot accept NULL for a strategy.");
        }
        if (!this.stratsAndWeights.containsKey(quizStrategy)) {
            throw new IllegalArgumentException("The specified strategy is not a part of this strategy.");
        }
        Integer n2 = (Integer)this.stratsAndWeights.remove(quizStrategy);
        this.stratsAndWeights.put(quizStrategy, new Integer(n));
        this.sumOfWeights = this.sumOfWeights - n2 + n;
    }

    public boolean containsStrategy(QuizStrategy quizStrategy) {
        return this.stratsAndWeights.containsKey(quizStrategy);
    }
}

