/*
 * Decompiled with CFR 0.152.
 */
package com.quizzam.engine.basic;

import com.quizzam.engine.Flashcard;
import com.quizzam.engine.FlashcardDeck;
import com.quizzam.engine.FlashcardEngine;
import com.quizzam.engine.QuizStrategy;
import com.quizzam.engine.basic.BasicAggregateStrategy;
import com.quizzam.engine.basic.BasicFlashcard;
import com.quizzam.engine.basic.BasicFlashcardDeck;
import com.quizzam.engine.basic.BasicQuizStrategy;
import com.quizzam.engine.basic.CustomStrategy;
import com.quizzam.engine.basic.FlashcardFileLoader;
import com.quizzam.engine.basic.LeastRecentNextStrategy;
import com.quizzam.engine.basic.RandomCardStrategy;
import com.quizzam.engine.basic.RelativeScoreStrategy;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;

public class BasicFlashcardEngine
implements FlashcardEngine {
    public FlashcardDeck createDeck() {
        return new BasicFlashcardDeck();
    }

    public Flashcard createCard() {
        return new BasicFlashcard();
    }

    public FlashcardDeck loadDeck(String string) throws IOException {
        if (string == null || string.equals("")) {
            throw new IOException("No filename was specified.");
        }
        File file = new File(string);
        try {
            if (file.exists()) {
                int n;
                BasicFlashcard[] basicFlashcardArray;
                if (!file.isFile()) {
                    throw new IOException(string + " is not a file.");
                }
                FlashcardFileLoader flashcardFileLoader = new FlashcardFileLoader(file);
                BasicFlashcardDeck basicFlashcardDeck = new BasicFlashcardDeck();
                boolean bl = false;
                BasicQuizStrategy basicQuizStrategy = flashcardFileLoader.getStrategy();
                if (basicQuizStrategy != null && basicQuizStrategy instanceof BasicAggregateStrategy) {
                    basicFlashcardDeck.setStrategy((BasicAggregateStrategy)basicQuizStrategy);
                    bl = true;
                }
                if ((basicFlashcardArray = flashcardFileLoader.getFlashcards()) != null) {
                    if (bl) {
                        n = 0;
                        while (n < basicFlashcardArray.length) {
                            basicFlashcardDeck.addCardWithoutNotifyingStrategy(basicFlashcardArray[n]);
                            ++n;
                        }
                    } else {
                        n = 0;
                        while (n < basicFlashcardArray.length) {
                            basicFlashcardDeck.addCard(basicFlashcardArray[n]);
                            ++n;
                        }
                    }
                }
                if ((n = flashcardFileLoader.getStartingIndex()) < 0 || n >= basicFlashcardDeck.size()) {
                    n = 0;
                }
                basicFlashcardDeck.setStartingIndex(n);
                return basicFlashcardDeck;
            }
            throw new FileNotFoundException("File not found: " + string);
        }
        catch (SecurityException securityException) {
            throw new IOException("The operating system has denied read access to " + string + ".");
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw fileNotFoundException;
        }
        catch (IOException iOException) {
            throw new IOException("An error occurred while trying to load the specified file.  " + iOException.getMessage());
        }
    }

    public String[] getAvailableStrategies() {
        String[] stringArray = new String[]{"Show cards not seen recently", "Show Random Cards", "Concentrate on the harder cards", "Custom Strategy"};
        return stringArray;
    }

    public QuizStrategy createStrategy(String string) throws IllegalArgumentException {
        if (string.equals("Show cards not seen recently")) {
            return new LeastRecentNextStrategy();
        }
        if (string.equals("Show Random Cards")) {
            return new RandomCardStrategy();
        }
        if (string.equals("Concentrate on the harder cards")) {
            return new RelativeScoreStrategy();
        }
        if (string.equals("Custom Strategy")) {
            return new CustomStrategy();
        }
        throw new IllegalArgumentException("The specified strategy is not supported by this flashcard engine.");
    }
}

