/*
 * Decompiled with CFR 0.152.
 */
package com.quizzam.engine.basic;

import com.quizzam.engine.AggregateStrategy;
import com.quizzam.engine.Flashcard;
import com.quizzam.engine.FlashcardDeck;
import com.quizzam.engine.basic.BasicAggregateStrategy;
import com.quizzam.engine.basic.BasicFlashcard;
import com.quizzam.engine.basic.CustomStrategy;
import com.quizzam.engine.basic.FlashcardFileLoader;
import com.quizzam.engine.basic.FlashcardListener;
import com.quizzam.engine.basic.LeastRecentNextStrategy;
import com.quizzam.engine.basic.RelativeScoreStrategy;
import java.io.File;
import java.io.IOException;
import java.util.Vector;

public class BasicFlashcardDeck
implements FlashcardDeck,
FlashcardListener {
    Vector deck = new Vector();
    BasicAggregateStrategy strategy = new CustomStrategy();
    int startingIndex = -1;

    public BasicFlashcardDeck() {
        this.strategy.addStrategy(new RelativeScoreStrategy(), 5);
        this.strategy.addStrategy(new LeastRecentNextStrategy(), 1);
    }

    public int size() {
        return this.deck.size();
    }

    public Flashcard getCard(int n) {
        Flashcard flashcard = null;
        try {
            flashcard = (Flashcard)this.deck.get(n);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return flashcard;
    }

    public int getIndex(Flashcard flashcard) {
        return this.deck.indexOf(flashcard);
    }

    public int removeCard(Flashcard flashcard) {
        int n = this.deck.indexOf(flashcard);
        if (n != -1) {
            ((BasicFlashcard)flashcard).removeListener(this);
            this.deck.remove(flashcard);
            this.strategy.removeCard(flashcard);
        }
        return n;
    }

    public Flashcard removeCard(int n) {
        Flashcard flashcard = null;
        try {
            flashcard = (Flashcard)this.deck.remove(n);
            if (flashcard != null) {
                ((BasicFlashcard)flashcard).removeListener(this);
                this.strategy.removeCard(flashcard);
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return flashcard;
    }

    public int addCard(Flashcard flashcard) throws IllegalArgumentException {
        if (flashcard instanceof BasicFlashcard) {
            this.deck.add((BasicFlashcard)flashcard);
            ((BasicFlashcard)flashcard).addListener(this);
            this.strategy.addCard(flashcard);
            return this.deck.indexOf(flashcard);
        }
        throw new IllegalArgumentException("This flashcard is not an instance of a compatible class.");
    }

    protected void addCardWithoutNotifyingStrategy(BasicFlashcard basicFlashcard) {
        this.deck.add(basicFlashcard);
        basicFlashcard.addListener(this);
    }

    public void addCard(Flashcard flashcard, int n) throws IllegalArgumentException {
        if (!(flashcard instanceof BasicFlashcard)) {
            throw new IllegalArgumentException("This flashcard is not an instance of a compatible class.");
        }
        if (n < 0 || n > this.deck.size()) {
            throw new IllegalArgumentException("The value for the index must be between 0 and one less than the size of the deck.");
        }
        this.deck.add(n, (BasicFlashcard)flashcard);
        ((BasicFlashcard)flashcard).addListener(this);
        int n2 = 0;
        while (n2 < this.deck.size()) {
            this.strategy.addCard((Flashcard)this.deck.get(n2));
            ++n2;
        }
    }

    public void setStrategy(AggregateStrategy aggregateStrategy) throws IllegalArgumentException {
        if (!(aggregateStrategy instanceof BasicAggregateStrategy)) {
            throw new IllegalArgumentException("The specified strategy is not an instance of a compatible class.");
        }
        if (aggregateStrategy != null) {
            this.strategy = (BasicAggregateStrategy)aggregateStrategy;
            int n = 0;
            while (n < this.deck.size()) {
                this.strategy.addCard((Flashcard)this.deck.get(n));
                ++n;
            }
        }
    }

    public AggregateStrategy getStrategy() {
        return this.strategy;
    }

    public Flashcard getNextCardInQuiz(boolean bl) {
        return this.strategy.getNextCard(bl);
    }

    public void cardWasScored(BasicFlashcard basicFlashcard, boolean bl, boolean bl2) {
        this.strategy.cardWasScored(basicFlashcard, bl, bl2);
    }

    public void save(String string) throws IOException {
        if (string == null || string.equals("")) {
            throw new IOException("No filename was specified.");
        }
        File file = new File(string);
        String string2 = this.createOrOverwrite(file, string);
        if (string2 == null) {
            try {
                BasicFlashcard[] basicFlashcardArray = new BasicFlashcard[this.deck.size()];
                int n = 0;
                while (n < basicFlashcardArray.length) {
                    basicFlashcardArray[n] = (BasicFlashcard)this.deck.get(n);
                    ++n;
                }
                FlashcardFileLoader.saveToDisk(file, this.startingIndex, basicFlashcardArray, this.strategy);
            }
            catch (IOException iOException) {
                throw new IOException("An IO error occurred while saving to " + string);
            }
        } else {
            throw new IOException(string2);
        }
    }

    private String createOrOverwrite(File file, String string) {
        boolean bl = false;
        String string2 = null;
        try {
            if (file.exists()) {
                if (!file.isFile()) {
                    string2 = string + " is not a file.";
                    bl = true;
                } else {
                    try {
                        file.delete();
                    }
                    catch (SecurityException securityException) {
                        string2 = "The operating system has denied access to overwrite " + string + ".";
                        bl = true;
                    }
                }
            }
        }
        catch (SecurityException securityException) {
            string2 = "The operating system has denied read access to " + string + ".";
            bl = true;
        }
        if (!bl) {
            try {
                file.createNewFile();
                return null;
            }
            catch (SecurityException securityException) {
                return "The operating system has denied write access to save data in " + string + ".";
            }
            catch (IOException iOException) {
                return "An IO error occurred while initializing " + string + " for SAVE.";
            }
        }
        return string2;
    }

    public int getStartingIndex() {
        if (this.size() == 0) {
            this.startingIndex = 0;
            return -1;
        }
        if (this.startingIndex < 0 || this.startingIndex >= this.size()) {
            this.startingIndex = 0;
            return 0;
        }
        return this.startingIndex;
    }

    public void setStartingIndex(int n) throws IllegalArgumentException {
        if (n < 0 || n >= this.size()) {
            throw new IllegalArgumentException("an invalid index was passed to this method");
        }
        this.startingIndex = n;
    }
}

