/*
 * Decompiled with CFR 0.152.
 */
package com.quizzam.application.basic;

import com.quizzam.application.basic.ColorIcon;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.Hashtable;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JTextPane;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.Caret;
import javax.swing.text.EditorKit;
import javax.swing.text.StyledDocument;
import javax.swing.text.StyledEditorKit;

public class TextFormatCoordinator
implements ActionListener,
CaretListener {
    public static final String APPLY_FONT_ACTION = "applyFont";
    public static final String APPLY_SIZE_ACTION = "applySize";
    public static final String APPLY_BOLD_ACTION = "applyBold";
    public static final String APPLY_ITALIC_ACTION = "applyItalic";
    public static final String APPLY_UNDERLINE_ACTION = "applyUnderline";
    public static final String APPLY_LEFT_ALIGN_ACTION = "applyAlignLeft";
    public static final String APPLY_CENTER_ALIGN_ACTION = "applyAlignRight";
    public static final String APPLY_RIGHT_ALIGN_ACTION = "applyAlignCenter";
    public static final String TEXT_COLOR_ACTION = "changeColor";
    private Color lastTextColor = Color.BLACK;
    private JTextPane textPane;
    private JComboBox fontObject;
    private JComboBox sizeObject;
    private JButton colorButton;
    private ColorIcon colorIcon;
    private Hashtable fontActions = new Hashtable();
    private Hashtable sizeActions = new Hashtable();
    private Hashtable colorActions = new Hashtable();
    private StyledEditorKit.BoldAction boldAction = new StyledEditorKit.BoldAction();
    private StyledEditorKit.ItalicAction italicAction = new StyledEditorKit.ItalicAction();
    private StyledEditorKit.UnderlineAction underlineAction = new StyledEditorKit.UnderlineAction();
    private StyledEditorKit.AlignmentAction alignLeftAction = new StyledEditorKit.AlignmentAction("align-left", 0);
    private StyledEditorKit.AlignmentAction alignCenterAction = new StyledEditorKit.AlignmentAction("align-center", 1);
    private StyledEditorKit.AlignmentAction alignRightAction = new StyledEditorKit.AlignmentAction("align-right", 2);
    private Action colorAction;

    public TextFormatCoordinator(JTextPane jTextPane, JComboBox jComboBox, JComboBox jComboBox2, JButton jButton, ColorIcon colorIcon) throws IllegalArgumentException {
        if (jComboBox == null || jComboBox2 == null || jTextPane == null) {
            throw new IllegalArgumentException("NULL cannot be supplied as a parameter");
        }
        this.textPane = jTextPane;
        this.fontObject = jComboBox;
        this.sizeObject = jComboBox2;
        this.colorButton = jButton;
        this.colorIcon = colorIcon;
        colorIcon.setColor(this.lastTextColor);
        jTextPane.addCaretListener(this);
        jComboBox.addActionListener(this);
        jComboBox2.addActionListener(this);
        jButton.addActionListener(this);
    }

    public JTextPane getTextPane() {
        return this.textPane;
    }

    public JComboBox getFontObject() {
        return this.fontObject;
    }

    public JComboBox getSizeObject() {
        return this.sizeObject;
    }

    public String getFont() {
        return this.fontObject.getSelectedItem().toString();
    }

    public int getFontSize() {
        return Integer.parseInt(this.sizeObject.getSelectedItem().toString());
    }

    public void setTextColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("This method cannot accept NULL for the text color.");
        }
        StyledEditorKit.ForegroundAction foregroundAction = new StyledEditorKit.ForegroundAction("foreground-color", color);
        foregroundAction.actionPerformed(new ActionEvent(this.textPane, 1001, ""));
        this.lastTextColor = color;
        this.colorIcon.setColor(color);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Color color;
        String string = null;
        Object object = actionEvent.getSource();
        string = object == this.fontObject ? APPLY_FONT_ACTION : (object == this.sizeObject ? APPLY_SIZE_ACTION : (object == this.colorButton ? TEXT_COLOR_ACTION : actionEvent.getActionCommand()));
        if (string.equals(APPLY_FONT_ACTION)) {
            String string2 = this.getFont();
            StyledEditorKit.FontFamilyAction fontFamilyAction = (StyledEditorKit.FontFamilyAction)this.fontActions.get(string2);
            if (fontFamilyAction == null) {
                fontFamilyAction = new StyledEditorKit.FontFamilyAction("font-family-" + string2, string2);
                this.fontActions.put(string2, fontFamilyAction);
            }
            fontFamilyAction.actionPerformed(actionEvent);
        } else if (string.equals(APPLY_SIZE_ACTION)) {
            Integer n = new Integer(this.getFontSize());
            StyledEditorKit.FontSizeAction fontSizeAction = (StyledEditorKit.FontSizeAction)this.sizeActions.get(n);
            if (fontSizeAction == null) {
                fontSizeAction = new StyledEditorKit.FontSizeAction("font-size-" + n.toString(), n);
                this.sizeActions.put(n, fontSizeAction);
            }
            fontSizeAction.actionPerformed(actionEvent);
        } else if (string.equals(APPLY_BOLD_ACTION)) {
            this.boldAction.actionPerformed(actionEvent);
        } else if (string.equals(APPLY_ITALIC_ACTION)) {
            this.italicAction.actionPerformed(actionEvent);
        } else if (string.equals(APPLY_UNDERLINE_ACTION)) {
            this.underlineAction.actionPerformed(actionEvent);
        } else if (string.equals(APPLY_LEFT_ALIGN_ACTION)) {
            this.alignLeftAction.actionPerformed(actionEvent);
        } else if (string.equals(APPLY_CENTER_ALIGN_ACTION)) {
            this.alignCenterAction.actionPerformed(actionEvent);
        } else if (string.equals(APPLY_RIGHT_ALIGN_ACTION)) {
            this.alignRightAction.actionPerformed(actionEvent);
        } else if (string.equals(TEXT_COLOR_ACTION) && (color = JColorChooser.showDialog(this.colorButton, "Select Text Color", this.lastTextColor)) != null) {
            this.setTextColor(color);
        }
        this.textPane.requestFocus();
    }

    public void refresh() {
        this.fontObject.removeActionListener(this);
        this.sizeObject.removeActionListener(this);
        this.textPane.removeCaretListener(this);
        EditorKit editorKit = this.textPane.getEditorKit();
        Caret caret = editorKit.createCaret();
        int n = this.textPane.getCaretPosition();
        if (n > 0) {
            this.textPane.moveCaretPosition(n - 1);
        }
        StyledDocument styledDocument = this.textPane.getStyledDocument();
        AttributeSet attributeSet = this.textPane.getCharacterAttributes();
        Font font = styledDocument.getFont(attributeSet);
        Color color = styledDocument.getForeground(attributeSet);
        if (n > 0) {
            this.textPane.moveCaretPosition(n);
        }
        this.colorIcon.setColor(color);
        this.colorButton.repaint();
        Object object = null;
        boolean bl = false;
        int n2 = 0;
        while (!bl && n2 < this.fontObject.getItemCount()) {
            object = this.fontObject.getItemAt(n2);
            bl = object.toString().toLowerCase().equals(font.getFamily().toLowerCase());
            ++n2;
        }
        if (bl) {
            this.fontObject.setSelectedItem(object);
        } else {
            this.fontObject.setSelectedItem(font.getFamily());
        }
        object = null;
        bl = false;
        n2 = 0;
        while (!bl && n2 < this.sizeObject.getItemCount()) {
            object = this.sizeObject.getItemAt(n2);
            bl = object.equals(String.valueOf(font.getSize()));
            ++n2;
        }
        if (bl) {
            this.sizeObject.setSelectedItem(object);
        } else {
            this.sizeObject.setSelectedItem(String.valueOf(font.getSize()));
        }
        this.fontObject.addActionListener(this);
        this.sizeObject.addActionListener(this);
        this.textPane.addCaretListener(this);
    }

    public void caretUpdate(CaretEvent caretEvent) {
        Object object = caretEvent.getSource();
        if (object == this.textPane) {
            this.refresh();
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }
}

