/*
 * Decompiled with CFR 0.152.
 */
package com.quizzam.application.basic;

import java.io.File;
import javax.swing.filechooser.FileFilter;

public class SimpleFileFilter
extends FileFilter {
    String[] extensions;
    String description;
    boolean caseSensitive;

    public SimpleFileFilter(String[] stringArray, String string, boolean bl) throws IllegalArgumentException {
        if (stringArray == null || string == null) {
            throw new IllegalArgumentException("Cannot accept NULL as a parameter");
        }
        this.extensions = (String[])stringArray.clone();
        this.description = string;
        this.caseSensitive = bl;
    }

    public SimpleFileFilter(String string, String string2, boolean bl) throws IllegalArgumentException {
        if (string == null || string2 == null) {
            throw new IllegalArgumentException("Cannot accept NULL as a parameter");
        }
        this.extensions = new String[1];
        this.extensions[0] = string;
        this.description = string2;
        this.caseSensitive = bl;
    }

    public boolean accept(File file) {
        if (!file.isDirectory()) {
            boolean bl = false;
            int n = 0;
            while (!bl && n < this.extensions.length) {
                String string = file.getName();
                bl = this.caseSensitive ? string.endsWith(this.extensions[n]) : string.toUpperCase().endsWith(this.extensions[n].toUpperCase());
                ++n;
            }
            return bl;
        }
        return true;
    }

    public boolean getCaseSensitive() {
        return this.caseSensitive;
    }

    public String[] getExtensions() {
        return (String[])this.extensions.clone();
    }

    public String getDescription() {
        return this.description;
    }
}

