/*
 * Decompiled with CFR 0.152.
 */
package com.quizzam.application.basic;

import com.quizzam.application.basic.SelfPositioningDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class SelectExternalBrowserDialog
extends SelfPositioningDialog
implements ActionListener,
WindowListener {
    protected static final int WIDTH = 350;
    protected static final int HEIGHT = 175;
    JFileChooser fileChooser = null;
    private Color textColor;
    private Cursor actionCursor;
    private boolean result = false;
    private JLabel externalBrowserLabel;
    private JTextField externalBrowserPath;
    private JButton browserPathBrowseButton;

    public SelectExternalBrowserDialog(Frame frame, String string, boolean bl, Color color, Cursor cursor, JFileChooser jFileChooser) throws IllegalArgumentException {
        super(frame, string, bl);
        if (frame == null || string == null || color == null || cursor == null || jFileChooser == null) {
            throw new IllegalArgumentException("this method cannot accept NULL as a parameter");
        }
        this.initialize(color, cursor, jFileChooser);
    }

    public SelectExternalBrowserDialog(Dialog dialog, String string, boolean bl, Color color, Cursor cursor, JFileChooser jFileChooser) throws IllegalArgumentException {
        super(dialog, string, bl);
        if (dialog == null || string == null || color == null || cursor == null || jFileChooser == null) {
            throw new IllegalArgumentException("this method cannot accept NULL as a parameter");
        }
        this.initialize(color, cursor, jFileChooser);
    }

    private void initialize(Color color, Cursor cursor, JFileChooser jFileChooser) {
        this.textColor = color;
        this.actionCursor = cursor;
        this.fileChooser = jFileChooser;
        this.addWindowListener(this);
        this.getContentPane().add((Component)this.getButtonPanel(), "South");
        this.getContentPane().add((Component)this.getContentPanel(), "North");
        this.setSize(350, 175);
        this.setResizable(false);
    }

    private JPanel getButtonPanel() {
        JPanel jPanel = new JPanel();
        JButton jButton = new JButton("Apply");
        jButton.setActionCommand("apply");
        jButton.addActionListener(this);
        jButton.setCursor(this.actionCursor);
        jPanel.add(jButton);
        jButton = new JButton("Cancel");
        jButton.setActionCommand("cancel");
        jButton.addActionListener(this);
        jButton.setCursor(this.actionCursor);
        jPanel.add(jButton);
        return jPanel;
    }

    private JPanel getContentPanel() {
        JPanel jPanel = new JPanel(new GridLayout(5, 1, 0, 0));
        JPanel jPanel2 = null;
        JLabel jLabel = null;
        Object var7_4 = null;
        jPanel2 = new JPanel(new FlowLayout(1, 0, 0));
        jLabel = new JLabel("Specify the file that runs your web browser");
        jLabel.setAlignmentY(1.0f);
        jLabel.setForeground(this.textColor);
        jPanel2.add(jLabel);
        jPanel.add(jPanel2);
        jPanel2 = new JPanel(new FlowLayout(1, 0, 0));
        jLabel = new JLabel("program.  Usually, the filename ends in \".EXE\".");
        jLabel.setAlignmentY(1.0f);
        jLabel.setForeground(this.textColor);
        jPanel2.add(jLabel);
        jPanel.add(jPanel2);
        jPanel2 = new JPanel(new FlowLayout(1, 0, 0));
        jLabel = new JLabel(" ");
        jLabel.setAlignmentY(1.0f);
        jLabel.setForeground(this.textColor);
        jPanel2.add(jLabel);
        jPanel.add(jPanel2);
        this.externalBrowserLabel = new JLabel("External Browser's Executable File: ");
        this.externalBrowserPath = new JTextField("", 26);
        this.browserPathBrowseButton = new JButton("Browse");
        jPanel2 = new JPanel(new FlowLayout(1, 0, 0));
        jLabel = this.externalBrowserLabel;
        jLabel.setAlignmentY(1.0f);
        jLabel.setForeground(this.textColor);
        jPanel2.add(jLabel);
        jPanel.add(jPanel2);
        jPanel2 = new JPanel(new FlowLayout(1, 0, 0));
        jPanel2.add(this.externalBrowserPath);
        JButton jButton = this.browserPathBrowseButton;
        Font font = new Font(null, 0, 10);
        jButton.setFont(font);
        jButton.setMargin(new Insets(0, 0, 0, 0));
        jButton.setCursor(this.actionCursor);
        jButton.setActionCommand("browseForExternalBrowserPath");
        jButton.addActionListener(this);
        jPanel2.add(jButton);
        jPanel.add(jPanel2);
        return jPanel;
    }

    public void setBrowserPath(String string) {
        this.externalBrowserPath.setText(string);
    }

    public String getBrowserPath() {
        return this.externalBrowserPath.getText();
    }

    public boolean getResult() {
        return this.result;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("apply")) {
            this.result = true;
            this.dispose();
        } else if (string.equals("cancel")) {
            this.result = false;
            this.dispose();
        }
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
        this.result = false;
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.result = false;
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }
}

