/*
 * Decompiled with CFR 0.152.
 */
package com.quizzam.application.basic;

import com.quizzam.application.basic.StringPointer;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.Hashtable;
import javax.swing.JLabel;

public class RolloverLabelHandler
implements MouseMotionListener {
    private JLabel label;
    private Hashtable objects = new Hashtable();
    private boolean isEnabled = true;

    public RolloverLabelHandler(JLabel jLabel) throws IllegalArgumentException {
        if (jLabel == null) {
            throw new IllegalArgumentException("NULL cannot be supplied as a parameter");
        }
        this.label = jLabel;
    }

    public JLabel getRolloverLabel() {
        return this.label;
    }

    public void register(Object object, String string) {
        this.objects.put(object, string);
    }

    public void register(Object object, StringPointer stringPointer) {
        this.objects.put(object, stringPointer);
    }

    public void unregister(Object object) {
        this.objects.remove(object);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        Object v;
        Object object;
        if (this.isEnabled && (object = mouseEvent.getSource()) != null && (v = this.objects.get(object)) != null) {
            if (v instanceof StringPointer) {
                this.label.setText(((StringPointer)v).getString());
            } else {
                this.label.setText((String)v);
            }
        }
    }

    public void setEnabled(boolean bl) {
        this.isEnabled = bl;
    }

    public boolean getEnabled() {
        return this.isEnabled;
    }
}

