/*
 * Decompiled with CFR 0.152.
 */
package com.quizzam.application.basic;

import com.quizzam.application.basic.SelfPositioningDialog;
import com.quizzam.engine.QuizStrategy;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class RandomCardStrategyDialog
extends SelfPositioningDialog
implements ActionListener {
    QuizStrategy strategy;
    Box box;
    JTextField minSpacingField;
    protected static final int WIDTH = 300;
    protected static final int HEIGHT = 175;
    private Color textColor;
    private Cursor actionCursor;

    public RandomCardStrategyDialog(Frame frame, String string, boolean bl, Color color, Cursor cursor) throws IllegalArgumentException {
        super(frame, string, bl);
        if (frame == null || string == null || color == null || cursor == null) {
            throw new IllegalArgumentException("this method cannot accept NULL as a parameter");
        }
        this.initialize(color, cursor);
    }

    public RandomCardStrategyDialog(Dialog dialog, String string, boolean bl, Color color, Cursor cursor) throws IllegalArgumentException {
        super(dialog, string, bl);
        if (dialog == null || string == null || color == null || cursor == null) {
            throw new IllegalArgumentException("this method cannot accept NULL as a parameter");
        }
        this.initialize(color, cursor);
    }

    private void initialize(Color color, Cursor cursor) {
        this.textColor = color;
        this.actionCursor = cursor;
        this.getContentPane().add((Component)this.getButtonPanel(), "South");
        this.setSize(300, 175);
        this.setResizable(false);
    }

    public void setRandomCardStrategy(QuizStrategy quizStrategy) {
        this.strategy = quizStrategy;
        this.getContentPane().add((Component)this.getContentPanel(), "North");
    }

    private JPanel getButtonPanel() {
        JPanel jPanel = new JPanel();
        JButton jButton = new JButton("Apply");
        jButton.setActionCommand("apply");
        jButton.addActionListener(this);
        jButton.setCursor(this.actionCursor);
        jPanel.add(jButton);
        jButton = new JButton("Cancel");
        jButton.setActionCommand("cancel");
        jButton.addActionListener(this);
        jButton.setCursor(this.actionCursor);
        jPanel.add(jButton);
        return jPanel;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("apply")) {
            try {
                String string2 = this.minSpacingField.getText();
                this.strategy.setParameter("Spacing", string2);
                this.dispose();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                JOptionPane.showMessageDialog(this, "This parameter must be set to an integer greater than zero", "Invalid Parameters", 0);
            }
        } else if (string.equals("cancel")) {
            this.dispose();
        }
    }

    private JPanel getContentPanel() {
        JPanel jPanel = new JPanel(new GridLayout(5, 1, 0, 0));
        JPanel jPanel2 = null;
        JLabel jLabel = null;
        jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(1, 0, 0));
        jLabel = new JLabel("The next card shown will be selected at random.");
        jLabel.setAlignmentY(1.0f);
        jLabel.setForeground(this.textColor);
        jPanel2.add(jLabel);
        jPanel.add(jPanel2);
        jPanel.add(new JLabel(" "));
        this.minSpacingField = new JTextField(this.strategy.getParameter("Spacing"), 3);
        jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(1, 0, 0));
        jLabel = new JLabel("Show at least ");
        jLabel.setAlignmentY(1.0f);
        jLabel.setForeground(this.textColor);
        jPanel2.add(jLabel);
        jPanel2.add(this.minSpacingField);
        jLabel = new JLabel(" different cards before");
        jLabel.setAlignmentY(1.0f);
        jLabel.setForeground(this.textColor);
        jPanel2.add(jLabel);
        jPanel.add(jPanel2);
        jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(1, 0, 0));
        jLabel = new JLabel("repeating any specific card.");
        jLabel.setAlignmentY(1.0f);
        jLabel.setForeground(this.textColor);
        jPanel2.add(jLabel);
        jPanel.add(jPanel2);
        return jPanel;
    }
}

