/*
 * Decompiled with CFR 0.152.
 */
package com.quizzam.application.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;
import javax.swing.text.html.StyleSheet;

public class QuizzamBrowser
extends JFrame
implements HyperlinkListener,
ActionListener {
    JLabel rolloverLabel = new JLabel(" ");
    JTextPane textPane;
    JTextField urlTextField = new JTextField(30);
    JButton goButton = new JButton("Go");
    int height;
    int width;
    String title;

    public QuizzamBrowser(String string, int n, int n2, String string2) {
        super(string);
        this.title = string;
        Font font = new Font(null, 0, 12);
        this.setSize(n2, n);
        this.textPane = this.createTextPane();
        this.textPane.addHyperlinkListener(this);
        this.getContentPane().add((Component)new JScrollPane(this.textPane), "Center");
        this.getContentPane().add((Component)this.rolloverLabel, "South");
        JPanel jPanel = new JPanel(new FlowLayout(1, 0, 0));
        JLabel jLabel = this.createJLabel(Color.BLACK, "URL: ");
        jLabel.setFont(font);
        jPanel.add(jLabel);
        jPanel.add(this.urlTextField);
        jPanel.add(new JLabel(" "));
        JButton jButton = new JButton("Go");
        jButton.setFont(font);
        jButton.setMargin(new Insets(0, 0, 0, 0));
        jButton.setCursor(new Cursor(12));
        jButton.setActionCommand("go");
        jButton.addActionListener(this);
        jPanel.add(jButton);
        this.getContentPane().add((Component)jPanel, "North");
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(((int)dimension.getWidth() - this.getWidth()) / 2, ((int)dimension.getHeight() - this.getHeight()) / 2);
        this.setPage(string2);
    }

    private JTextPane createTextPane() {
        JTextPane jTextPane = new JTextPane(new HTMLDocument());
        StyleSheet styleSheet = new StyleSheet();
        styleSheet.addRule("BODY{ margin : 0; color:#000000}");
        styleSheet.addRule("A { text-decoration: underline; color:0000FF; font-weight:bold }");
        HTMLEditorKit hTMLEditorKit = new HTMLEditorKit();
        hTMLEditorKit.setStyleSheet(styleSheet);
        jTextPane.setEditorKit(hTMLEditorKit);
        jTextPane.setEditable(false);
        return jTextPane;
    }

    private JLabel createJLabel(Color color, String string) {
        JLabel jLabel = new JLabel(string);
        jLabel.setForeground(color);
        jLabel.setAlignmentY(1.0f);
        return jLabel;
    }

    public void setPage(String string) {
        try {
            this.setTitle(this.title + " - " + string);
            this.urlTextField.setText(string);
            this.textPane.setPage(string);
        }
        catch (IOException iOException) {
            this.setTitle(this.title + " - NO NETWORK CONNECTION");
            this.urlTextField.setText(string);
            this.textPane.setText("Could not establish a network connection.");
        }
        catch (Exception exception) {
            System.exit(1);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("close")) {
            this.dispose();
        } else if (string.equals("go")) {
            this.setPage(this.urlTextField.getText());
        }
    }

    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            if (hyperlinkEvent instanceof HTMLFrameHyperlinkEvent) {
                HTMLFrameHyperlinkEvent hTMLFrameHyperlinkEvent = (HTMLFrameHyperlinkEvent)hyperlinkEvent;
                HTMLDocument hTMLDocument = (HTMLDocument)this.textPane.getDocument();
                hTMLDocument.processHTMLFrameHyperlinkEvent(hTMLFrameHyperlinkEvent);
            } else {
                try {
                    this.textPane.setPage(hyperlinkEvent.getURL().toString());
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        } else if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ENTERED) {
            this.rolloverLabel.setText(hyperlinkEvent.getURL().toString());
        } else if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.EXITED) {
            this.rolloverLabel.setText(" ");
        }
    }
}

