/*
 * Decompiled with CFR 0.152.
 */
package com.quizzam.application.basic;

import com.quizzam.application.basic.AudioPlayerScreen;
import com.quizzam.application.basic.CommonFunctions;
import com.quizzam.application.basic.InsertHyperlinkDialog;
import com.quizzam.application.basic.InsertImageDialog;
import com.quizzam.application.basic.InsertSoundDialog;
import com.quizzam.application.basic.PreferencesManager;
import com.quizzam.application.basic.QuizzamBrowser;
import com.quizzam.application.basic.RefreshInterface;
import com.quizzam.application.basic.RolloverLabelHandler;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.Element;

public class MultimediaCoordinator
implements ActionListener,
HyperlinkListener {
    private Frame owner;
    private JTextPane textPane;
    private JButton insertImageButton;
    private JButton insertHyperlinkButton;
    private JButton insertSoundButton;
    private InsertImageDialog insertImageDialog;
    private InsertHyperlinkDialog insertHyperlinkDialog;
    private InsertSoundDialog insertSoundDialog;
    private AudioPlayerScreen audioPlayerScreen;
    private Color labelColor;
    private JFileChooser fileChooser;
    private PreferencesManager preferencesManager;
    private String userPreferencesFileName;
    private RolloverLabelHandler rolloverLabelHandler;
    private boolean modal;

    public MultimediaCoordinator(Frame frame, RefreshInterface refreshInterface, JTextPane jTextPane, boolean bl, JButton jButton, JButton jButton2, JButton jButton3, Color color, Cursor cursor, JFileChooser jFileChooser, PreferencesManager preferencesManager, String string, RolloverLabelHandler rolloverLabelHandler) throws IllegalArgumentException {
        if (frame == null || refreshInterface == null || jTextPane == null || jButton == null || color == null || cursor == null || jFileChooser == null || preferencesManager == null || string == null || rolloverLabelHandler == null) {
            throw new IllegalArgumentException("This method cannot take NULL as a parameter.");
        }
        this.owner = frame;
        this.textPane = jTextPane;
        this.insertImageButton = jButton;
        this.insertHyperlinkButton = jButton2;
        this.insertSoundButton = jButton3;
        this.labelColor = color;
        this.fileChooser = jFileChooser;
        this.preferencesManager = preferencesManager;
        this.userPreferencesFileName = string;
        this.rolloverLabelHandler = rolloverLabelHandler;
        this.modal = bl;
        jTextPane.addHyperlinkListener(this);
        jButton.addActionListener(this);
        jButton2.addActionListener(this);
        jButton3.addActionListener(this);
        this.insertImageDialog = new InsertImageDialog(frame, "Insert Image", bl, color, cursor, jFileChooser, jTextPane);
        this.insertHyperlinkDialog = new InsertHyperlinkDialog(frame, refreshInterface, "Insert Hyperlink", bl, color, cursor, jFileChooser, jTextPane);
        this.insertSoundDialog = new InsertSoundDialog(frame, refreshInterface, "Insert Sound/Audio", bl, color, cursor, jFileChooser, jTextPane);
        this.audioPlayerScreen = new AudioPlayerScreen(frame, "Quizzam Audio Player", bl, color, cursor);
    }

    public JTextPane getTextPane() {
        return this.textPane;
    }

    public JButton getInsertHyperlinkButton() {
        return this.insertHyperlinkButton;
    }

    public JButton getInsertImageButton() {
        return this.insertImageButton;
    }

    public JButton getInsertSoundButton() {
        return this.insertSoundButton;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.insertImageButton) {
            this.insertHyperlinkDialog.hide();
            this.insertSoundDialog.hide();
            this.insertImageDialog.show();
        } else if (object == this.insertHyperlinkButton) {
            this.insertImageDialog.hide();
            this.insertSoundDialog.hide();
            this.insertHyperlinkDialog.show();
        } else if (object == this.insertSoundButton) {
            this.insertImageDialog.hide();
            this.insertHyperlinkDialog.hide();
            this.insertSoundDialog.show();
        }
    }

    private String getAudioHyperlinkURL(HyperlinkEvent hyperlinkEvent) {
        AttributeSet attributeSet;
        boolean bl = false;
        Element element = hyperlinkEvent.getSourceElement();
        String string = null;
        if (element != null && (attributeSet = element.getAttributes()) != null) {
            Enumeration<?> enumeration = attributeSet.getAttributeNames();
            while (!bl && enumeration.hasMoreElements()) {
                string = attributeSet.getAttribute(enumeration.nextElement()).toString();
                bl = string.startsWith("href=AUDIO~");
            }
        }
        if (bl) {
            try {
                return string.substring(11);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                return null;
            }
        }
        return null;
    }

    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ENTERED) {
            JLabel jLabel = this.rolloverLabelHandler.getRolloverLabel();
            this.rolloverLabelHandler.setEnabled(false);
            URL uRL = hyperlinkEvent.getURL();
            if (uRL != null) {
                jLabel.setText(uRL.toString());
            } else {
                String string = this.getAudioHyperlinkURL(hyperlinkEvent);
                if (string != null) {
                    try {
                        uRL = new URL(string);
                        jLabel.setText("sound/audio link --> " + uRL.toString());
                    }
                    catch (MalformedURLException malformedURLException) {
                        jLabel.setText("sound/audio link --> INVALID HYPERLINK");
                    }
                } else {
                    jLabel.setText("INVALID HYPERLINK");
                }
            }
        } else if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.EXITED) {
            this.rolloverLabelHandler.setEnabled(true);
        } else if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            String string = this.getAudioHyperlinkURL(hyperlinkEvent);
            if (string != null) {
                try {
                    URL uRL = new URL(string);
                    this.audioPlayerScreen.setURL(uRL);
                    this.audioPlayerScreen.show();
                }
                catch (MalformedURLException malformedURLException) {
                    JOptionPane.showMessageDialog(this.owner, "This sound/audio hyperlink is not valid.  Please re-define this hyperlink with a valid file or web address.", "Invalid Sound/Audio Hyperlink", 0);
                }
            } else {
                Object object;
                int n;
                Properties properties = this.preferencesManager.getProperties();
                boolean bl = properties.getProperty(PreferencesManager.PARAM_HAS_EXTERNAL_BROWSER_QUESTION_BEEN_ASKED).equals("Y");
                boolean bl2 = properties.getProperty(PreferencesManager.PARAM_USE_EXTERNAL_INTERNET_BROWSER).trim().toUpperCase().equals("Y");
                if (!bl && !bl2) {
                    n = JOptionPane.showConfirmDialog(this.owner, "Would you like to use Internet Explorer, Netscape, or another browser to view hyperlinks?  This is recommended.", "Would you like to set up an external web browser?", 0);
                    if (n == 0) {
                        this.preferencesManager.showExternalBrowserSelectionScreen();
                    }
                    object = CommonFunctions.getFullPathName(this.userPreferencesFileName);
                    try {
                        this.preferencesManager.storeHasBrowserQuestionBeenAsked((String)object, true);
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        System.err.println(fileNotFoundException.getClass().getName() + ": " + fileNotFoundException.getMessage());
                        JOptionPane.showMessageDialog(this.owner, "The user preferences file, \"" + (String)object + "\", does not exist and could not be created.", "Could not save information to disk", 1);
                    }
                    catch (SecurityException securityException) {
                        System.err.println(securityException.getClass().getName() + ": " + securityException.getMessage());
                        JOptionPane.showMessageDialog(this.owner, "The security manager has denied \"write\" access to the user preferences file \"" + (String)object + "\".", "Could not save information to disk", 1);
                    }
                    catch (IOException iOException) {
                        System.err.println(iOException.getClass().getName() + ": " + iOException.getMessage());
                        JOptionPane.showMessageDialog(this.owner, "An I/0 error has occurred while writing the user preferences file \"" + (String)object + "\".", "Could not save information to disk", 1);
                    }
                    properties = this.preferencesManager.getProperties();
                    bl2 = properties.getProperty(PreferencesManager.PARAM_USE_EXTERNAL_INTERNET_BROWSER).trim().toUpperCase().equals("Y");
                    if (!bl2) {
                        JOptionPane.showMessageDialog(this.owner, "You have chosen to use Quizzam's internal web browser.", "Quizzam Web Browser will be used", 1);
                        JOptionPane.showMessageDialog(this.owner, "In the future, you may specify an external web browser by selecting \"Preferences\" in the FILE menu.", "Quizzam Web Browser will be used", 1);
                    }
                }
                if (bl2) {
                    object = properties.getProperty(PreferencesManager.PARAM_EXTERNAL_BROWSER_PATH);
                    n = this.launchExternalBrowser(hyperlinkEvent, (String)object) ? 1 : 0;
                    while (n == 0 && bl2) {
                        this.preferencesManager.showExternalBrowserSelectionScreen();
                        properties = this.preferencesManager.getProperties();
                        bl2 = properties.getProperty(PreferencesManager.PARAM_USE_EXTERNAL_INTERNET_BROWSER).trim().toUpperCase().equals("Y");
                        if (!bl2) {
                            JOptionPane.showMessageDialog(this.owner, "You have chosen to use Quizzam's internal web browser.", "Quizzam Web Browser will be used", 1);
                            JOptionPane.showMessageDialog(this.owner, "In the future, you may specify an external web browser by selecting \"Preferences\" in the FILE menu.", "Quizzam Web Browser will be used", 1);
                            continue;
                        }
                        object = properties.getProperty(PreferencesManager.PARAM_EXTERNAL_BROWSER_PATH);
                        n = this.launchExternalBrowser(hyperlinkEvent, (String)object) ? 1 : 0;
                    }
                }
                if (!bl2) {
                    if (hyperlinkEvent == null || hyperlinkEvent.getURL() == null) {
                        JOptionPane.showMessageDialog(this.owner, "This hyperlink is not valid.  Please re-define this hyperlink with a valid file or web address.", "Invalid Hyperlink", 0);
                    } else {
                        String string2 = hyperlinkEvent.getURL().toString();
                        object = new QuizzamBrowser("Quizzam Web Browser", 400, 400, string2);
                        ((Window)object).show();
                    }
                }
            }
        }
    }

    private boolean launchExternalBrowser(HyperlinkEvent hyperlinkEvent, String string) {
        boolean bl = false;
        try {
            if (string != null) {
                Runtime runtime = Runtime.getRuntime();
                if (hyperlinkEvent == null || hyperlinkEvent.getURL() == null) {
                    JOptionPane.showMessageDialog(this.owner, "This hyperlink is not valid.  Please re-define this hyperlink with a valid file or web address.", "Invalid Hyperlink", 0);
                } else {
                    String string2 = hyperlinkEvent.getURL().toString();
                    runtime.exec(string + " " + string2);
                }
                bl = true;
            } else {
                JOptionPane.showMessageDialog(this.owner, "Could not launch your external browser, because its location has not been specified.", "No External Browser Specified", 0);
            }
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this.owner, "Your external browser could not be launched.  Check the path of its executable file for errors.", "Could not launch external browser", 0);
            System.err.println(iOException.getClass().getName() + ": " + iOException.getMessage());
        }
        catch (SecurityException securityException) {
            JOptionPane.showMessageDialog(this.owner, "A security manager has prevented your external browser from being launched.", "Could not launch external browser", 0);
            System.err.println(securityException.getClass().getName() + ": " + securityException.getMessage());
        }
        return bl;
    }

    public void hideAllDialogs() {
        if (!this.modal) {
            this.insertImageDialog.hide();
            this.insertHyperlinkDialog.hide();
            this.insertSoundDialog.hide();
        }
    }
}

