/*
 * Decompiled with CFR 0.152.
 */
package com.quizzam.application.basic;

import com.quizzam.application.basic.ColorToHexConverter;
import com.quizzam.application.basic.SelfPositioningDialog;
import com.quizzam.application.basic.SimpleFileFilter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.regex.Pattern;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;

public class InsertImageDialog
extends SelfPositioningDialog
implements ActionListener {
    protected static final int WIDTH = 360;
    protected static final int HEIGHT = 200;
    private JTextField urlTextField = new JTextField(20);
    private JFileChooser fileChooser;
    private JTextPane textPane;
    private SimpleFileFilter graphicsFileFilter;

    public InsertImageDialog(Frame frame, String string, boolean bl, Color color, Cursor cursor, JFileChooser jFileChooser, JTextPane jTextPane) throws IllegalArgumentException {
        super(frame, string, bl);
        if (frame == null || string == null || color == null || cursor == null || jFileChooser == null || jTextPane == null) {
            throw new IllegalArgumentException("this method cannot accept NULL as a parameter");
        }
        this.fileChooser = jFileChooser;
        this.textPane = jTextPane;
        String[] stringArray = new String[]{".jpg", ".gif"};
        this.graphicsFileFilter = new SimpleFileFilter(stringArray, "Images (*.jpg, *.gif)", false);
        JTextPane jTextPane2 = this.createTextPane(color);
        this.getContentPane().add((Component)jTextPane2, "North");
        jTextPane2.setText("<b>Enter the URL of the image you want to insert, or click on the BROWSE button to insert an image from your local hard disk.  If the location of the image changes later on, it may no longer be visible.  To make it visible again, simply re-specify its location.<br></b>");
        this.getContentPane().add((Component)this.createInputPanel(color, cursor), "Center");
        this.getContentPane().add((Component)this.getButtonPanel(), "South");
        this.setSize(360, 200);
        this.setResizable(false);
        this.urlTextField.requestFocus();
    }

    private JTextPane createTextPane(Color color) {
        JTextPane jTextPane = new JTextPane(new DefaultStyledDocument());
        jTextPane.setBackground(this.owner.getBackground());
        jTextPane.setEditable(false);
        StyleSheet styleSheet = new StyleSheet();
        styleSheet.addRule("BODY{ margin : 0; color:" + ColorToHexConverter.convert(color) + "}");
        HTMLEditorKit hTMLEditorKit = new HTMLEditorKit();
        hTMLEditorKit.setStyleSheet(styleSheet);
        jTextPane.setEditorKit(hTMLEditorKit);
        return jTextPane;
    }

    private Box createInputPanel(Color color, Cursor cursor) {
        Box box = new Box(1);
        JPanel jPanel = new JPanel(new FlowLayout(1, 0, 0));
        JLabel jLabel = this.createJLabel(color, "URL: ");
        jPanel.add(jLabel);
        jLabel.setToolTipText("for example...   http://www.quizzam.com/logo.gif");
        this.urlTextField.setToolTipText("for example...   http://www.quizzam.com/logo.gif");
        jPanel.add(this.urlTextField);
        jPanel.add(new JLabel(" "));
        JButton jButton = new JButton("Browse");
        Font font = new Font(null, 0, 10);
        jButton.setFont(font);
        jButton.setMargin(new Insets(0, 0, 0, 0));
        jButton.setCursor(cursor);
        jButton.setActionCommand("browse");
        jButton.addActionListener(this);
        jPanel.add(jButton);
        box.add(jPanel);
        return box;
    }

    private JLabel createJLabel(Color color, String string) {
        JLabel jLabel = new JLabel(string);
        jLabel.setForeground(color);
        jLabel.setAlignmentY(1.0f);
        return jLabel;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("apply")) {
            HTMLEditorKit hTMLEditorKit = (HTMLEditorKit)this.textPane.getEditorKit();
            HTMLDocument hTMLDocument = (HTMLDocument)this.textPane.getDocument();
            int n = this.textPane.getCaretPosition();
            try {
                hTMLEditorKit.insertHTML(hTMLDocument, n, "<IMG SRC='" + this.urlTextField.getText() + "'>", 0, 0, HTML.Tag.IMG);
                String string2 = this.textPane.getText();
                string2 = Pattern.compile(".*<head>.\\s*", 32).matcher(string2).replaceAll("");
                string2 = Pattern.compile("\\s*</head>\\s*", 32).matcher(string2).replaceAll("");
                string2 = Pattern.compile("\\s*</head>\\s*", 32).matcher(string2).replaceAll("");
                string2 = Pattern.compile("\\s*<body>\\s*", 32).matcher(string2).replaceAll("");
                string2 = Pattern.compile("\\s*<body>\\s*", 32).matcher(string2).replaceAll("");
                string2 = Pattern.compile("\\s*</body>.*", 32).matcher(string2).replaceAll("");
                this.textPane.setText(string2);
                this.textPane.setCaretPosition(n + 1);
            }
            catch (BadLocationException badLocationException) {
                System.err.println(this.getClass().getName() + ".actionPerformed(): " + badLocationException.getClass().getName() + "   Msg=" + badLocationException.getMessage());
            }
            catch (IOException iOException) {
                System.err.println(this.getClass().getName() + ".actionPerformed(): " + iOException.getClass().getName() + "   Msg=" + iOException.getMessage());
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            this.dispose();
            this.textPane.requestFocus();
        } else if (string.equals("cancel")) {
            this.dispose();
            this.textPane.requestFocus();
        } else if (string.equals("browse")) {
            this.fileChooser.resetChoosableFileFilters();
            this.fileChooser.setFileFilter(this.graphicsFileFilter);
            if (0 == this.fileChooser.showDialog(this, "Insert")) {
                File file = this.fileChooser.getSelectedFile();
                this.urlTextField.setText("file:" + file.getPath());
            }
        }
    }

    private JPanel getButtonPanel() {
        JPanel jPanel = new JPanel();
        JButton jButton = new JButton("Insert");
        jButton.setActionCommand("apply");
        jButton.addActionListener(this);
        jPanel.add(jButton);
        jButton = new JButton("Cancel");
        jButton.setActionCommand("cancel");
        jButton.addActionListener(this);
        jPanel.add(jButton);
        return jPanel;
    }

    public void show() {
        this.urlTextField.setText("");
        super.show();
    }
}

