/*
 * Decompiled with CFR 0.152.
 */
package com.quizzam.application.basic;

import com.quizzam.application.basic.SelfPositioningDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ImportDialog
extends SelfPositioningDialog
implements ActionListener {
    protected static final int WIDTH = 325;
    protected static final int HEIGHT = 175;
    public static final int FLASHCARDS_ONLY = 1;
    public static final int STRATEGIES_ONLY = 2;
    public static final int FLASHCARDS_AND_STRATEGIES = 3;
    public static final int CANCEL = 4;
    int result = 4;
    JLabel strategiesLabel = new JLabel();
    JLabel cardsLabel = new JLabel();
    Color textColor;
    Cursor actionCursor;

    public ImportDialog(Frame frame, String string, boolean bl, Color color, Cursor cursor) throws IllegalArgumentException {
        super(frame, string, bl);
        if (frame == null || string == null || color == null || cursor == null) {
            throw new IllegalArgumentException("this method cannot accept NULL as a parameter");
        }
        this.initialize(color, cursor);
    }

    public ImportDialog(Dialog dialog, String string, boolean bl, Color color, Cursor cursor) throws IllegalArgumentException {
        super(dialog, string, bl);
        if (dialog == null || string == null || color == null || cursor == null) {
            throw new IllegalArgumentException("this method cannot accept NULL as a parameter");
        }
        this.initialize(color, cursor);
    }

    public void setNumCards(int n) {
        String string = null;
        string = n == 1 ? "card" : "cards";
        this.cardsLabel.setText("The selected file contains " + n + " " + string);
    }

    public void setNumStrategies(int n) {
        String string = null;
        string = n == 1 ? "strategy" : "strategies";
        this.strategiesLabel.setText("and " + n + " " + string + ".");
    }

    private void initialize(Color color, Cursor cursor) {
        this.textColor = color;
        this.actionCursor = cursor;
        this.getContentPane().add((Component)this.getContentPanel(), "Center");
        this.getContentPane().add((Component)this.getButtonPanel(), "South");
        this.setSize(325, 175);
        this.setResizable(false);
        this.strategiesLabel.setText("and 0 strategies.");
        this.strategiesLabel.setForeground(color);
        this.cardsLabel.setText("The selected file contains 0 cards");
        this.cardsLabel.setForeground(color);
    }

    private JPanel getButtonPanel() {
        JPanel jPanel = new JPanel();
        JButton jButton = new JButton("Cards");
        jButton.setActionCommand("cardsOnly");
        jButton.addActionListener(this);
        jButton.setCursor(this.actionCursor);
        jPanel.add(jButton);
        jButton = new JButton("Strategies");
        jButton.setActionCommand("strategiesOnly");
        jButton.addActionListener(this);
        jButton.setCursor(this.actionCursor);
        jPanel.add(jButton);
        jButton = new JButton("Both");
        jButton.setActionCommand("both");
        jButton.addActionListener(this);
        jButton.setCursor(this.actionCursor);
        jPanel.add(jButton);
        jButton = new JButton("Cancel");
        jButton.setActionCommand("cancel");
        jButton.addActionListener(this);
        jButton.setCursor(this.actionCursor);
        jPanel.add(jButton);
        return jPanel;
    }

    public int getResult() {
        return this.result;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("strategiesOnly")) {
            this.result = 2;
            this.setVisible(false);
        } else if (string.equals("cardsOnly")) {
            this.result = 1;
            this.setVisible(false);
        } else if (string.equals("both")) {
            this.result = 3;
            this.setVisible(false);
        } else if (string.equals("cancel")) {
            this.result = 4;
            this.setVisible(false);
        }
    }

    private JPanel getContentPanel() {
        JPanel jPanel = new JPanel(new GridLayout(5, 1, 0, 0));
        JPanel jPanel2 = null;
        JLabel jLabel = null;
        jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(1, 0, 0));
        jLabel = this.cardsLabel;
        jLabel.setAlignmentY(1.0f);
        jPanel2.add(jLabel);
        jPanel.add(jPanel2);
        jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(1, 0, 0));
        jLabel = this.strategiesLabel;
        jLabel.setAlignmentY(1.0f);
        jPanel2.add(jLabel);
        jPanel.add(jPanel2);
        jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(1, 0, 0));
        jLabel = new JLabel("");
        jLabel.setAlignmentY(1.0f);
        jPanel2.add(jLabel);
        jPanel.add(jPanel2);
        jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(1, 0, 0));
        jLabel = new JLabel("What would you like to import into");
        jLabel.setAlignmentY(1.0f);
        jLabel.setForeground(this.textColor);
        jPanel2.add(jLabel);
        jPanel.add(jPanel2);
        jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(1, 0, 0));
        jLabel = new JLabel("your current session?");
        jLabel.setAlignmentY(1.0f);
        jLabel.setForeground(this.textColor);
        jPanel2.add(jLabel);
        jPanel.add(jPanel2);
        return jPanel;
    }
}

