/*
 * Decompiled with CFR 0.152.
 */
package com.quizzam.application.basic;

import com.quizzam.application.basic.DeckHistoryListener;
import java.io.File;
import java.io.IOException;
import java.util.Vector;

public class DeckHistory {
    private String[] history = new String[4];
    private Vector listeners = new Vector();

    public DeckHistory() {
        this.clear();
    }

    public String getDeck(int n) throws IllegalArgumentException {
        if (n < 1 || n > 4) {
            throw new IllegalArgumentException("An invalid index (" + n + ") was specified.  The index must be between 1 and 4");
        }
        return this.history[n - 1];
    }

    public String addDeck(String string) throws IOException {
        if (string != null && string.trim().length() > 0) {
            File file = new File(string);
            try {
                string = file.getCanonicalPath();
            }
            catch (SecurityException securityException) {
                throw new IOException("The operating system has denied read access to " + string + ".");
            }
            catch (IOException iOException) {
                throw new IOException("An error occurred while trying to add the file \"" + string + "\" to the history log.  " + iOException.getMessage());
            }
            String string2 = this.history[3];
            int n = -1;
            int n2 = 3;
            while (n2 > 0) {
                this.history[n2] = this.history[n2 - 1];
                if (this.history[n2].equals(string)) {
                    n = n2;
                }
                --n2;
            }
            this.history[0] = string;
            if (n != -1) {
                int n3 = n;
                while (n3 < 3) {
                    this.history[n3] = this.history[n3 + 1];
                    ++n3;
                }
                this.history[3] = string2;
            }
        }
        int n = 0;
        while (n < this.listeners.size()) {
            ((DeckHistoryListener)this.listeners.get(n)).deckHistoryWasUpdated(this);
            ++n;
        }
        return string;
    }

    public void addListener(DeckHistoryListener deckHistoryListener) {
        if (deckHistoryListener != null) {
            this.listeners.add(deckHistoryListener);
        }
    }

    public boolean removeListener(DeckHistoryListener deckHistoryListener) {
        if (deckHistoryListener == null) {
            return false;
        }
        return this.listeners.remove(deckHistoryListener);
    }

    public void clear() {
        int n = 0;
        while (n < this.history.length) {
            this.history[n] = "";
            ++n;
        }
    }
}

