/*
 * Decompiled with CFR 0.152.
 */
package com.quizzam.application.basic;

import com.quizzam.application.basic.AddStrategyDialog;
import com.quizzam.application.basic.AggregateStrategyTableModel;
import com.quizzam.application.basic.AutoHighlightTextField;
import com.quizzam.application.basic.ColorToHexConverter;
import com.quizzam.application.basic.LeastRecentNextStrategyDialog;
import com.quizzam.application.basic.RandomCardStrategyDialog;
import com.quizzam.application.basic.RelativeScoreStrategyDialog;
import com.quizzam.application.basic.SelfPositioningDialog;
import com.quizzam.engine.AggregateStrategy;
import com.quizzam.engine.FlashcardEngine;
import com.quizzam.engine.QuizStrategy;
import com.quizzam.engine.basic.LeastRecentNextStrategy;
import com.quizzam.engine.basic.RandomCardStrategy;
import com.quizzam.engine.basic.RelativeScoreStrategy;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableColumn;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;

public class AggregateStrategyDialog
extends SelfPositioningDialog
implements ActionListener,
MouseListener,
FocusListener {
    protected static final int WIDTH = 375;
    protected static final int HEIGHT = 300;
    protected AggregateStrategy aggregateStrategy;
    protected JTable strategiesTable = new JTable();
    AutoHighlightTextField cellEditorTextField = new AutoHighlightTextField();
    AddStrategyDialog addStrategyDialog;
    AggregateStrategyTableModel tableModel;
    protected Color textColor;
    Cursor actionCursor;
    FlashcardEngine flashcardEngine;

    public AggregateStrategyDialog(FlashcardEngine flashcardEngine, Frame frame, String string, boolean bl, Color color, Cursor cursor) throws IllegalArgumentException {
        super(frame, string, bl);
        if (flashcardEngine == null || frame == null || string == null || color == null || cursor == null) {
            throw new IllegalArgumentException("this method cannot accept NULL as a parameter");
        }
        this.initialize(flashcardEngine, color, cursor);
    }

    public AggregateStrategyDialog(FlashcardEngine flashcardEngine, Dialog dialog, String string, boolean bl, Color color, Cursor cursor) throws IllegalArgumentException {
        super(dialog, string, bl);
        if (flashcardEngine == null || dialog == null || string == null || color == null || cursor == null) {
            throw new IllegalArgumentException("this method cannot accept NULL as a parameter");
        }
        this.initialize(flashcardEngine, color, cursor);
    }

    private void initialize(FlashcardEngine flashcardEngine, Color color, Cursor cursor) {
        this.addStrategyDialog = new AddStrategyDialog(flashcardEngine, this, "Add New Strategy", true, color, cursor);
        this.flashcardEngine = flashcardEngine;
        this.textColor = color;
        this.actionCursor = cursor;
        this.strategiesTable.setSelectionMode(0);
        this.cellEditorTextField.addFocusListener(this);
        this.strategiesTable.addMouseListener(this);
        this.strategiesTable.setDefaultEditor(new Object().getClass(), new DefaultCellEditor(this.cellEditorTextField));
        JTextPane jTextPane = this.createTextPane(color);
        jTextPane.setText(this.getInstructions());
        this.getContentPane().add((Component)jTextPane, "North");
        this.getContentPane().add((Component)new JScrollPane(this.strategiesTable), "Center");
        this.getContentPane().add((Component)this.getButtonPanel(), "South");
        this.setSize(375, 300);
        this.setResizable(true);
    }

    public void setAggregateStrategy(AggregateStrategy aggregateStrategy) {
        this.aggregateStrategy = aggregateStrategy;
        this.tableModel = new AggregateStrategyTableModel(aggregateStrategy);
        this.strategiesTable.setModel(this.tableModel);
        TableColumn tableColumn = this.strategiesTable.getColumnModel().getColumn(0);
        tableColumn.setMinWidth(15);
        tableColumn.setMaxWidth(300);
        tableColumn.setPreferredWidth(60);
        this.addStrategyDialog.setAggregateStrategyAndTableModel(aggregateStrategy, this.tableModel);
    }

    private JTextPane createTextPane(Color color) {
        JTextPane jTextPane = new JTextPane(new DefaultStyledDocument());
        jTextPane.setBackground(this.owner.getBackground());
        jTextPane.setEditable(false);
        StyleSheet styleSheet = new StyleSheet();
        styleSheet.addRule("BODY{ margin: 0; font-weight:bold; color:" + ColorToHexConverter.convert(color) + "}");
        HTMLEditorKit hTMLEditorKit = new HTMLEditorKit();
        hTMLEditorKit.setStyleSheet(styleSheet);
        jTextPane.setEditorKit(hTMLEditorKit);
        return jTextPane;
    }

    protected String getInstructions() {
        return "This strategy is simply an aggregation of strategies.&nbsp; To adjust how often each strategy is used relative to the others, modify the values in the \"Weight\" column (higher numbers result in more frequent use, while strategies with priorities of zero are not used at all).";
    }

    private JPanel getButtonPanel() {
        JPanel jPanel = new JPanel();
        JButton jButton = new JButton("Add");
        jButton.setActionCommand("add");
        jButton.addActionListener(this);
        jButton.setCursor(this.actionCursor);
        jPanel.add(jButton);
        jButton = new JButton("Remove");
        jButton.setActionCommand("remove");
        jButton.addActionListener(this);
        jButton.setCursor(this.actionCursor);
        jPanel.add(jButton);
        jButton = new JButton("Details");
        jButton.setActionCommand("details");
        jButton.addActionListener(this);
        jButton.setCursor(this.actionCursor);
        jPanel.add(jButton);
        jButton = new JButton("Close");
        jButton.setActionCommand("close");
        jButton.addActionListener(this);
        jButton.setCursor(this.actionCursor);
        jPanel.add(jButton);
        return jPanel;
    }

    public void focusGained(FocusEvent focusEvent) {
        this.cellEditorTextField.selectAll();
    }

    public void focusLost(FocusEvent focusEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        int n;
        int n2 = this.strategiesTable.getSelectedRow();
        if (this.strategiesTable.isCellEditable(n2, n = this.strategiesTable.getSelectedColumn())) {
            this.strategiesTable.editCellAt(n2, n);
            this.cellEditorTextField.requestFocus();
            this.cellEditorTextField.selectAll();
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("add")) {
            this.addStrategyDialog.show();
        } else if (string.equals("remove")) {
            int n = this.strategiesTable.getSelectedRow();
            if (n != -1) {
                if (0 == JOptionPane.showConfirmDialog(this, "Are you sure you want to delete the selected strategy?", "Delete Strategy", 0)) {
                    this.aggregateStrategy.removeStrategy(this.aggregateStrategy.getStrategies()[n]);
                    this.tableModel.fireTableDataChanged();
                }
            } else {
                JOptionPane.showMessageDialog(this, "Cannot delete strategy, since no strategy is currently selected.", "Cannot Delete Strategy", 0);
            }
        } else if (string.equals("details")) {
            int n = this.strategiesTable.getSelectedRow();
            if (n != -1) {
                QuizStrategy quizStrategy = this.aggregateStrategy.getStrategies()[n];
                if (quizStrategy == null) {
                    JOptionPane.showMessageDialog(this, "ERROR: The selected strategy does not exist.", "ERROR", 0);
                } else if (quizStrategy.getName() == "Custom Strategy") {
                    AggregateStrategyDialog aggregateStrategyDialog = new AggregateStrategyDialog(this.flashcardEngine, this, quizStrategy.getName(), true, this.textColor, this.actionCursor);
                    aggregateStrategyDialog.setAggregateStrategy((AggregateStrategy)quizStrategy);
                    aggregateStrategyDialog.show();
                } else if (quizStrategy.getName() == "Show cards not seen recently") {
                    LeastRecentNextStrategyDialog leastRecentNextStrategyDialog = new LeastRecentNextStrategyDialog(this, quizStrategy.getName(), true, this.textColor, this.actionCursor);
                    leastRecentNextStrategyDialog.setLeastRecentNextStrategy((LeastRecentNextStrategy)quizStrategy);
                    leastRecentNextStrategyDialog.show();
                } else if (quizStrategy instanceof RelativeScoreStrategy) {
                    RelativeScoreStrategyDialog relativeScoreStrategyDialog = new RelativeScoreStrategyDialog(this, quizStrategy.getName(), true, this.textColor, this.actionCursor);
                    relativeScoreStrategyDialog.setRelativeScoreStrategy((RelativeScoreStrategy)quizStrategy);
                    relativeScoreStrategyDialog.show();
                } else if (quizStrategy instanceof RandomCardStrategy) {
                    RandomCardStrategyDialog randomCardStrategyDialog = new RandomCardStrategyDialog(this, quizStrategy.getName(), true, this.textColor, this.actionCursor);
                    randomCardStrategyDialog.setRandomCardStrategy((LeastRecentNextStrategy)quizStrategy);
                    randomCardStrategyDialog.show();
                } else {
                    JOptionPane.showMessageDialog(this, "Details do not exist for this strategy.", "Cannot Show Strategy Details", 0);
                }
            } else {
                JOptionPane.showMessageDialog(this, "Cannot show details, since no strategy is currently selected.", "Cannot Show Strategy Details", 0);
            }
        } else if (string.equals("close")) {
            this.strategiesTable.editingStopped(new ChangeEvent(this));
            this.dispose();
        }
    }
}

