/*
 * Decompiled with CFR 0.152.
 */
package com.quizzam.application.basic;

import com.quizzam.application.basic.SelfPositioningDialog;
import com.quizzam.engine.AggregateStrategy;
import com.quizzam.engine.FlashcardEngine;
import com.quizzam.engine.QuizStrategy;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;

public class AddStrategyDialog
extends SelfPositioningDialog
implements ActionListener,
FocusListener {
    protected static final int WIDTH = 300;
    protected static final int HEIGHT = 200;
    protected AggregateStrategy aggregateStrategy;
    JComboBox strategyTypeBox;
    JTextField weightField = new JTextField("1", 5);
    AbstractTableModel tableModel;
    Color textColor;
    Cursor actionCursor;
    FlashcardEngine flashcardEngine;
    QuizStrategy sampleRandomStrategy;
    QuizStrategy sampleRelativeScoreStrategy;
    QuizStrategy sampleAggregateStrategy;
    QuizStrategy sampleLeastRecentNextStrategy;

    public AddStrategyDialog(FlashcardEngine flashcardEngine, Frame frame, String string, boolean bl, Color color, Cursor cursor) throws IllegalArgumentException {
        super(frame, string, bl);
        if (frame == null || string == null || color == null || cursor == null) {
            throw new IllegalArgumentException("this method cannot accept NULL as a parameter");
        }
        this.initialize(flashcardEngine, color, cursor);
    }

    public AddStrategyDialog(FlashcardEngine flashcardEngine, Dialog dialog, String string, boolean bl, Color color, Cursor cursor) throws IllegalArgumentException {
        super(dialog, string, bl);
        if (dialog == null || string == null || color == null || cursor == null) {
            throw new IllegalArgumentException("this method cannot accept NULL as a parameter");
        }
        this.initialize(flashcardEngine, color, cursor);
    }

    private void initialize(FlashcardEngine flashcardEngine, Color color, Cursor cursor) {
        this.flashcardEngine = flashcardEngine;
        this.textColor = color;
        this.actionCursor = cursor;
        Container container = this.getContentPane();
        this.weightField.addFocusListener(this);
        container.add((Component)this.getContentPanel(), "North");
        container.add((Component)this.getButtonPanel(), "South");
        this.setSize(300, 200);
        this.setResizable(false);
    }

    private JPanel getButtonPanel() {
        JPanel jPanel = new JPanel();
        JButton jButton = new JButton("Add");
        jButton.setActionCommand("add");
        jButton.addActionListener(this);
        jButton.setCursor(this.actionCursor);
        jPanel.add(jButton);
        jButton = new JButton("Cancel");
        jButton.setActionCommand("cancel");
        jButton.addActionListener(this);
        jButton.setCursor(this.actionCursor);
        jPanel.add(jButton);
        return jPanel;
    }

    private JPanel getContentPanel() {
        String[] stringArray = new String[]{"Concentrate on the harder cards", "Show cards not seen recently", "Show Random Cards", "Custom Strategy"};
        this.strategyTypeBox = new JComboBox<String>(stringArray);
        JPanel jPanel = new JPanel(new GridLayout(5, 1, 0, 0));
        JPanel jPanel2 = null;
        JLabel jLabel = null;
        jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(1, 0, 0));
        jLabel = new JLabel("What type of strategy would you like to add?");
        jLabel.setAlignmentY(1.0f);
        jLabel.setForeground(this.textColor);
        jPanel2.add(jLabel);
        jPanel.add(jPanel2);
        this.strategyTypeBox.setAlignmentY(0.0f);
        jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(1, 0, 0));
        jPanel2.add(this.strategyTypeBox);
        jPanel2.setAlignmentY(0.0f);
        jPanel.add(jPanel2);
        jPanel.add(new JLabel(" "));
        jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(1, 0, 0));
        jLabel = new JLabel("What weight should be assigned to it?");
        jLabel.setAlignmentY(1.0f);
        jLabel.setForeground(this.textColor);
        jPanel2.add(jLabel);
        jPanel.add(jPanel2);
        this.weightField.setAlignmentY(0.0f);
        jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(1, 0, 0));
        jPanel2.add(this.weightField);
        jPanel.add(jPanel2);
        return jPanel;
    }

    public void setAggregateStrategyAndTableModel(AggregateStrategy aggregateStrategy, AbstractTableModel abstractTableModel) throws IllegalArgumentException {
        if (aggregateStrategy == null || abstractTableModel == null) {
            throw new IllegalArgumentException("This method cannot accept NULL values for the AggregateStrategy and AbstractTableModel parameters.");
        }
        this.aggregateStrategy = aggregateStrategy;
        this.tableModel = abstractTableModel;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        block9: {
            String string = actionEvent.getActionCommand();
            if (string.equals("add")) {
                try {
                    int n = Integer.parseInt(this.weightField.getText());
                    if (n < 1) {
                        throw new NumberFormatException();
                    }
                    if (this.aggregateStrategy != null) {
                        String string2 = (String)this.strategyTypeBox.getSelectedItem();
                        try {
                            this.aggregateStrategy.addStrategy(this.flashcardEngine.createStrategy(string2), n);
                            this.tableModel.fireTableDataChanged();
                            this.closeDialog();
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            JOptionPane.showMessageDialog(this, "The strategy could not be added, because the strategy type is unknown", "Error", 0);
                        }
                        break block9;
                    }
                    JOptionPane.showMessageDialog(this, "The strategy could not be added, because I do not know where we are supposed to add it.", "Error", 0);
                }
                catch (NumberFormatException numberFormatException) {
                    JOptionPane.showMessageDialog(this, "Strategy Weight must be a numeric value greater than or equal to zero.", "Invalid Strategy Weight.", 0);
                }
            } else if (string.equals("cancel")) {
                this.closeDialog();
            }
        }
    }

    private void closeDialog() {
        this.dispose();
    }

    public void focusGained(FocusEvent focusEvent) {
        this.weightField.selectAll();
    }

    public void focusLost(FocusEvent focusEvent) {
    }
}

