VERSION 5.00
Begin VB.Form frmVBMatrDemo 
   BorderStyle     =   3  'Fixed Dialog
   Caption         =   "VBMatrDemo"
   ClientHeight    =   6225
   ClientLeft      =   45
   ClientTop       =   390
   ClientWidth     =   11115
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   6225
   ScaleWidth      =   11115
   ShowInTaskbar   =   0   'False
   StartUpPosition =   3  'Windows Default
   Begin VB.CommandButton Command1 
      Caption         =   "&mSist"
      Default         =   -1  'True
      Height          =   375
      Left            =   3000
      TabIndex        =   14
      Top             =   5760
      Width           =   795
   End
   Begin VB.Frame Frame1 
      Caption         =   "Debug Output"
      Height          =   675
      Left            =   5760
      TabIndex        =   9
      Top             =   4980
      Width           =   5175
      Begin VB.OptionButton optText1 
         Caption         =   "TextBox"
         Height          =   195
         Left            =   180
         TabIndex        =   13
         Top             =   300
         Value           =   -1  'True
         Width           =   1815
      End
      Begin VB.OptionButton optPic1 
         Caption         =   "PictureBox"
         Height          =   195
         Left            =   2640
         TabIndex        =   12
         Top             =   300
         Width           =   1815
      End
   End
   Begin VB.TextBox Text1 
      Height          =   4575
      Left            =   5760
      MultiLine       =   -1  'True
      ScrollBars      =   3  'Both
      TabIndex        =   8
      Top             =   300
      Width           =   5175
   End
   Begin VB.CommandButton btnAbout 
      Caption         =   "&About"
      Height          =   375
      Left            =   3840
      TabIndex        =   7
      Top             =   5280
      Width           =   795
   End
   Begin VB.CommandButton btnEnd 
      Cancel          =   -1  'True
      Caption         =   "&End"
      Height          =   375
      Left            =   4740
      TabIndex        =   5
      Top             =   5280
      Width           =   795
   End
   Begin VB.CommandButton btnGO 
      Caption         =   "&Show"
      Height          =   375
      Left            =   3000
      TabIndex        =   3
      Top             =   5280
      Width           =   795
   End
   Begin VB.HScrollBar HScroll1 
      Height          =   315
      Left            =   2220
      TabIndex        =   2
      Top             =   5280
      Width           =   675
   End
   Begin VB.TextBox txtK 
      Alignment       =   2  'Center
      Height          =   315
      Left            =   1560
      TabIndex        =   1
      Text            =   "3"
      Top             =   5280
      Width           =   555
   End
   Begin VB.PictureBox pic1 
      AutoRedraw      =   -1  'True
      Height          =   4155
      Left            =   300
      ScaleHeight     =   4095
      ScaleWidth      =   5175
      TabIndex        =   0
      Top             =   300
      Width           =   5235
   End
   Begin VB.Label Label4 
      Caption         =   "TextBox"
      Height          =   195
      Left            =   5820
      TabIndex        =   11
      Top             =   60
      Width           =   2355
   End
   Begin VB.Label Label3 
      Caption         =   "PictureBox"
      Height          =   195
      Left            =   360
      TabIndex        =   10
      Top             =   60
      Width           =   2355
   End
   Begin VB.Label Label2 
      Caption         =   "Polinomial Rank"
      Height          =   255
      Left            =   360
      TabIndex        =   6
      Top             =   5340
      Width           =   1155
   End
   Begin VB.Label Label1 
      Caption         =   "text"
      Height          =   495
      Left            =   360
      TabIndex        =   4
      Top             =   4620
      Width           =   5115
   End
End
Attribute VB_Name = "frmVBMatrDemo"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit
Dim m As New Matr ' Be sure VBMatr is selected in the Project > References Windows

'This Array can be dinamically redimensioned, Preserving the values
Dim P#(2, 5) '5 is the number of Observed Points, 1 is X Coordinate, 2 is Y Coordinate
'This Array can NOT be dinamically redimensioned, without resetting the values
'Dim P#(5, 2) '5 is the number of Observed Points, 1 is X Coordinate, 2 is Y Coordinate

Private Sub btnAbout_Click()
  m.mShowAbout
End Sub

Private Sub btnEnd_Click()
  End
End Sub

Private Sub btnGO_Click()

  'Show Polinomial Curve
  Show_mPolin

End Sub

Private Sub Command1_Click()
  Dim vetX#(3), mtrA#(3, 3), vetB#(3)
  
  mtrA#(1, 1) = 0: mtrA#(1, 2) = 1: mtrA#(1, 3) = 4.1
  mtrA#(2, 1) = 78.36: mtrA#(2, 2) = 90: mtrA#(2, 3) = 72.2747
  mtrA#(3, 1) = 7.0024: mtrA#(3, 2) = 9.0031: mtrA#(3, 3) = 62.6245
  
  vetB(1) = 4: vetB(2) = 3: vetB(3) = 7
  Call m.mSist(vetX#(), mtrA#(), vetB#()):
    
  m.mPrint vetX(), Text1, , , "vetX is:"
    
End Sub

Private Sub Form_Load()
Dim MaxI&

  MaxI = IIf(UBound(P, 1) > UBound(P, 2), UBound(P, 1), UBound(P, 2))
  HScroll1.Max = MaxI - 1 'Max Rank of the Polinomial Curve
  HScroll1.Min = 1                'Min Rank = Line
  HScroll1.Value = 2
  Label1 = "Change Rank Value and press [&Show] to see Polinomial Curve" + vbCr
  Label1 = Label1 + "(Rank to go from 1 to 4 because of 5 Observation Points)"

End Sub

Sub Show_mPolin()
Dim k&, Coeff#()

  'set Observed Points Coordinates
  P#(1, 1) = 0: P#(1, 2) = 1: P#(1, 3) = 4.1
  P#(2, 1) = 78.36: P#(2, 2) = 90: P#(2, 3) = 72.2747
  P#(1, 4) = 7.0024: P#(1, 5) = 9.0031
  P#(2, 4) = 62.6245: P#(2, 5) = 52.934
  
  'P#(1, 1) = 0: P#(2, 1) = 1: P#(3, 1) = 4.1
  'P#(1, 2) = 78.36: P#(2, 2) = 90: P#(3, 2) = 72.2747
  'P#(4, 1) = 7.0024: P#(5, 1) = 9.0031
  'P#(4, 2) = 62.6245: P#(5, 2) = 52.934

  k = txtK + 1 'k rank of the Matrix => Polinomial Rank = k-1 <= n-2

  'calc k Polinomial Coeffiecients
  m.mPolin Coeff#(), P#(), k

  'show Coeffiecients in the debug window
  m.mPrint Coeff#()

  'show Polinomial Curve in the picturebox
  Show_PolinCurve P#(), Coeff#()

  If optPic1 Then MsgBox "Press OK to continue..."
  
  TestRandomMatrix
End Sub

Sub Show_PolinCurve(P#(), Coeff#())
Dim i&, x#, y#, MaxY#, clr&

  'setup chart picture
  pic1.ScaleWidth = 10: pic1.ScaleHeight = 100
  MaxY = pic1.ScaleHeight 'To invert Scale
  pic1.FillStyle = 0
  pic1.Cls

  'plot Observation Points
  If UBound(P, 2) = 2 Then
    For i = 1 To 5
      clr = RGB(Rnd * 255, Rnd * 255, Rnd * 255) 'Just a little fantasy
      pic1.FillColor = clr
      pic1.Circle (P(i, 1), (MaxY - P(i, 2))), 0.1
    Next i
  ElseIf UBound(P, 1) = 2 Then
    For i = 1 To 5
      clr = RGB(Rnd * 255, Rnd * 255, Rnd * 255) 'Just a little fantasy
      pic1.FillColor = clr
      pic1.Circle (P(1, i), (MaxY - P(2, i))), 0.1
    Next i
  End If
  'plot polinomial curve
  For x = 0 To 10 Step 0.1
    'Polinomial is y=Coeff(0) + Coeff(1) * x + Coeff(2) * x^2 + ... + Coeff(k) * x^(k-1)
    y = m.mGetYPolin(x, Coeff#())
    pic1.PSet (x, MaxY - y)
  Next x

End Sub

Private Sub HScroll1_Change()
  txtK = HScroll1.Value
End Sub

Sub TestRandomMatrix()
Dim ret, r&, c&, n&, A#(), AI#(), AT#(), DetA#, DetAI#, DetAT#
Dim Obj As Object
  
  ret = InputBox("Input order of the sample Random Matrix: ", "VBMatr", 4)
  If IsNumeric(ret) Then n = ret Else n = 4
  
  ReDim A#(n, n)
  For r = 1 To n
    For c = 1 To n
      A(r, c) = 10 * Rnd() - 5
    Next c
  Next r
  
  'duplicate [A] in [A]I
  m.mDupl AI#(), A#()
  m.mDupl AT#(), A#()
  
  'set Output device
  If optPic1 Then
    Set Obj = pic1
  Else
    Set Obj = Text1
  End If
  Obj.Font = "Courier New"
  
  'print                                                  reset content
  m.mPrint A(), Obj, , "0.0", "Matrix [A] is:", , False
  DetA = m.mDet(A()) 'calculate determinant
  m.mPrint DetA, Obj, , , vbCrLf + "Determinant of [A] is:"
  
  'create [A]T = Trasposed matrix of [A]
  m.mTrasp AT#(), A#()
  'print
  m.mPrint AT(), Obj, , "0.0", vbCrLf + "Matrix [A]T is:"
  DetAT = m.mDet(AT())
  m.mPrint DetAT, Obj, , , vbCrLf + "Determinant of [A]T is:"
  
  'invert AI# (mDet[A]I = 1/mDet[A])
  m.mInv AI#()
  'print
  m.mPrint AI(), Obj, , "0.0", vbCrLf + "Matrix [A]I is:"
  DetAI = m.mDet(AI())
  m.mPrint DetAI, Obj, , , vbCrLf + "Determinant of [A]I is:"
  
End Sub
