<%@ Control Language="c#" AutoEventWireup="false" Codebehind="Edit.ascx.cs" Inherits="Tp.Web.ProjectSpace.Planning.Iterations.Edit" TargetSchema="http://schemas.microsoft.com/intellisense/ie5" %>
<%@ Register TagPrefix="ew" Assembly="eWorld.UI, Version=1.9.0.0, Culture=neutral, PublicKeyToken=24d65337282035f2" Namespace="eWorld.UI" %>
<asp:Panel id="mainPanel" Runat=server>
<DIV class="wizardTitle green">Iteration</DIV>
<TABLE class=wizardMain id=Table1 cellSpacing=5 cellPadding=0 width=320 
border=0>
  <TR>
    <TD>Release</TD>
    <TD>
<asp:DropDownList id=ddReleaseId runat="server"></asp:DropDownList></TD></TR>
  <TR>
    <TD nowrap>Name <SPAN class=warning>*</SPAN></TD>
    <TD>
    <asp:RequiredFieldValidator 
		id=vldNameReq 
		runat="server" 
		CssClass="warning" 
		ErrorMessage="Name should not be empty" 
		Display="Dynamic" 
		ControlToValidate="txtName" 
		EnableClientScript="False" />
	<asp:TextBox 
		id=txtName 
		runat="server"
		Width="300" 
		MaxLength="90" />
	</TD></TR>
  <TR>
    <TD>Description</TD>
    <TD>
		 <asp:RegularExpressionValidator
			id="nameRegex"
			runat="server" 
			ControlToValidate="txtDescription" 
			Display="Dynamic"
			EnableClientScript="False"
			CssClass="warning"
			ValidationExpression="^[a-zA-Z'.\s\S-]{1,600}$" 
			ErrorMessage="Description should be less than 600 characters length" />
					
		<asp:TextBox id=txtDescription runat="server" Width="300" Height="150" TextMode="MultiLine"></asp:TextBox></TD></TR>
  <TR>
    <TD><br>Velocity</TD>
    <TD>
    <asp:RequiredFieldValidator id=vldVelocityReq runat="server"
		CssClass="warning"
		ErrorMessage="Velocity should not be empty"
		Display="Dynamic"
		ControlToValidate="txtVelocity"
		EnableClientScript="False" />
		
    <asp:CompareValidator id=vldVelocityCompare runat="server"
		CssClass="warning"
		ErrorMessage="Velocity should be an integer (for example: 12)"
		Display="Dynamic"
		ControlToValidate="txtVelocity"
		EnableClientScript="False"
		Operator="DataTypeCheck"
		Type="Integer" />
	<br>
	<asp:TextBox id=txtVelocity runat="server" Width="20">0</asp:TextBox>
	</TD></TR>
  <TR>
    <TD nowrap><br />Start Date <SPAN class=warning>*</SPAN></TD>
    <TD>
    <asp:CompareValidator id=vldStartDateCompare runat="server" 
		CssClass="warning"
		ErrorMessage="Start Date should be in mm/dd/yyyy format (for example: 02/28/2005)"
		Display="Dynamic"
		ControlToValidate="cpStartDate"
		EnableClientScript="False"
		Operator="DataTypeCheck"
		Type="Date" />
		
	<asp:RequiredFieldValidator id=vldStartDateReq runat="server"
		CssClass="warning"
		ErrorMessage="Start Date should not be empty"
		Display="Dynamic"
		ControlToValidate="cpStartDate"
		EnableClientScript="False" />
	<br />	
	<ew:CalendarPopup
		CssClass="calendar" 
		DisableTextboxEntry="false"
		CalendarWidth="180"
		id="cpStartDate"
		runat="server"
		ControlDisplay="TextBoxImage"
		Text="Change Date"
		ImageUrl="~/i/calendar.gif">
			<MonthHeaderStyle BackColor="#78D57A" ForeColor="white" />
			<DayHeaderStyle BackColor="#FE9213" ForeColor="black" />
	</ew:CalendarPopup>
</TD></TR>
  <TR>
    <TD nowrap><br>Duration <SPAN class=warning>*</SPAN></TD>
    <TD>
<asp:RequiredFieldValidator id=vldDurationReq runat="server" CssClass="warning" ErrorMessage="Duration should not be empty" Display="Dynamic" ControlToValidate="txtDuration" EnableClientScript="False" />
<asp:CompareValidator id=vldDurationCompare runat="server" CssClass="warning" ErrorMessage="Duration should be an integer (for example: 2)" Display="Dynamic" ControlToValidate="txtDuration" EnableClientScript="False" Operator="DataTypeCheck" Type="Integer" />
<br>
<asp:TextBox id=txtDuration runat="server" Width="20">2</asp:TextBox> week(s)
</TD></TR>
  <TR>
    <TD></TD>
    <TD>
<asp:Button id=btnAdd runat="server" Text="Save & Exit" CssClass="button"></asp:Button></TD></TR></TABLE>
</asp:Panel>
