<%@ Control Language="c#" AutoEventWireup="false" Codebehind="Edit.ascx.cs" Inherits="Tp.Web.ProjectSpace.Edit" TargetSchema="http://schemas.microsoft.com/intellisense/ie5" %>
<%@ Register TagPrefix="ew" Assembly="eWorld.UI, Version=1.9.0.0, Culture=neutral, PublicKeyToken=24d65337282035f2" Namespace="eWorld.UI" %>
<meta content="False" name="vs_snapToGrid">
<asp:panel id="mainPanel" Runat="server">
	<DIV class="wizardTitle green">Project</DIV>
	<TABLE class="wizardMain" id="Table1" cellSpacing="1" cellPadding="1" width="300" border="0">
		<TR>
			<TD noWrap><BR>
				Title <SPAN class="warning">*</SPAN></TD>
			<TD noWrap>
				<asp:RequiredFieldValidator
					id="vldNameReq"
					runat="server"
					Display="Dynamic"
					ControlToValidate="txtName"
					EnableClientScript="False"
					ErrorMessage="Name should not be empty"
					CssClass="warning" /><BR />
				<asp:TextBox id="txtName" width="300" runat="server" MaxLength="90"></asp:TextBox></TD>
		</TR>
		<TR>
			<TD>Description</TD>
			<TD>
				 <asp:RegularExpressionValidator
					id="nameRegex"
					runat="server" 
					ControlToValidate="txtDescription" 
					Display="Dynamic"
					EnableClientScript="False"
					CssClass="warning"
			        ValidationExpression="^[a-zA-Z'.\s\S-]{1,500}$" 
					ErrorMessage="Description should be no more than 500 characters length" />
			
				<asp:TextBox id="txtDescription" runat="server" TextMode="MultiLine" MaxLength="2" Width="300" Height="150"></asp:TextBox></TD>
		</TR>
		<TR>
			<TD noWrap>
			<br />Start Date <SPAN class="warning">*</SPAN></TD>
			<TD noWrap>
				<asp:RequiredFieldValidator id="vldStartDateReq" runat="server" Display="Dynamic" ControlToValidate="cpStartDate"
					ErrorMessage="Start Date should not be empty" CssClass="warning"></asp:RequiredFieldValidator>
				<asp:CompareValidator id="vldStartDateCompare" runat="server" Display="Dynamic" ControlToValidate="cpStartDate"
					EnableClientScript="False" ErrorMessage="Start Date should be in mm/dd/yyyy format (for example: 02/24/2004)"
					CssClass="warning" Operator="DataTypeCheck" Type="Date"></asp:CompareValidator><BR>
				<ew:CalendarPopup id="cpStartDate" runat="server" CssClass="calendar" Culture="English (United States)"
					DisableTextboxEntry="false" CalendarWidth="180" ControlDisplay="TextBoxImage"
					Text="Change Date" ImageUrl="~/i/calendar.gif">
					<MonthHeaderStyle BackColor="#78D57A" ForeColor="white" />
					<DayHeaderStyle BackColor="#FE9213" ForeColor="black" />
				</ew:CalendarPopup></TD>
		</TR>
		<TR>
			<TD><BR>
				End Date</TD>
			<TD noWrap>
				<asp:CompareValidator
					id="vldEndDateCompare"
					runat="server"
					Display="Dynamic"
					ControlToValidate="cpEndDate"
					EnableClientScript="False"
					ErrorMessage="End Date should be in mm/dd/yyyy format (for example: 02/24/2004)"
					CssClass="warning"
					Operator="DataTypeCheck"
					Type="Date" />
				
				<asp:CustomValidator id="vldEndDateLessThanStart" 
		            runat="server"
		            ControlToValidate="cpEndDate" 
		            CssClass="warning"
				    ErrorMessage="End Date should be greater than Start Date" />


					<br />
				<ew:CalendarPopup id="cpEndDate" runat="server" CssClass="calendar" Culture="English (United States)"
					DisableTextboxEntry="false" CalendarWidth="180" ControlDisplay="TextBoxImage" Text="Change Date"
					ImageUrl="~/i/calendar.gif">
					<MonthHeaderStyle BackColor="#78D57A" ForeColor="white" />
					<DayHeaderStyle BackColor="#FE9213" ForeColor="black" />
				</ew:CalendarPopup></TD>
		</TR>
		<TR>
			<TD></TD>
			<TD>
				<asp:Button id="btnAdd" runat="server" CssClass="button" Text="Save & Exit"></asp:Button></TD>
		</TR>
	</TABLE>
</asp:panel>