' ____________________________________________________________________________
' Variables and Initialization
Dim navFrame
Dim numTrackedValues
Dim pageIDs(32)
Dim values(32)
numTrackedValues = 0
' ____________________________________________________________________________
' Persistent Page Values. Saves a value for a page in our persistent array.
Sub SaveValueForPage(url, name, value)
    On Error Resume Next
    id = url & ";" & name
    For i = 0 to numTrackedValues - 1
        If (pageIDs(i) = Right(id, len(pageIDs(i)))) Then
            values(i) = value
            Exit Sub
        End If
    Next
    pageIDs(numTrackedValues) = id
    values(numTrackedValues) = value
    numTrackedValues = numTrackedValues + 1
End Sub
' Extracts a persistent value based on the page and name.
Function GetSavedValue(url, name)
    On Error Resume Next
    id = url & ";" & name
    For i = 0 to numTrackedValues - 1
        If (pageIDs(i) = Right(id, len(pageIDs(i)))) Then
            GetSavedValue = values(i)
            Exit Function
        End If
    Next
    GetSavedValue = ""        ' Not found
End Function
' Clears a persistent value based on the page and name.
Sub ClearValueForPage(url, name)
    On Error Resume Next
    id = url & ";" & name
    For i = 0 to numTrackedValues - 1
        If (pageIDs(i) = Right(id, len(pageIDs(i)))) Then
            last = numTrackedValues - 1
            If (i <> last) Then
                pageIDs(i) = pageIDs(last)
                values(i) = values(last)
            End If
            numTrackedValues = numTrackedValues - 1
            Exit Sub
        End If
    Next
End Sub
' ____________________________________________________________________________
' Set up some local variables so we can refer to the two frames by name.
' (The accdp: protocol means we're running within Access.)
If (window.location.protocol <> "accdp:") Then
    On Error Resume Next
    Set navFrame = top.frames(0)
    Set mainFrame = top.frames(1)
End if
' This script is used in conjunction with NavWithFilter
' to set the server filter for the current page after a navigation.
If (window.location.protocol <> "accdp:") Then
    sf = parent.navFrame.SavedFilter(window.location.href)
    If (sf <> "") Then
        On Error Resume Next
        n = MSODSC.RecordSetDefs.count-1
        MSODSC.RecordSetDefs.item(n).ServerFilter = sf
    End If 
End If
' ____________________________________________________________________________
' Formatting Routines
' MakeFieldLookLikeLink makes the specified field object(s) look like links
' and shows a browser hand when the user mouses over them.
Sub MakeFieldLookLikeLink(field)
    On Error Resume Next
    n = field.length-1
    If (Err.Number <> 0) Then       ' There is 1 (or no) field.
        field.style.cursor = "hand"
        field.style.color = document.linkColor
        field.style.textDecorationUnderline = true
    Else
        For i = 0 to n
            field(i).style.cursor = "hand"
            field(i).style.color = document.linkColor
            field(i).style.textDecorationUnderline = true
        Next
    End If
End Sub
' ____________________________________________________________________________
' Navigation Routines
' NavToPage navigates to a page without a server filter in effect.
' Although this is usually used with unbound pages, we clear theserver filter to make sure.
Sub NavToPage(url)
    On Error Resume Next
    navFrame.NavFrameWithServerFilter self, url, ""   
End Sub
' NavWithServerFilter navigates the current frame to a different page
' with a server filter in effect.
Sub NavWithServerFilter(url, serverfilter)
    On Error Resume Next
    navFrame.NavFrameWithServerFilter self, url, serverfilter   
End Sub
' The following two routines extract a (usually hidden) field value
' and navigate to a destination page with a server filter based on
' that field value. They require that the field names in the source
' and destination pages be the same.
Sub NavWithServerFilterFromNumericField(url, fieldname)
    On Error Resume Next
    Set section = MSODSC.GetContainingSection(window.event.srcElement)
    Set field = section.HTMLContainer.all(fieldname)
    NavWithServerFilter url, fieldname & "=" & field.innerText
End Sub
Sub NavWithServerFilterFromTextField(url, fieldname)
    On Error Resume Next
    Set section = MSODSC.GetContainingSection(window.event.srcElement)
    Set field = section.HTMLContainer.all(fieldname)
    NavWithServerFilter url, fieldname & "='" & field.innerText & "'"
End Sub
' HideNavControlIfNotNeeded checks if we're showing all of the records
' and hides the navigation control if we are. This routine just hides
' the navigation control, but if some navigation control functions were
' needed, it could hide or show specific buttons on the control.
Sub HideNavControlIfNotNeeded(navctrl)
    On Error Resume Next
    nShown = MSODSC.DataPages(0).GroupLevel.DataPageSize
    nAvail = MSODSC.DataPages(0).RecordSet.RecordCount
    If (nShown >= nAvail) Then
        navctrl.style.visibility = "hidden"
    End If
End Sub
Function RecordsAreShown
    On Error Resume Next
    RecordsAreShown = (MSODSC.DataPages(0).RecordSet.RecordCount <> 0)
End Function
Sub ShowMessageIfNoRecords(message)
    On Error Resume Next
    If (not RecordsAreShown) Then
        message.style.visibility = "visible"
    End If
End Sub
Sub ShowPosition(message)
    On Error Resume Next
	message.style.visibility = "visible"
End Sub
' ____________________________________________________________________________
' Navigation and Filtering
' The following routines keep track of a server filter for any pages
' that we've visited. This allows you to return to the page and have
' the previous server filter stay in effect.
Sub SaveFilterForPage(url, serverfilter)
    On Error Resume Next
    SaveValueForPage url, "FILTER", serverfilter
End Sub
Sub NavFrameWithServerFilter(frame, url, serverfilter)
    On Error Resume Next
    SaveFilterForPage url, serverfilter
    frame.location.href = url
End Sub
Function NavCurrentServerFilter(url)
    On Error Resume Next
    NavCurrentServerFilter = GetSavedValue(url, "FILTER")
End Function
' ____________________________________________________________________________
' Inset Frame (IFrame) Routines
' CreateInsetFrame creates an IFrame within a placeholder object. This is done
' at run time since the data access page designer doesn't support IFrames.
' This technique allows you to lay out your page with the placeholder object.
' The placeholder object normally looks like this:
'     <SPAN id=iframePlaceholder style="BORDER: none; HEIGHT: 220px; WIDTH: 520px">
'     Placeholder text here
'     </SPAN>
' This would be followed by the following call at page-load time:
'     CreateInsetFrame("iframePlaceholder")
' The IFrame will completely fill the placeholder, with no border.
' If you want a border style for the IFrame, set it on the placeholder.
Sub CreateInsetFrame(frameName, placeholderName, source, filter)
    On Error Resume Next
    Execute "Set obj = " & placeholderName
    iframeHTML = "<IFRAME id=""" & frameName & """" & _
        "FRAMEBORDER=no HEIGHT=" & obj.style.height & _
        " WIDTH=" & obj.style.width & "></IFRAME>"
    obj.innerHTML = iframeHTML
    navFrame.SaveFilterForPage source, filter
    Execute frameName & ".location.href = """ & source & """"
End Sub
Sub ResetInsetFrame(frameName, source, filter)
    navFrame.SaveFilterForPage source, filter
    Execute frameName & ".location.href = """ & source & """"
End Sub
' ____________________________________________________________________________
' Setup Routines
' These are called when the page is loaded.
' AutoSetServerFilter is used by NavWithServerFilter to set the ServerFilter property
' for the current page to the intended value after a navigation. This also works 
' to restore the filter if the user navigates away from the page and then back.
Sub AutoSetServerFilter
    On Error Resume Next
    If (window.location.protocol <> "accdp:") Then
        sf = navFrame.NavCurrentServerFilter(window.location.href)
        If (sf <> "") Then
            On Error Resume Next
            n = MSODSC.RecordSetDefs.count-1
            MSODSC.RecordSetDefs.item(n).ServerFilter = sf
        End If 
    End If
End Sub
Function ObjectExists(objName)
    On Error Resume Next
    Execute "Set obj = " & objName
    ObjectExists = (Err.number = 0)
End Function
' AutoConnectToDatabase connects the page to the appropriate copy
' of the database. This allows us to test with a local copy and
' have the pages automatically switch to using a remote provider
' (three tier) when we switch to the web site.
Sub AutoConnectToDatabase
    On Error Resume Next
    If (ObjectExists("MSODSC")) Then        ' Make sure we have a Data Source control.
        If (window.location.protocol = "http:") Then
            MSODSC.UseRemoteProvider = true
        End If
    End If
End Sub
' ____________________________________________________________________________
' General-Purpose Cookie Routines
' These are slightly modified from routines used on the Microsoft web site.
Function GetCookie(name)
    On Error Resume Next
    nameLen = Len(name)
    loc = Instr(Document.Cookie, name)
    If loc = 0 Then
        GetCookie = ""
    Else
        strTemp = Right(Document.Cookie, Len(Document.Cookie) - loc + 1)
        If Mid(strTemp, nameLen + 1, 1) <> "=" Then
            GetCookie = ""
        Else
            intNextSemicolon = Instr(strTemp, ";")
            If intNextSemicolon = 0 Then
                intNextSemicolon = Len(strTemp) + 1
            End If
            If intNextSemicolon = (nameLen + 2) Then
                GetCookie = ""
            Else
                intValueLength = intNextSemicolon - nameLen - 2
                GetCookie = Mid(strTemp, nameLen + 2, intValueLength)
            End If
        End If
    End if
End Function
Sub SetCookie(name, value, expires, path, domain, secure)
    On Error Resume Next
    setStr = name & "=" & value
    If (expires <> "") Then setStr = setStr & "; expires=" & expires
    If (path <> "") Then setStr = setStr & "; path=" & path
    If (domain <> "") Then setStr = setStr & "; domain=" & domain
    If (secure) Then setStr = setStr & "; secure"
    document.cookie = setStr
End Sub
Sub DeleteCookie(name, path, domain)
    On Error Resume Next
    If (GetCookie(name) <> "") Then
        SetCookie name, "", "Thu, 01-Jan-70 00:00:01 GMT", path, domain, false
    End If
End Sub
' ____________________________________________________________________________
' Customized Cookie Routines
Const subDelim = "^"
Sub SetCookieValue(name, value)
    On Error Resume Next
    SetCookie name, value, "Mon, 31-Dec-2010 11:59:59 GMT", "", "", false
End Sub
Sub DeleteCookieValue(name)
    On Error Resume Next
    DeleteCookie name, "", ""
End Sub
Sub AppendCookieSubValue(name, value)
    On Error Resume Next
    str = GetCookie(name)
    If (str = "") Then
        SetCookieValue name, value
    Else
        SetCookieValue name, str & subDelim & value
    End If
End Sub
Function NumCookieSubValues(name)
    On Error Resume Next
    n = 0
    str = GetCookie(name)
    If (str = "") Then
        NumCookieSubValues = 0
        Exit Function
    End If
    i = Instr(str, subDelim)
    Do While (i <> 0)
        n = n + 1
        str = Right(str, Len(str) - i)
        i = Instr(str, subDelim)    
    Loop
    NumCookieSubValues = n + 1
End Function
Function GetCookieSubValue(name, n)
    On Error Resume Next
    str = GetCookie(name) & subDelim
    i = Instr(str, subDelim)
    Do While (i <> 0)
        If (n = 1) Then
            GetCookieSubValue = Left(str, i-1) 
            Exit Function
        End If
        n = n - 1
        str = Right(str, Len(str) - i)
        i = Instr(str, subDelim)    
    Loop
    GetCookieSubValue = ""
End Function
Sub AddToCookieValue(name, value)
    On Error Resume Next
    str = GetCookie(name)
    If (str = "") Then
        SetCookieValue name, CStr(value)
    Else
        newValue = CDbl(str) + CDbl(value)
        SetCookieValue name, CStr(newValue)
    End If
End Sub
' Call the setup routines now.
AutoConnectToDatabase
AutoSetServerFilter

