/*	$NetBSD: dm816.h,v 1.1.1.1 2018/04/28 18:25:53 jmcneill Exp $	*/

/*
 * Copyright 2017 Texas Instruments, Inc.
 *
 * This software is licensed under the terms of the GNU General Public
 * License version 2, as published by the Free Software Foundation, and
 * may be copied, distributed, and modified under those terms.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */
#ifndef __DT_BINDINGS_CLK_DM816_H
#define __DT_BINDINGS_CLK_DM816_H

#define DM816_CLKCTRL_OFFSET	0x0
#define DM816_CLKCTRL_INDEX(offset)	((offset) - DM816_CLKCTRL_OFFSET)

/* default clocks */
#define DM816_USB_OTG_HS_CLKCTRL	DM816_CLKCTRL_INDEX(0x58)

/* alwon clocks */
#define DM816_UART1_CLKCTRL	DM816_CLKCTRL_INDEX(0x150)
#define DM816_UART2_CLKCTRL	DM816_CLKCTRL_INDEX(0x154)
#define DM816_UART3_CLKCTRL	DM816_CLKCTRL_INDEX(0x158)
#define DM816_GPIO1_CLKCTRL	DM816_CLKCTRL_INDEX(0x15c)
#define DM816_GPIO2_CLKCTRL	DM816_CLKCTRL_INDEX(0x160)
#define DM816_I2C1_CLKCTRL	DM816_CLKCTRL_INDEX(0x164)
#define DM816_I2C2_CLKCTRL	DM816_CLKCTRL_INDEX(0x168)
#define DM816_TIMER1_CLKCTRL	DM816_CLKCTRL_INDEX(0x170)
#define DM816_TIMER2_CLKCTRL	DM816_CLKCTRL_INDEX(0x174)
#define DM816_TIMER3_CLKCTRL	DM816_CLKCTRL_INDEX(0x178)
#define DM816_TIMER4_CLKCTRL	DM816_CLKCTRL_INDEX(0x17c)
#define DM816_TIMER5_CLKCTRL	DM816_CLKCTRL_INDEX(0x180)
#define DM816_TIMER6_CLKCTRL	DM816_CLKCTRL_INDEX(0x184)
#define DM816_TIMER7_CLKCTRL	DM816_CLKCTRL_INDEX(0x188)
#define DM816_WD_TIMER_CLKCTRL	DM816_CLKCTRL_INDEX(0x18c)
#define DM816_MCSPI1_CLKCTRL	DM816_CLKCTRL_INDEX(0x190)
#define DM816_MAILBOX_CLKCTRL	DM816_CLKCTRL_INDEX(0x194)
#define DM816_SPINBOX_CLKCTRL	DM816_CLKCTRL_INDEX(0x198)
#define DM816_MMC1_CLKCTRL	DM816_CLKCTRL_INDEX(0x1b0)
#define DM816_GPMC_CLKCTRL	DM816_CLKCTRL_INDEX(0x1d0)
#define DM816_DAVINCI_MDIO_CLKCTRL	DM816_CLKCTRL_INDEX(0x1d4)
#define DM816_EMAC1_CLKCTRL	DM816_CLKCTRL_INDEX(0x1d8)
#define DM816_MPU_CLKCTRL	DM816_CLKCTRL_INDEX(0x1dc)
#define DM816_RTC_CLKCTRL	DM816_CLKCTRL_INDEX(0x1f0)
#define DM816_TPCC_CLKCTRL	DM816_CLKCTRL_INDEX(0x1f4)
#define DM816_TPTC0_CLKCTRL	DM816_CLKCTRL_INDEX(0x1f8)
#define DM816_TPTC1_CLKCTRL	DM816_CLKCTRL_INDEX(0x1fc)
#define DM816_TPTC2_CLKCTRL	DM816_CLKCTRL_INDEX(0x200)
#define DM816_TPTC3_CLKCTRL	DM816_CLKCTRL_INDEX(0x204)

#endif
