/*	$NetBSD: imx7reg.h,v 1.1 2016/05/17 06:44:45 ryo Exp $	*/

/*
 * Copyright (c) 2015 Internet Initiative Japan, Inc.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef _ARM_IMX_IMX7_REG_H_
#define _ARM_IMX_IMX7_REG_H_

#define IMX7_IOREG_PBASE		IMX7_AIPS_BASE
#define IMX7_IOREG_SIZE			IMX7_AIPS_SIZE

#define IMX7_ARMCORE_PBASE		IMX7_ARMCORE_BASE

#define IMX7_IO_SIZE			(IMX7_AIPS_SIZE + IMX7_ARMCORE_SIZE)

#define IMX7_MEM_BASE			0x80000000
#define IMX7_MEM_SIZE			0x80000000

#define IMX7_FLASH_QSPI_BASE		0x60000000
#define IMX7_FLASH_QSPI_SIZE		0x20000000

#define IMX7_PCIE_BASE			0x40000000
#define IMX7_PCIE_SIZE			0x20000000

#define IMX7_QSPI_RBUF_BASE		0x34000000
#define IMX7_QSPI_RBUF_SIZE		0x02000000

#define IMX7_PCIE_REG_BASE		0x33800000
#define IMX7_PCIE_REG_SIZE		0x00004000

#define IMX7_APBH_DMA_BASE		0x33000000
#define IMX7_APBH_DMA_SIZE		0x00008000

#define IMX7_GPV7_BASE			0x32700000
#define IMX7_GPV6_BASE			0x32600000
#define IMX7_GPV5_BASE			0x32500000
#define IMX7_GPV4_BASE			0x32400000
#define IMX7_GPV3_BASE			0x32300000
#define IMX7_GPV2_BASE			0x32200000
#define IMX7_GPV1_BASE			0x32100000
#define IMX7_GPV0_BASE			0x32000000
#define IMX7_GPV_SIZE			0x00100000

#define IMX7_ARMCORE_BASE		0x31000000
#define IMX7_ARMCORE_SCU_BASE		IMX7_ARMCORE_BASE
#define IMX7_ARMCORE_SIZE		0x00400000

#define IMX7_AIPS_BASE			0x30000000
#define IMX7_AIPS_SIZE			0x00c00000

#define IMX7_EIM_BASE			0x28000000
#define IMX7_EIM_SIZE			0x08000000

#define IMX7_OCRAM_BASE			0x00900000
#define IMX7_OCRAM_SIZE			0x00040000

#define IMX7_TCMU_BASE			0x007f8000
#define IMX7_TCML_BASE			0x00800000
#define IMX7_TCM_SIZE			0x00008000

#define IMX7_OCRAM_S_BASE		0x00180000
#define IMX7_OCRAM_S_SIZE		0x00008000

#define IMX7_CAAM_BASE			0x00100000
#define IMX7_CAAM_SIZE			0x00008000

#define IMX7_ROMCP_P_BASE		0x00017000
#define IMX7_ROMCP_P_SIZE		0x00001000

#define IMX7_ROMCP_BASE			0x00000000
#define IMX7_ROMCP_SIZE			0x00017000

/* AIPS_BASE:0x30000000 + AIPSx_xxxx_BASE */
#define AIPS3_ENET2_BASE		0x00bf0000
#define AIPS3_ENET1_BASE		0x00be0000
#define AIPS3_SDMA_BASE			0x00bd0000
#define AIPS3_EIM_BASE			0x00bc0000
#define AIPS3_QSPI_BASE			0x00bb0000
#define AIPS3_SIM2_BASE			0x00ba0000
#define AIPS3_SIM1_BASE			0x00b90000
#define AIPS3_USDHC3_BASE		0x00b60000
#define AIPS3_USDHC2_BASE		0x00b50000
#define AIPS3_USDHC1_BASE		0x00b40000
#define AIPS3_USDHC_SIZE		0x00000100
#define AIPS3_USB_BASE			0x00b10000
#define AIPS3_USB_SIZE			0x00030000
#define AIPS3_USB_PL301_BASE		0x00ad0000
#define AIPS3_SEMAPHORE_HS_BASE		0x00ac0000
#define AIPS3_MU_B_BASE			0x00ab0000
#define AIPS3_MU_A_BASE			0x00aa0000
#define AIPS3_UART7_BASE		0x00a90000
#define AIPS3_UART6_BASE		0x00a80000
#define AIPS3_UART5_BASE		0x00a70000
#define AIPS3_UART4_BASE		0x00a60000
#define AIPS3_I2C4_BASE			0x00a50000
#define AIPS3_I2C3_BASE			0x00a40000
#define AIPS3_I2C2_BASE			0x00a30000
#define AIPS3_I2C1_BASE			0x00a20000
#define AIPS3_FLEXCAN2_BASE		0x00a10000
#define AIPS3_FLEXCAN1_BASE		0x00a00000
#define AIPS3_AIPS3_CONF_BASE		0x009f0000
#define AIPS3_CAAM_BASE			0x00900000
#define AIPS3_SPBA_BASE			0x008f0000
#define AIPS3_SAI3_BASE			0x008c0000
#define AIPS3_SAI2_BASE			0x008b0000
#define AIPS3_SAI1_BASE			0x008a0000
#define AIPS3_UART3_BASE		0x00880000
#define AIPS3_UART2_BASE		0x00870000
#define AIPS3_UART1_BASE		0x00860000
#define AIPS3_ECSPI3_BASE		0x00840000
#define AIPS3_ECSPI2_BASE		0x00830000
#define AIPS3_ECSPI1_BASE		0x00820000

#define AIPS2_AXI_DEBUG_MON_BASE	0x007e0000
#define AIPS2_PERFMON2_BASE		0x007d0000
#define AIPS2_PERFMON1_BASE		0x007c0000
#define AIPS2_DDRC_BASE			0x007a0000
#define AIPS2_DDR_PHY_BASE		0x00790000
#define AIPS2_TZASC_BASE		0x00780000
#define AIPS2_MIPI_DSI_BASE		0x00760000
#define AIPS2_MIPI_CSI_BASE		0x00750000
#define AIPS2_LCDIF_BASE		0x00730000
#define AIPS2_CSI_BASE			0x00710000
#define AIPS2_PXP_BASE			0x00700000
#define AIPS2_EPDC_BASE			0x006f0000
#define AIPS2_PCIE_PHY_BASE		0x006d0000
#define AIPS2_SYSCOUNTER_CTRL_BASE	0x006c0000
#define AIPS2_SYSCOUNTER_CMP_BASE	0x006b0000
#define AIPS2_SYSCOUNTER_RD_BASE	0x006a0000
#define AIPS2_PWM4_BASE			0x00690000
#define AIPS2_PWM3_BASE			0x00680000
#define AIPS2_PWM2_BASE			0x00670000
#define AIPS2_PWM1_BASE			0x00660000
#define AIPS2_FLEXTIMER2_BASE		0x00650000
#define AIPS2_FLEXTIMER1_BASE		0x00640000
#define AIPS2_ECSPI4_BASE		0x00630000
#define AIPS2_ADC2_WRAPPER_BASE		0x00620000
#define AIPS2_ADC1_WRAPPER_BASE		0x00610000
#define AIPS2_AIPS2_CONF_BASE		0x005f0000

#define AIPS1_CSU_BASE			0x003e0000
#define AIPS1_RDC_BASE			0x003d0000
#define AIPS1_SEMAPHORE2_BASE		0x003c0000
#define AIPS1_SEMAPHORE1_BASE		0x003b0000
#define AIPS1_GPC_BASE			0x003a0000
#define AIPS1_SRC_BASE			0x00390000
#define AIPS1_SRC_SIZE			0x00001004
#define AIPS1_CCM_BASE			0x00380000
#define AIPS1_SNVS_BASE			0x00370000
#define AIPS1_SNVS_SIZE			0x00000c00
#define AIPS1_CCM_ANALOG_BASE		0x00360000
#define AIPS1_OCOTP_CTRL_BASE		0x00350000
#define AIPS1_IOMUXC_GPR_BASE		0x00340000
#define AIPS1_IOMUXC_BASE		0x00330000
#define AIPS1_KPP_BASE			0x00320000
#define AIPS1_ROMCP_BASE		0x00310000
#define AIPS1_GPT4_BASE			0x00300000
#define AIPS1_GPT3_BASE			0x002f0000
#define AIPS1_GPT2_BASE			0x002e0000
#define AIPS1_GPT1_BASE			0x002d0000
#define AIPS1_IOMUXC_LPSR_BASE		0x002c0000
#define AIPS1_WDOG4_BASE		0x002b0000
#define AIPS1_WDOG3_BASE		0x002a0000
#define AIPS1_WDOG2_BASE		0x00290000
#define AIPS1_WDOG1_BASE		0x00280000
#define AIPS1_WDOG_SIZE			0x00000010
#define AIPS1_IOMUXC_LPSR_GPR_BASE	0x00270000
#define AIPS1_GPIO7_BASE		0x00260000
#define AIPS1_GPIO6_BASE		0x00250000
#define AIPS1_GPIO5_BASE		0x00240000
#define AIPS1_GPIO4_BASE		0x00230000
#define AIPS1_GPIO3_BASE		0x00220000
#define AIPS1_GPIO2_BASE		0x00210000
#define AIPS1_GPIO1_BASE		0x00200000
#define GPIO_NGROUPS			7
#define AIPS1_AIPS1_CONF_BASE		0x001f0000
#define AIPS1_DAP_BASE			0x00000000

#endif /* _ARM_IMX_IMX7_REG_H_ */
