//===----------------------------------------------------------------------===//
//
//                     The LLVM Compiler Infrastructure
//
// This file is dual licensed under the MIT and the University of Illinois Open
// Source Licenses. See LICENSE.TXT for details.
//
//===----------------------------------------------------------------------===//

// <functional>

// template <class T>
// struct hash
//     : public unary_function<T, size_t>
// {
//     size_t operator()(T val) const;
// };

// Not very portable

#include <experimental/string_view>
#include <cassert>
#include <type_traits>

using std::experimental::string_view;

template <class T>
void
test()
{
    typedef std::hash<T> H;
    static_assert((std::is_base_of<std::unary_function<T, std::size_t>,
                                   H>::value), "");
    H h;
//     std::string g1 = "1234567890";
//     std::string g2 = "1234567891";
    typedef typename T::value_type char_type;
    char_type g1 [ 10 ];
    char_type g2 [ 10 ];
    for ( int i = 0; i < 10; ++i )
        g1[i] = g2[9-i] = '0' + i;
    T s1(g1, 10);
    T s2(g2, 10);
    assert(h(s1) != h(s2));
}

int main()
{
    test<std::experimental::string_view>();
#ifndef _LIBCPP_HAS_NO_UNICODE_CHARS
    test<std::experimental::u16string_view>();
    test<std::experimental::u32string_view>();
#endif  // _LIBCPP_HAS_NO_UNICODE_CHARS
    test<std::experimental::wstring_view>();
}
