#include <adv.t>                  /* read generic adventure game "adv.t" */
#include <std.t>                          /* read standard underpinnings */

#include "actors.t"    // the actors
#include "phone.t"     // telephone handling

/*
 *   The init() function is run at the very beginning of the game.
 *   We display some introductory text, then move the player (Me) to the
 *   initial location and set up some background activity.
 */
replace init: function
{
    // Initialize phone.t stuff
    init_phone();

    // I know joe's number
    Me.phone_known := [joe];

    "He loves her, and she loves him
    \nAnd he loves somebody else, you just can't win....
    \nI've had the blues, the reds and the pinks.
    \nOne thing's for sure....

    \b\(Love Stinks\)
    \nphone.t test script by Amir Karger\b";

    setdaemon( turncount, nil );               // start the turn counter daemon
    Me.location := startroom;                // move player to initial location
    startroom.enterRoom(Me); // initialize room; look around
}

////////////////
// ROOMS
startroom: room
    sdesc = "Your Room"
    ldesc = "It's your room. It's bare, except for a phone. Joe's room is
    east. You can exit the apartment to the west."
    east = joe_room
    west = hall
;

main_phone: fixed_phone
    adjective = 'white'
    sdesc = "white phone"
    ldesc = "It's a standard white wall phone. "
    location = startroom
    phone_number = 333
;

addressbook: readable
    location = Me
    noun = 'book' 'addressbook'
    adjective = 'address'
    sdesc = "address book"
    adesc = "an address book"
    ldesc = "It's your address book. "
    readdesc = {
        "Jane: <<jane.phone_number>> ";
	if (find(Me.phone_known, jane) = nil) Me.phone_known += jane;
    }
;

// Hall
hall: room
    sdesc = "Hallway"
    ldesc = "This is the hallway. Your room is to the east. The street
    is to the west. "
    east = startroom
    west = street
;

nokia: mobile_phone
    adjective = 'mobile'
    sdesc = "mobile phone"
    ldesc = "It's a mobile phone. You could, say, walk around and 
        call people with it. "
    location = hall
    phone_number = 444
;

// Street
street: room
    sdesc = "Street"
    ldesc = "This is the street. The apartment building can be entered
    to the east. "
    east = hall
;

// Joe's room
joe_room: room
    sdesc = "Joe's Room"
    ldesc = "It's Joe's room. It's bare, except for a phone. Your room is
    west."
    west = startroom
;

joe_phone: fixed_phone
    location = joe_room
    phone_number = joe.phone_number
;

// dummy room
jane_room: room
;

jane_phone: fixed_phone
    location = jane_room
    phone_number = jane.phone_number
    no_answer = {
	"Noone answers. She must be on a date with Joe. You wallow in
	self-pity. ";
    }
;

// all phones in the game can dial only 3-digit numbers
modify phone
    valid_phone_num(actor, num) = {
        if (num < 100 or num > 999) {
	    "Only three-digit numbers are allowed in this game. "; 
	    return nil;
	}
	return true;
    }
    valid_phone_str(actor, str) = {
	"Dialing a string in quotes isn't allowed in this game.
	Just try something like DIAL 333. ";
	return nil;
    }
;
