/**************************************
	Fichero de cabecera de
	las funciones de manejo
	de ficheros PCX de PCX.C
**************************************/

#if !defined (PCX_H)
#define PCX_H

/*** Macros ***/
#define RGB(r,g,b) (((long)((b) << 8 | (g)) << 8) | (r))

/*** Constantes ***/
#define TAMLINPCX16	80	/* tamao de 1 plano de lnea 16 colores */
#define TAMLINPCX256	320     /* tamao de lnea 256 colores */
#define TAMLINPCX256X	90      /* tamao de lnea modo extendido 256 colores */

/* cdigos de error de las funciones de decodificacin de ficheros PCX */
#define E_PCX_APER  1           /* error de apertura de fichero */
#define E_PCX_LECT  2           /* error de lectura de fichero */
#define E_PCX_FORM  3           /* formato de fichero no vlido */
#define E_PCX_MODO  4           /* modo de pantalla incorrecto */
#define E_PCX_MEM   5           /* no hay memoria suficiente para imagen */

/*** Tipos de datos y estructuras ***/
#if !defined (BYTE)
#define BYTE unsigned char
#endif

/* cabecera de fichero PCX */
typedef struct {
	BYTE propietario;       /* debera ser siempre 0x0A */
	BYTE version;           /* version del fichero PCX */
	BYTE metodo_codif;      /* 1=codificacin PCX 'run-lenght' */
	BYTE bits_pixel;        /* nmero de bits por pixel */
	int ventana[4];         /* tamao dibujo (izq., arr., der., abajo) */
	int resh, resv;         /* resolucin horizontal y vertical */
	BYTE paleta[16][3];     /* informacin de paleta para la imagen */
	BYTE reserv1;
	BYTE num_planos;        /* nmero de planos de color */
	int bytes_scan;         /* nmero de bytes por plano de lnea scan */
	BYTE reserv2[60];
} STC_CABPCX;

/* imagen decodificada */
typedef struct {
	int ancho, alto;        /* dimensiones en pixels */
	int num_colores;        /* nmero de colores (mx. 256) */
	BYTE paleta[256][3];    /* paleta RGB de colores */
	BYTE far *(*lineas);	/* punteros a lneas de imagen */
} STC_IMAGEN;

/*** Prototipos ***/
int pcx_decodifica(char *nombre_pcx, STC_IMAGEN *imagen);
void pcx_libera_mem(STC_IMAGEN *imagen);
int pcx_dibuja(STC_IMAGEN *imagen, int x, int y, int anchura, int altura,
  int paleta);
int pcx_visualiza(char *nombre_pcx, int x, int y, int anchura, int altura,
  int paleta);

#endif  /* PCX_H */
