!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! 2002.02.28 ORRockDispensor	[GLULX]
! An object to generate GLULX rocks dynamically, so modules do not confict.
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

!--------------------------------------------------------------------------------------
! Created by Jim Fisher
! AutoDep :	none
!--------------------------------------------------------------------------------------
! In GLULX, defining a rock is as simple as choosing an arbitrary number within a 
! specified range.  (i.e.: window rocks: 210 or above, stream rocks: 310 or above, 
! etc.) When creating modules that utilize rocks, this practice becomes problematic, 
! since there is no guarantee that two modules wont select the same rock value for two 
! different uses.  ORRockDispensor is a simple object that modules can utilize to 
! obtain a rock value.  The routines in this object never return the same value twice 
! and honor the ranges for the specific type of rock requested.
!--------------------------------------------------------------------------------------
! To register this module with your library, add the line:
!
!		#include "ORRockDispensor";					!Constant USE_ORRockDispensor; 
!	
!	to the library header file (OR_Library_Include).  To use in a game, add the line:
!
!		Constant USE_ORRockDispensor; to the game file;
!
!	to the game file;
!--------------------------------------------------------------------------------------
! Revision History
! 2002.02.20	Initial Creation
! 2002.02.26	Fit to new template.
! 2002.02.28	Fixed bug with inclusion for GLULX code.
!--------------------------------------------------------------------------------------
#ifdef USE_ORRockDispensor;
	#ifndef TARGET_GLULX;
		message "          Processing library extension ORRockDispensor...ignoring (GLULX only)"; 
	#ifnot;
		message "          Processing library extension ORRockDispensor...";
	#endif;
!--------------------------------------------------------------------------------------
! D E P E N D A N C I E S   section   (for bringing in dependant modules)
#ifndef TARGET_GLULX; default WORDSIZE 2; #ifnot;default WORDSIZE 4; #endif; !--for GLULX compatability
!--- sample forced include---   #ifndef USE_<REPLACEWITHINCLUDENAME>; Constant USE_<REPLACEWITHINCLUDENAME>; message "          ****Forcing inclusion of <REPLACEWITHINCLUDENAME>****"; #include "<REPLACEWITHINCLUDENAME>"; #endif; 
!--------------------------------------------------------------------------------------


!--------------------------------------------------------------------------------------
#ifdef REPLACEPOINT; #ifndef ORRockDispensor_DONEREPLACE; constant ORRockDispensor_DONEREPLACE; 
!--------------------------------------------------------------------------------------
! R E P L A C E   section (for code that preceeds the inclusion of PARSER)
!--------------------------------------------------------------------------------------

!--------------------------------------------------------------------------------------
#endif;#endif;#ifdef MESSAGEPOINT; #ifndef ORRockDispensor_DONEMESSAGE; constant ORRockDispensor_DONEMESSAGE; 
!--------------------------------------------------------------------------------------
! M E S S A G E   section (for code that falls between PARSER and VERBLIB )
!--- Uncomment to check for OREnglish--- #ifndef OREnglish; message "ERROR!!!! ORRockDispensor requires the OREnglish file.";#endif; 
!--------------------------------------------------------------------------------------

!--------------------------------------------------------------------------------------
#endif; #endif; #ifdef CODEPOINT; #ifndef ORRockDispensor_DONECODE;constant ORRockDispensor_DONECODE; 
!--------------------------------------------------------------------------------------
! C O D E   section (for code that falls between VERBLIB and GRAMMAR)
!--------------------------------------------------------------------------------------
	#ifdef TARGET_GLULX;
		object ORRockDispensor 
			with	rock_win	299 !--Count rock requests down. Less likly to conflict with user defined rocks
			,		rock_stream	399
			,		rock_file	499
			,		get_window[; return self.rock_win--;]
			,		get_stream[; return self.rock_stream--;]
			,		get_file[; return self.rock_file--;]
		;
	#endif;
!--------------------------------------------------------------------------------------
#endif; #endif; #ifdef GRAMMARPOINT; #ifndef ORRockDispensor_DONEGRAMMAR; constant ORRockDispensor_DONEGRAMMAR; #ifdef ORRockDispensor_DONEGRAMMAR; #endif; !--just to supress warning
!--------------------------------------------------------------------------------------
! G R A M M A R   section (for code that follows the inclusion of GRAMMAR)
!--------------------------------------------------------------------------------------


!--------------------------------------------------------------------------------------
#endif; #endif; #endif;
